/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.loot;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.helper.Helper;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

@Mod.EventBusSubscriber(modid="midnight")
public class FishingLoot {
    private static final Field fieldPools = ReflectionHelper.findField(LootTable.class, (String[])new String[]{"pools", "field_186466_c"});
    private static final Field fieldPoolConditions = ReflectionHelper.findField(LootPool.class, (String[])new String[]{"poolConditions", "field_186454_b"});

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLootTableLoad(LootTableLoadEvent event) {
        if (event.getName() == LootTableList.field_186387_al) {
            FishingLoot.addConditionToAllMainPools(event.getTable(), (rand, context) -> !Helper.isMidnightDimension((World)context.getWorld()));
            LootTable midnightTable = event.getLootTableManager().func_186521_a(new ResourceLocation("midnight", "fishing"));
            if (midnightTable == LootTable.field_186464_a) {
                Midnight.LOGGER.warn("The Midnight fishing loottable is absent");
            } else {
                LootPool midnightPool = midnightTable.getPool("midnight_fishing");
                event.getTable().addPool(midnightPool);
                FishingLoot.addConditionToPool((rand, context) -> Helper.isMidnightDimension((World)context.getWorld()), midnightPool);
            }
        }
    }

    private static void addConditionToAllMainPools(LootTable table, LootCondition condition) {
        List pools = null;
        try {
            pools = (List)fieldPools.get(table);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (pools != null) {
            for (LootPool pool : pools) {
                FishingLoot.addConditionToPool(condition, pool);
            }
        }
    }

    private static void addConditionToPool(LootCondition condition, LootPool pool) {
        try {
            List conditions = (List)fieldPoolConditions.get(pool);
            conditions.add(condition);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

