/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity;

import com.mushroom.midnight.common.entity.BridgeTracker;
import com.mushroom.midnight.common.entity.EntityRift;
import com.mushroom.midnight.common.entity.RiftAttachment;
import com.mushroom.midnight.common.entity.util.RiftEntityReference;
import com.mushroom.midnight.common.entity.util.ToggleAnimation;
import com.mushroom.midnight.common.registry.ModDimensions;
import com.mushroom.midnight.common.util.BitFlags;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class RiftBridge {
    public final ToggleAnimation open = new ToggleAnimation(20);
    public final ToggleAnimation unstable = new ToggleAnimation(110);
    public boolean used;
    public boolean exists = true;
    private final int id;
    private RiftAttachment attachment;
    private boolean sentOpen;
    private boolean sentUnstable;
    private boolean sentUsed;
    private int ticks;
    private int prevOpenTimer;
    private int prevUnstableTimer;
    private final BridgeTracker tracker = new BridgeTracker(this);
    private final RiftEntityReference source = new RiftEntityReference();
    private final RiftEntityReference target = new RiftEntityReference();

    public RiftBridge(int id, RiftAttachment attachment) {
        this.id = id;
        this.attachment = attachment;
        this.open.set(true);
    }

    public void tickTimers() {
        this.prevOpenTimer = this.open.getTimer();
        this.prevUnstableTimer = this.unstable.getTimer();
        ++this.ticks;
        if (this.open.get()) {
            this.open.setRate(1);
        } else {
            this.open.setRate(2);
        }
        this.open.update();
        this.unstable.update();
    }

    public boolean tickState() {
        EntityRift source;
        this.tracker.update();
        this.trySpawnEndpoint(DimensionType.OVERWORLD);
        this.trySpawnEndpoint(ModDimensions.MIDNIGHT);
        if (this.unstable.get()) {
            if (this.unstable.getTimer() >= 110 && this.open.get()) {
                this.open.set(false);
            }
        } else if (this.ticks > 4000) {
            this.unstable.set(true);
        }
        if ((source = this.getSource()) != null && source.field_70128_L) {
            return true;
        }
        EntityRift target = this.getTarget();
        if (target != null && target.field_70128_L) {
            return true;
        }
        return !this.open.get() && this.open.getTimer() <= 0;
    }

    private void trySpawnEndpoint(DimensionType endpointDimension) {
        WorldServer world;
        RiftEntityReference endpointReference = this.getEndpointReference(endpointDimension);
        if (!endpointReference.hasReference() && (world = DimensionManager.getWorld((int)endpointDimension.func_186068_a())) != null && world.func_175667_e(this.attachment.getPos())) {
            this.spawnRiftEntity((World)world);
        }
    }

    private void spawnRiftEntity(World world) {
        EntityRift rift = new EntityRift(world);
        rift.acceptBridge(this);
        RiftAttachment surfaceAttachment = this.attachment.fixedToSurface(world);
        surfaceAttachment.apply(rift);
        world.func_175726_f(rift.func_180425_c());
        world.func_72838_d((Entity)rift);
    }

    public EntityRift computeEndpoint(DimensionType endpointDimension) {
        EntityRift rift;
        RiftEntityReference endpointReference = this.getEndpointReference(endpointDimension);
        if (!endpointReference.hasReference()) {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            this.spawnRiftEntity((World)server.func_71218_a(endpointDimension.func_186068_a()));
        }
        if ((rift = endpointReference.compute()) == null) {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            this.spawnRiftEntity((World)server.func_71218_a(endpointDimension.func_186068_a()));
        }
        return endpointReference.get();
    }

    public boolean isEndpointLoaded(DimensionType endpointDimension) {
        WorldServer world = DimensionManager.getWorld((int)endpointDimension.func_186068_a());
        return world != null && world.func_175667_e(this.attachment.getPos());
    }

    public void writeState(ByteBuf buffer) {
        buffer.writeByte((int)new BitFlags().withBit(0, this.open.get()).withBit(1, this.unstable.get()).withBit(2, this.used).toInner());
        buffer.writeInt((this.ticks & 0xFFFF) << 16 | (this.open.getTimer() & 0xFF) << 8 | this.unstable.getTimer() & 0xFF);
    }

    public void handleState(ByteBuf buffer) {
        BitFlags flags = new BitFlags(buffer.readByte());
        this.open.set(flags.getBit(0));
        this.unstable.set(flags.getBit(1));
        this.used = flags.getBit(2);
        long packedTimers = buffer.readUnsignedInt();
        this.ticks = (int)(packedTimers >> 16 & 0xFFFFL);
        this.open.setTimer((int)(packedTimers >> 8 & 0xFFL));
        this.unstable.setTimer((int)(packedTimers & 0xFFL));
    }

    public void clearDirt() {
        this.sentOpen = this.open.get();
        this.sentUnstable = this.unstable.get();
        this.sentUsed = this.used;
    }

    public boolean isDirty() {
        return this.sentOpen != this.open.get() || this.sentUnstable != this.unstable.get() || this.sentUsed != this.used;
    }

    public int getId() {
        return this.id;
    }

    public void setAttachment(RiftAttachment attachment) {
        this.attachment = attachment;
    }

    public RiftAttachment getAttachment() {
        return this.attachment;
    }

    public float getOpenAnimation(float partialTicks) {
        return (float)this.prevOpenTimer + (float)(this.open.getTimer() - this.prevOpenTimer) * partialTicks;
    }

    public float getUnstableAnimation(float partialTicks) {
        return (float)this.prevUnstableTimer + (float)(this.unstable.getTimer() - this.prevUnstableTimer) * partialTicks;
    }

    public int getTimeUntilClose() {
        if (this.unstable.get()) {
            return 0;
        }
        return Math.max(4000 - this.ticks, 0);
    }

    public void accept(EntityRift rift) {
        DimensionType endpointDimension = rift.field_70170_p.field_73011_w.func_186058_p();
        this.getEndpointReference(endpointDimension).set(rift);
    }

    private RiftEntityReference getEndpointReference(DimensionType endpointDimension) {
        return endpointDimension == ModDimensions.MIDNIGHT ? this.target : this.source;
    }

    public void close() {
        this.used = true;
        this.unstable.set(true);
    }

    public BridgeTracker getTracker() {
        return this.tracker;
    }

    @Nullable
    public EntityRift getSource() {
        return this.source.get();
    }

    @Nullable
    public EntityRift getTarget() {
        return this.target.get();
    }

    public void remove() {
        this.exists = false;
        this.prevOpenTimer = this.open.getTimer();
        this.prevUnstableTimer = this.unstable.getTimer();
    }

    public NBTTagCompound serialize(NBTTagCompound compound) {
        compound.func_74768_a("id", this.id);
        compound.func_74782_a("attachment", (NBTBase)this.attachment.serialize(new NBTTagCompound()));
        compound.func_74782_a("open", (NBTBase)this.open.serialize(new NBTTagCompound()));
        compound.func_74782_a("unstable", (NBTBase)this.unstable.serialize(new NBTTagCompound()));
        compound.func_74757_a("used", this.used);
        compound.func_74768_a("ticks", this.ticks);
        compound.func_74782_a("source", (NBTBase)this.source.serialize(new NBTTagCompound()));
        compound.func_74782_a("target", (NBTBase)this.target.serialize(new NBTTagCompound()));
        return compound;
    }

    public static RiftBridge deserialize(NBTTagCompound compound) {
        int id = compound.func_74762_e("id");
        RiftAttachment attachment = RiftAttachment.deserialize(compound.func_74775_l("attachment"));
        RiftBridge bridge = new RiftBridge(id, attachment);
        bridge.open.deserialize(compound.func_74775_l("open"));
        bridge.unstable.deserialize(compound.func_74775_l("unstable"));
        bridge.used = compound.func_74767_n("used");
        bridge.ticks = compound.func_74762_e("ticks");
        bridge.source.deserialize(compound.func_74775_l("source"));
        bridge.target.deserialize(compound.func_74775_l("target"));
        return bridge;
    }

    public String toString() {
        return "RiftBridge{open=" + this.open + ", unstable=" + this.unstable + ", exists=" + this.exists + ", id=" + this.id + '}';
    }
}

