/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.block;

import com.google.common.collect.Lists;
import com.mushroom.midnight.client.IModelProvider;
import com.mushroom.midnight.common.entity.creature.EntityStinger;
import com.mushroom.midnight.common.registry.ModSounds;
import com.mushroom.midnight.common.registry.ModTabs;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class BlockPileOfEggs
extends Block
implements IModelProvider {
    protected static final AxisAlignedBB bound_one_egg = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.75, 0.4375, 0.75);
    protected static final AxisAlignedBB bound_several_eggs = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.4375, 0.9375);
    public static final PropertyInteger EGGS = PropertyInteger.func_177719_a((String)"eggs", (int)1, (int)4);

    protected BlockPileOfEggs() {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)EGGS, (Comparable)Integer.valueOf(1)));
        this.func_149647_a(ModTabs.DECORATION_TAB);
        this.field_149762_H = ModSounds.PILE_OF_EGGS;
        this.field_149782_v = 1.0f;
    }

    protected abstract EntityLiving createEntityForEgg(World var1, BlockPos var2, IBlockState var3);

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player == null) {
            return false;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Item.func_150898_a((Block)this)) {
            if ((Integer)state.func_177229_b((IProperty)EGGS) < 4 && !player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
                player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 10);
                if (!player.field_70170_p.field_72995_K) {
                    if (!player.func_184812_l_()) {
                        stack.func_190918_g(1);
                    }
                    world.func_175656_a(pos, state.func_177226_a((IProperty)EGGS, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)EGGS) + 1)));
                    world.func_184133_a(null, pos, this.field_149762_H.func_185841_e(), SoundCategory.BLOCKS, (this.field_149762_H.func_185843_a() + 1.0f) / 2.0f, this.field_149762_H.func_185847_b() * 0.8f);
                }
            }
            return true;
        }
        return false;
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        if (this.canTrample(entity)) {
            this.onTrample(world, pos, entity, 0.05f);
        }
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        super.func_180658_a(world, pos, entity, fallDistance);
        if (this.canTrample(entity)) {
            this.onTrample(world, pos, entity, 1.0f);
        }
    }

    protected boolean canTrample(Entity entity) {
        return !(entity instanceof EntityStinger);
    }

    protected void onTrample(World world, BlockPos pos, Entity entity, float chance) {
        if (!world.field_72995_K && this.canTrample(entity) && (chance >= 1.0f || world.field_73012_v.nextFloat() <= chance)) {
            this.breakEggs(world, pos, world.func_180495_p(pos));
        }
    }

    protected void breakEggs(World world, BlockPos pos, IBlockState state) {
        EntityLiving creature;
        if (world.field_72995_K) {
            return;
        }
        world.func_184133_a(null, pos, ModSounds.PILE_OF_EGGS.func_185845_c(), SoundCategory.BLOCKS, 0.7f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
        int eggs = (Integer)state.func_177229_b((IProperty)EGGS);
        if (eggs <= 1) {
            world.func_175655_b(pos, false);
        } else {
            world.func_180501_a(pos, state.func_177226_a((IProperty)EGGS, (Comparable)Integer.valueOf(--eggs)), 2);
            world.func_175718_b(2001, pos, BlockPileOfEggs.func_176210_f((IBlockState)state));
        }
        if (this.harvesters.get() != null) {
            ItemStack stack = ((EntityPlayer)this.harvesters.get()).func_184614_ca();
            int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
            ArrayList drops = Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Block)this)});
            float chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)world, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)(EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0 ? 0.6f : 0.2f + 0.1f * (float)fortune), (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
            if (world.field_73012_v.nextFloat() <= chance) {
                drops.forEach(c -> BlockPileOfEggs.func_180635_a((World)world, (BlockPos)pos, (ItemStack)c));
                return;
            }
        }
        try {
            creature = this.createEntityForEgg(world, pos, state);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        creature.func_70080_a((double)((float)pos.func_177958_n() + world.field_73012_v.nextFloat()), (double)((float)pos.func_177956_o() + 0.45f), (double)((float)pos.func_177952_p() + world.field_73012_v.nextFloat()), world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        world.func_72838_d((Entity)creature);
    }

    protected boolean func_149700_E() {
        return false;
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity tile, ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.005f);
        this.harvesters.set(player);
        this.breakEggs(world, pos, state);
        this.harvesters.set(null);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.func_185496_a(state, world, pos);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Integer)state.func_177229_b((IProperty)EGGS) > 1 ? bound_several_eggs : bound_one_egg;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EGGS});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)EGGS, (Comparable)Integer.valueOf((meta & 3) + 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)EGGS) - 1;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }
}

