/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.block;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.client.IModelProvider;
import com.mushroom.midnight.client.particle.MidnightParticles;
import com.mushroom.midnight.common.registry.ModBlocks;
import com.mushroom.midnight.common.registry.ModTabs;
import com.mushroom.midnight.common.tile.base.TileEntityMidnightFurnace;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMidnightFurnace
extends BlockContainer
implements IModelProvider {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private final boolean isBurning;
    private static boolean keepInventory;

    public BlockMidnightFurnace(boolean isBurning) {
        super(Material.field_151576_e);
        this.isBurning = isBurning;
        this.func_149711_c(3.5f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149647_a(ModTabs.DECORATION_TAB);
        if (isBurning) {
            this.func_149715_a(0.4f);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)ModBlocks.MIDNIGHT_FURNACE);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.setDefaultFacing(worldIn, pos, state);
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177978_c());
            IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177968_d());
            IBlockState iblockstate2 = worldIn.func_180495_p(pos.func_177976_e());
            IBlockState iblockstate3 = worldIn.func_180495_p(pos.func_177974_f());
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && iblockstate.func_185913_b() && !iblockstate1.func_185913_b()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && iblockstate1.func_185913_b() && !iblockstate.func_185913_b()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && iblockstate2.func_185913_b() && !iblockstate3.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && iblockstate3.func_185913_b() && !iblockstate2.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World worldIn, BlockPos pos, Random rand) {
        if (this.isBurning) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            double x = (double)pos.func_177958_n() + 0.5;
            double y = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0;
            double z = (double)pos.func_177952_p() + 0.5;
            double outwardOffset = 0.52;
            double sidewardOffset = rand.nextDouble() * 0.6 - 0.3;
            if (rand.nextDouble() < 0.1) {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            switch (facing) {
                case WEST: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x - outwardOffset, y, z + sidewardOffset, 0.0, 0.0, 0.0, new int[0]);
                    MidnightParticles.FURNACE_FLAME.spawn(worldIn, x - outwardOffset, y, z + sidewardOffset, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case EAST: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + outwardOffset, y, z + sidewardOffset, 0.0, 0.0, 0.0, new int[0]);
                    MidnightParticles.FURNACE_FLAME.spawn(worldIn, x + outwardOffset, y, z + sidewardOffset, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case NORTH: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + sidewardOffset, y, z - outwardOffset, 0.0, 0.0, 0.0, new int[0]);
                    MidnightParticles.FURNACE_FLAME.spawn(worldIn, x + sidewardOffset, y, z - outwardOffset, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case SOUTH: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + sidewardOffset, y, z + outwardOffset, 0.0, 0.0, 0.0, new int[0]);
                    MidnightParticles.FURNACE_FLAME.spawn(worldIn, x + sidewardOffset, y, z + outwardOffset, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileEntityMidnightFurnace) {
            playerIn.openGui((Object)Midnight.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            playerIn.func_71029_a(StatList.field_188061_aa);
        }
        return true;
    }

    public static void setState(boolean active, World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        keepInventory = true;
        if (active) {
            worldIn.func_180501_a(pos, ModBlocks.MIDNIGHT_FURNACE_LIT.func_176223_P().func_177226_a((IProperty)FACING, iblockstate.func_177229_b((IProperty)FACING)), 3);
            worldIn.func_180501_a(pos, ModBlocks.MIDNIGHT_FURNACE_LIT.func_176223_P().func_177226_a((IProperty)FACING, iblockstate.func_177229_b((IProperty)FACING)), 3);
        } else {
            worldIn.func_180501_a(pos, ModBlocks.MIDNIGHT_FURNACE.func_176223_P().func_177226_a((IProperty)FACING, iblockstate.func_177229_b((IProperty)FACING)), 3);
            worldIn.func_180501_a(pos, ModBlocks.MIDNIGHT_FURNACE.func_176223_P().func_177226_a((IProperty)FACING, iblockstate.func_177229_b((IProperty)FACING)), 3);
        }
        keepInventory = false;
        if (tileentity != null) {
            tileentity.func_145829_t();
            worldIn.func_175690_a(pos, tileentity);
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityMidnightFurnace();
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity;
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityMidnightFurnace) {
            ((TileEntityMidnightFurnace)tileentity).func_145951_a(stack.func_82833_r());
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity;
        if (!keepInventory && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityMidnightFurnace) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((TileEntityMidnightFurnace)tileentity));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)worldIn.func_175625_s(pos));
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(ModBlocks.MIDNIGHT_FURNACE);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID || layer == BlockRenderLayer.CUTOUT && this.isBurning;
    }

    public int func_185484_c(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (this.isBurning && MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.CUTOUT) {
            return source.func_175626_b(pos, 15);
        }
        return source.func_175626_b(pos, 0);
    }
}

