/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.block;

import com.mushroom.midnight.common.block.BlockMidnightPlant;
import com.mushroom.midnight.common.block.PlantBehaviorType;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMidnightDoublePlant
extends BlockMidnightPlant {
    protected static final PropertyEnum<BlockDoublePlant.EnumBlockHalf> HALF = BlockDoublePlant.field_176492_b;

    public BlockMidnightDoublePlant(PlantBehaviorType behaviorType, boolean glowing) {
        super(behaviorType, glowing);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(HALF, (Comparable)BlockDoublePlant.EnumBlockHalf.LOWER));
    }

    public BlockMidnightDoublePlant(boolean glowing) {
        this(PlantBehaviorType.FLOWER, glowing);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return this.func_185514_i(world.func_180495_p(pos.func_177977_b())) && world.func_175623_d(pos.func_177984_a()) && world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos);
    }

    protected void func_176475_e(World world, BlockPos pos, IBlockState state) {
        if (!this.func_180671_f(world, pos, state)) {
            BlockPos upperPos = this.getUpperPos(state, pos);
            BlockPos lowerPos = this.getLowerPos(state, pos);
            if (this.isLower(state)) {
                this.func_176226_b(world, pos, state, 0);
            }
            this.breakHalf(world, upperPos, 2);
            this.breakHalf(world, lowerPos, 3);
        }
    }

    @Override
    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() != this) {
            return this.func_185514_i(world.func_180495_p(pos.func_177977_b()));
        }
        BlockPos otherPos = this.getOtherPos(state, pos);
        IBlockState otherState = world.func_180495_p(otherPos);
        if (otherState.func_177230_c() != this) {
            return false;
        }
        return this.isUpper(state) || this.func_185514_i(world.func_180495_p(pos.func_177977_b()));
    }

    private BlockPos getUpperPos(IBlockState state, BlockPos pos) {
        return this.isUpper(state) ? pos : pos.func_177984_a();
    }

    private BlockPos getLowerPos(IBlockState state, BlockPos pos) {
        return this.isLower(state) ? pos : pos.func_177977_b();
    }

    private BlockPos getOtherPos(IBlockState state, BlockPos pos) {
        return this.isUpper(state) ? pos.func_177977_b() : pos.func_177984_a();
    }

    private boolean isUpper(IBlockState state) {
        return state.func_177229_b(HALF) == BlockDoublePlant.EnumBlockHalf.UPPER;
    }

    private boolean isLower(IBlockState state) {
        return state.func_177229_b(HALF) == BlockDoublePlant.EnumBlockHalf.LOWER;
    }

    private void breakHalf(World world, BlockPos pos, int flags) {
        if (world.func_180495_p(pos).func_177230_c() == this) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), flags);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a(HALF, (Comparable)BlockDoublePlant.EnumBlockHalf.UPPER), 2);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockPos otherPos = this.getOtherPos(state, pos);
        if (this.isUpper(state)) {
            if (player.field_71075_bZ.field_75098_d) {
                this.breakHalf(world, otherPos, 3);
            } else if (world.field_72995_K) {
                this.breakHalf(world, otherPos, 3);
            } else {
                world.func_175655_b(otherPos, true);
            }
        } else {
            this.breakHalf(world, otherPos, 2);
        }
        super.func_176208_a(world, pos, state, player);
    }

    public int func_176201_c(IBlockState state) {
        return this.isUpper(state) ? 1 : 0;
    }

    public IBlockState func_176203_a(int meta) {
        BlockDoublePlant.EnumBlockHalf half = meta == 1 ? BlockDoublePlant.EnumBlockHalf.UPPER : BlockDoublePlant.EnumBlockHalf.LOWER;
        return this.func_176223_P().func_177226_a(HALF, (Comparable)half);
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HALF});
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (state.func_177229_b(HALF) == BlockDoublePlant.EnumBlockHalf.UPPER) {
            return Items.field_190931_a;
        }
        return super.func_180660_a(state, rand, fortune);
    }
}

