/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.loot;

import com.github.alexthe666.iceandfire.core.ModItems;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.item.ItemDragonEgg;
import com.github.alexthe666.iceandfire.item.ItemDragonFlesh;
import com.github.alexthe666.iceandfire.item.ItemDragonScales;
import com.github.alexthe666.iceandfire.item.ItemDragonSkull;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class CustomizeToDragon
extends LootFunction {
    public CustomizeToDragon(LootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        if (!stack.func_190926_b() && context.func_186493_a() instanceof EntityDragonBase) {
            Random random = new Random();
            EntityDragonBase dragon = (EntityDragonBase)context.func_186493_a();
            if (stack.func_77973_b() == ModItems.dragonbone) {
                stack.func_190920_e(1 + random.nextInt(1 + dragon.getAgeInDays() / 25));
                return stack;
            }
            if (stack.func_77973_b() instanceof ItemDragonScales) {
                stack.func_190920_e(dragon.getAgeInDays() / 25 + random.nextInt(1 + dragon.getAgeInDays() / 5));
                return new ItemStack(dragon.getVariantScale(dragon.getVariant()), stack.func_190916_E(), stack.func_77960_j());
            }
            if (stack.func_77973_b() instanceof ItemDragonEgg) {
                if (dragon.isAdult()) {
                    return new ItemStack(dragon.getVariantEgg(dragon.getVariant()), stack.func_190916_E(), stack.func_77960_j());
                }
                stack.func_190920_e(1 + random.nextInt(1 + dragon.getAgeInDays() / 5));
                return new ItemStack(dragon.getVariantScale(dragon.getVariant()), stack.func_190916_E(), stack.func_77960_j());
            }
            if (stack.func_77973_b() instanceof ItemDragonFlesh) {
                stack.func_190920_e(1 + random.nextInt(1 + dragon.getAgeInDays() / 25));
                return new ItemStack(dragon.isFire ? ModItems.fire_dragon_flesh : ModItems.ice_dragon_flesh, stack.func_190916_E(), stack.func_77960_j());
            }
            if (stack.func_77973_b() instanceof ItemDragonSkull) {
                ItemStack stack1 = new ItemStack(dragon.isFire ? ModItems.dragon_skull : ModItems.dragon_skull, stack.func_190916_E(), stack.func_77960_j());
                stack1.func_77982_d(stack.func_77978_p());
                return stack1;
            }
            if (stack.func_77973_b() == ModItems.fire_dragon_blood || stack.func_77973_b() == ModItems.ice_dragon_blood) {
                return new ItemStack(dragon.isFire ? ModItems.fire_dragon_blood : ModItems.ice_dragon_blood, stack.func_190916_E(), stack.func_77960_j());
            }
            if (stack.func_77973_b() == ModItems.fire_dragon_heart || stack.func_77973_b() == ModItems.ice_dragon_heart) {
                return new ItemStack(dragon.isFire ? ModItems.fire_dragon_heart : ModItems.ice_dragon_heart, stack.func_190916_E(), stack.func_77960_j());
            }
        }
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<CustomizeToDragon> {
        public Serializer() {
            super(new ResourceLocation("iceandfire:customize_to_dragon"), CustomizeToDragon.class);
        }

        public void serialize(JsonObject object, CustomizeToDragon functionClazz, JsonSerializationContext serializationContext) {
        }

        public CustomizeToDragon deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            return new CustomizeToDragon(conditionsIn);
        }
    }
}

