/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.entity.EntityMyrmexBase;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexWorker;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;

public class MyrmexAIForage
extends EntityAIBase {
    private static final int RADIUS = 8;
    private final EntityMyrmexWorker myrmex;
    private final BlockSorter targetSorter;
    private BlockPos targetBlock = BlockPos.field_177992_a;
    private int wanderRadius = 16;

    public MyrmexAIForage(EntityMyrmexWorker myrmex) {
        this.myrmex = myrmex;
        this.targetSorter = new BlockSorter();
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (!this.myrmex.canMove() || this.myrmex.holdingBaby() || !this.myrmex.func_70661_as().func_75500_f() || !this.myrmex.canSeeSky() || this.myrmex.shouldEnterHive() || !this.myrmex.keepSearching) {
            return false;
        }
        ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)this.myrmex.func_180425_c().func_177982_a(-8, -8, -8), (BlockPos)this.myrmex.func_180425_c().func_177982_a(8, 8, 8))) {
            if (!EntityMyrmexBase.isEdibleBlock(this.myrmex.field_70170_p.func_180495_p(pos))) continue;
            allBlocks.add(pos);
            this.myrmex.keepSearching = false;
        }
        if (allBlocks.isEmpty()) {
            this.myrmex.keepSearching = true;
            this.wanderRadius += 8;
            Vec3d vec = RandomPositionGenerator.func_75463_a((EntityCreature)this.myrmex, (int)this.wanderRadius, (int)7);
            if (vec != null) {
                this.targetBlock = new BlockPos(vec);
            }
            return true;
        }
        allBlocks.sort(this.targetSorter);
        this.targetBlock = (BlockPos)allBlocks.get(0);
        return true;
    }

    public boolean func_75253_b() {
        if (!this.myrmex.keepSearching && this.targetBlock == null) {
            return false;
        }
        if (this.myrmex.shouldEnterHive()) {
            this.myrmex.keepSearching = false;
            return false;
        }
        return this.myrmex.func_70661_as().func_75500_f();
    }

    public void func_75246_d() {
        if (this.myrmex.keepSearching) {
            this.myrmex.func_70661_as().func_75492_a((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o(), (double)this.targetBlock.func_177952_p() + 0.5, 1.0);
            if (this.myrmex.func_174831_c(this.targetBlock) < 2.0) {
                this.func_75251_c();
            }
        } else if (this.targetBlock != null) {
            List drops;
            double distance;
            this.myrmex.func_70661_as().func_75492_a((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o(), (double)this.targetBlock.func_177952_p() + 0.5, 1.0);
            IBlockState block = this.myrmex.field_70170_p.func_180495_p(this.targetBlock);
            if (EntityMyrmexBase.isEdibleBlock(block) && (distance = this.getDistance(this.targetBlock)) <= 5.0 && !(drops = block.func_177230_c().getDrops((IBlockAccess)this.myrmex.field_70170_p, this.targetBlock, block, 0)).isEmpty()) {
                this.myrmex.field_70170_p.func_175655_b(this.targetBlock, false);
                ItemStack heldStack = ((ItemStack)drops.get(0)).func_77946_l();
                heldStack.func_190920_e(1);
                ((ItemStack)drops.get(0)).func_190918_g(1);
                this.myrmex.func_184611_a(EnumHand.MAIN_HAND, heldStack);
                for (ItemStack stack : drops) {
                    EntityItem itemEntity = new EntityItem(this.myrmex.field_70170_p, (double)this.targetBlock.func_177958_n() + this.myrmex.func_70681_au().nextDouble(), (double)this.targetBlock.func_177956_o() + this.myrmex.func_70681_au().nextDouble(), (double)this.targetBlock.func_177952_p() + this.myrmex.func_70681_au().nextDouble(), stack);
                    itemEntity.func_174869_p();
                    if (this.myrmex.field_70170_p.field_72995_K) continue;
                    this.myrmex.field_70170_p.func_72838_d((Entity)itemEntity);
                }
                this.targetBlock = null;
                this.func_75251_c();
                this.myrmex.keepSearching = false;
                this.wanderRadius = 8;
                return;
            }
        }
    }

    public void func_75251_c() {
        this.targetBlock = BlockPos.field_177992_a;
        this.myrmex.keepSearching = true;
    }

    private double getDistance(BlockPos pos) {
        double deltaX = this.myrmex.field_70165_t - ((double)pos.func_177958_n() + 0.5);
        double deltaY = this.myrmex.field_70163_u + (double)this.myrmex.func_70047_e() - ((double)pos.func_177956_o() + 0.5);
        double deltaZ = this.myrmex.field_70161_v - ((double)pos.func_177952_p() + 0.5);
        return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
    }

    public class BlockSorter
    implements Comparator<BlockPos> {
        @Override
        public int compare(BlockPos pos1, BlockPos pos2) {
            double distance1 = MyrmexAIForage.this.getDistance(pos1);
            double distance2 = MyrmexAIForage.this.getDistance(pos2);
            return Double.compare(distance1, distance2);
        }
    }
}

