/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.client.model.IFChainBuffer;
import com.github.alexthe666.iceandfire.core.ModItems;
import com.github.alexthe666.iceandfire.core.ModKeys;
import com.github.alexthe666.iceandfire.core.ModSounds;
import com.github.alexthe666.iceandfire.entity.DragonUtils;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.IDragonFlute;
import com.github.alexthe666.iceandfire.entity.IDropArmor;
import com.github.alexthe666.iceandfire.entity.IVillagerFear;
import com.github.alexthe666.iceandfire.entity.StoneEntityProperties;
import com.github.alexthe666.iceandfire.entity.ai.HippogryphAIAirTarget;
import com.github.alexthe666.iceandfire.entity.ai.HippogryphAIAttackMelee;
import com.github.alexthe666.iceandfire.entity.ai.HippogryphAIMate;
import com.github.alexthe666.iceandfire.entity.ai.HippogryphAITarget;
import com.github.alexthe666.iceandfire.entity.ai.HippogryphAITargetItems;
import com.github.alexthe666.iceandfire.entity.ai.HippogryphAIWander;
import com.github.alexthe666.iceandfire.enums.EnumHippogryphTypes;
import com.github.alexthe666.iceandfire.message.MessageDragonControl;
import com.github.alexthe666.iceandfire.message.MessageHippogryphArmor;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.ilexiconn.llibrary.server.entity.EntityPropertiesHandler;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ContainerHorseChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityHippogryph
extends EntityTameable
implements IAnimatedEntity,
IDragonFlute,
IVillagerFear,
IAnimalFear,
IDropArmor {
    public static final ResourceLocation LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "hippogryph"));
    private static final int FLIGHT_CHANCE_PER_TICK = 1200;
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityHippogryph.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SADDLE = EntityDataManager.func_187226_a(EntityHippogryph.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ARMOR = EntityDataManager.func_187226_a(EntityHippogryph.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> CHESTED = EntityDataManager.func_187226_a(EntityHippogryph.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HOVERING = EntityDataManager.func_187226_a(EntityHippogryph.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(EntityHippogryph.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Byte> CONTROL_STATE = EntityDataManager.func_187226_a(EntityHippogryph.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> COMMAND = EntityDataManager.func_187226_a(EntityHippogryph.class, (DataSerializer)DataSerializers.field_187192_b);
    public static Animation ANIMATION_EAT;
    public static Animation ANIMATION_SPEAK;
    public static Animation ANIMATION_SCRATCH;
    public static Animation ANIMATION_BITE;
    public HippogryphInventory hippogryphInventory;
    @SideOnly(value=Side.CLIENT)
    public IFChainBuffer roll_buffer;
    public float sitProgress;
    public float hoverProgress;
    public float flyProgress;
    public int spacebarTicks;
    public BlockPos airTarget;
    public int airBorneCounter;
    private boolean isSitting;
    private boolean isHovering;
    private boolean isFlying;
    private int animationTick;
    private Animation currentAnimation;
    private int flyTicks;
    private int hoverTicks;
    private boolean hasChestVarChanged = false;
    public BlockPos homePos;
    public boolean hasHomePosition = false;

    public EntityHippogryph(World worldIn) {
        super(worldIn);
        ANIMATION_EAT = Animation.create((int)25);
        ANIMATION_SPEAK = Animation.create((int)15);
        ANIMATION_SCRATCH = Animation.create((int)25);
        ANIMATION_BITE = Animation.create((int)20);
        this.initHippogryphInv();
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.roll_buffer = new IFChainBuffer();
        }
        this.func_70105_a(1.7f, 1.6f);
        this.field_70138_W = 1.0f;
    }

    protected int func_70693_a(EntityPlayer player) {
        return 7 + this.field_70170_p.field_73012_v.nextInt(10);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new HippogryphAIAttackMelee((EntityCreature)this, 1.5, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new HippogryphAIMate(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, Items.field_179558_bo, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, Items.field_179559_bp, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new HippogryphAIAirTarget(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new HippogryphAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(4, new HippogryphAITargetItems((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(5, new HippogryphAITarget<Entity>(this, EntityLivingBase.class, false, new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity instanceof EntityLivingBase && !(entity instanceof AbstractHorse) && DragonUtils.isAlive((EntityLivingBase)entity);
            }
        }));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(ARMOR, (Object)0);
        this.field_70180_af.func_187214_a(SADDLE, (Object)false);
        this.field_70180_af.func_187214_a(CHESTED, (Object)false);
        this.field_70180_af.func_187214_a(HOVERING, (Object)false);
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
        this.field_70180_af.func_187214_a(CONTROL_STATE, (Object)0);
        this.field_70180_af.func_187214_a(COMMAND, (Object)0);
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public boolean func_82171_bF() {
        return true;
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger)) {
            this.field_70761_aq = this.field_70177_z;
            this.field_70177_z = passenger.field_70177_z;
        }
        passenger.func_70107_b(this.field_70165_t, this.field_70163_u + (double)1.05f, this.field_70161_v);
    }

    private void initHippogryphInv() {
        HippogryphInventory animalchest = this.hippogryphInventory;
        this.hippogryphInventory = new HippogryphInventory("hippogryphInventory", 18, this);
        this.hippogryphInventory.func_110133_a(this.func_70005_c_());
        if (animalchest != null) {
            int i = Math.min(animalchest.func_70302_i_(), this.hippogryphInventory.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = animalchest.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.hippogryphInventory.func_70299_a(j, itemstack.func_77946_l());
            }
            if (this.field_70170_p.field_72995_K) {
                ItemStack saddle = animalchest.func_70301_a(0);
                ItemStack chest = animalchest.func_70301_a(1);
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageHippogryphArmor(this.func_145782_y(), 0, saddle != null && saddle.func_77973_b() == Items.field_151141_av && !saddle.func_190926_b() ? 1 : 0));
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageHippogryphArmor(this.func_145782_y(), 1, chest != null && chest.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae) && !chest.func_190926_b() ? 1 : 0));
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageHippogryphArmor(this.func_145782_y(), 2, this.getIntFromArmor(animalchest.func_70301_a(2))));
            }
        }
    }

    @Nullable
    public Entity func_184179_bs() {
        for (Entity passenger : this.func_184188_bt()) {
            if (!(passenger instanceof EntityPlayer) || this.func_70638_az() == passenger) continue;
            EntityPlayer player = (EntityPlayer)passenger;
            if (!this.func_70909_n() || this.func_184753_b() == null || !this.func_184753_b().equals(player.func_110124_au())) continue;
            return player;
        }
        return null;
    }

    public int getIntFromArmor(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() != null && stack.func_77973_b() == ModItems.iron_hippogryph_armor) {
            return 1;
        }
        if (!stack.func_190926_b() && stack.func_77973_b() != null && stack.func_77973_b() == ModItems.gold_hippogryph_armor) {
            return 2;
        }
        if (!stack.func_190926_b() && stack.func_77973_b() != null && stack.func_77973_b() == ModItems.diamond_hippogryph_armor) {
            return 3;
        }
        return 0;
    }

    public boolean isBlinking() {
        return this.field_70173_aa % 50 > 43;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean isDev;
        ItemStack itemstack = player.func_184586_b(hand);
        String s = TextFormatting.func_110646_a((String)player.func_70005_c_());
        boolean bl = isDev = s.equals("Alexthe666") || s.equals("Raptorfarian");
        if (this.func_70909_n() && this.func_152114_e((EntityLivingBase)player)) {
            if (itemstack != null && itemstack.func_77973_b() == Items.field_151100_aR && itemstack.func_77960_j() == 1 && this.getEnumVariant() != EnumHippogryphTypes.ALEX && isDev) {
                this.setEnumVariant(EnumHippogryphTypes.ALEX);
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
                this.func_184185_a(SoundEvents.field_187945_hs, 1.0f, 1.0f);
                for (int i = 0; i < 20; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                }
                return true;
            }
            if (itemstack != null && itemstack.func_77973_b() == Items.field_151100_aR && itemstack.func_77960_j() == 7 && this.getEnumVariant() != EnumHippogryphTypes.RAPTOR && isDev) {
                this.setEnumVariant(EnumHippogryphTypes.RAPTOR);
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
                this.func_184185_a(SoundEvents.field_187945_hs, 1.0f, 1.0f);
                for (int i = 0; i < 20; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                }
                return true;
            }
            if (itemstack != null && itemstack.func_77973_b() == Items.field_179560_bq && this.func_70874_b() == 0 && !this.func_70880_s()) {
                this.func_146082_f(player);
                this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
                return true;
            }
            if (itemstack != null && itemstack.func_77973_b() == Items.field_151055_y) {
                if (player.func_70093_af()) {
                    BlockPos pos;
                    this.homePos = pos = new BlockPos((Entity)this);
                    this.hasHomePosition = true;
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("hippogryph.command.new_home", new Object[]{this.homePos.func_177958_n(), this.homePos.func_177956_o(), this.homePos.func_177952_p()}), true);
                    return true;
                }
                this.setCommand(this.getCommand() + 1);
                if (this.getCommand() > 1) {
                    this.setCommand(0);
                }
                player.func_146105_b((ITextComponent)new TextComponentTranslation("hippogryph.command." + (this.getCommand() == 1 ? "sit" : "stand"), new Object[0]), true);
                return true;
            }
            if (itemstack != null && itemstack.func_77973_b() == Items.field_151060_bw && this.getEnumVariant() != EnumHippogryphTypes.DODO) {
                this.setEnumVariant(EnumHippogryphTypes.DODO);
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
                this.func_184185_a(SoundEvents.field_187945_hs, 1.0f, 1.0f);
                for (int i = 0; i < 20; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                }
                return true;
            }
            if (itemstack != null && itemstack.func_77973_b() instanceof ItemFood && ((ItemFood)itemstack.func_77973_b()).func_77845_h() && this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70691_i(5.0f);
                this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                for (int i = 0; i < 3; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[]{Item.func_150891_b((Item)itemstack.func_77973_b())});
                }
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
                return true;
            }
            if (itemstack.func_190926_b()) {
                if (player.func_70093_af()) {
                    this.openGUI(player);
                    return true;
                }
                if (this.isSaddled() && !this.func_70631_g_() && !player.func_184218_aH()) {
                    player.func_184205_a((Entity)this, true);
                    return true;
                }
            }
        }
        return super.func_184645_a(player, hand);
    }

    public void openGUI(EntityPlayer playerEntity) {
        if (!(this.field_70170_p.field_72995_K || this.func_184207_aI() && !this.func_184196_w((Entity)playerEntity))) {
            playerEntity.openGui((Object)IceAndFire.INSTANCE, 4, this.field_70170_p, this.func_145782_y(), 0, 0);
        }
    }

    public boolean up() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) & 1) == 1;
    }

    public boolean down() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 1 & 1) == 1;
    }

    public boolean attack() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 2 & 1) == 1;
    }

    public boolean dismount() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 3 & 1) == 1;
    }

    public void up(boolean up) {
        this.setStateField(0, up);
    }

    public void down(boolean down) {
        this.setStateField(1, down);
    }

    public void attack(boolean attack) {
        this.setStateField(2, attack);
    }

    public void dismount(boolean dismount) {
        this.setStateField(3, dismount);
    }

    private void setStateField(int i, boolean newState) {
        byte prevState = (Byte)this.field_70180_af.func_187225_a(CONTROL_STATE);
        if (newState) {
            this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)((byte)(prevState | 1 << i)));
        } else {
            this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)((byte)(prevState & ~(1 << i))));
        }
    }

    public byte getControlState() {
        return (Byte)this.field_70180_af.func_187225_a(CONTROL_STATE);
    }

    public void setControlState(byte state) {
        this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)state);
    }

    public void setCommand(int command) {
        this.field_70180_af.func_187227_b(COMMAND, (Object)command);
        if (command == 1) {
            this.func_70904_g(true);
        } else {
            this.func_70904_g(false);
        }
    }

    public int getCommand() {
        return (Integer)this.field_70180_af.func_187225_a(COMMAND);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74757_a("Chested", this.isChested());
        compound.func_74757_a("Saddled", this.isSaddled());
        compound.func_74757_a("Hovering", this.isHovering());
        compound.func_74757_a("Flying", this.isFlying());
        compound.func_74768_a("Armor", this.getArmor());
        if (this.hippogryphInventory != null) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.hippogryphInventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.hippogryphInventory.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74774_a("Slot", (byte)i);
                itemstack.func_77955_b(nbttagcompound);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound);
            }
            compound.func_74782_a("Items", (NBTBase)nbttaglist);
        }
        if (this.func_95999_t() != null && !this.func_95999_t().isEmpty()) {
            compound.func_74778_a("CustomName", this.func_95999_t());
        }
        compound.func_74757_a("HasHomePosition", this.hasHomePosition);
        if (this.homePos != null && this.hasHomePosition) {
            compound.func_74768_a("HomeAreaX", this.homePos.func_177958_n());
            compound.func_74768_a("HomeAreaY", this.homePos.func_177956_o());
            compound.func_74768_a("HomeAreaZ", this.homePos.func_177952_p());
        }
        compound.func_74768_a("Command", this.getCommand());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        this.setChested(compound.func_74767_n("Chested"));
        this.setSaddled(compound.func_74767_n("Saddled"));
        this.setHovering(compound.func_74767_n("Hovering"));
        this.setFlying(compound.func_74767_n("Flying"));
        this.setArmor(compound.func_74762_e("Armor"));
        if (this.hippogryphInventory != null) {
            NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
            this.initHippogryphInv();
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
                this.hippogryphInventory.func_70299_a(j, new ItemStack(nbttagcompound));
            }
        } else {
            NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
            this.initHippogryphInv();
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
                this.initHippogryphInv();
                this.hippogryphInventory.func_70299_a(j, new ItemStack(nbttagcompound));
                ItemStack saddle = this.hippogryphInventory.func_70301_a(0);
                ItemStack chest = this.hippogryphInventory.func_70301_a(1);
                if (!this.field_70170_p.field_72995_K) continue;
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageHippogryphArmor(this.func_145782_y(), 0, saddle != null && saddle.func_77973_b() == Items.field_151141_av && !saddle.func_190926_b() ? 1 : 0));
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageHippogryphArmor(this.func_145782_y(), 1, chest != null && chest.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae) && !chest.func_190926_b() ? 1 : 0));
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageHippogryphArmor(this.func_145782_y(), 2, this.getIntFromArmor(this.hippogryphInventory.func_70301_a(2))));
            }
        }
        this.hasHomePosition = compound.func_74767_n("HasHomePosition");
        if (this.hasHomePosition && compound.func_74762_e("HomeAreaX") != 0 && compound.func_74762_e("HomeAreaY") != 0 && compound.func_74762_e("HomeAreaZ") != 0) {
            this.homePos = new BlockPos(compound.func_74762_e("HomeAreaX"), compound.func_74762_e("HomeAreaY"), compound.func_74762_e("HomeAreaZ"));
        }
        this.setCommand(compound.func_74762_e("Command"));
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public EnumHippogryphTypes getEnumVariant() {
        return EnumHippogryphTypes.values()[this.getVariant()];
    }

    public void setEnumVariant(EnumHippogryphTypes variant) {
        this.setVariant(variant.ordinal());
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public boolean isSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(SADDLE);
    }

    public void setSaddled(boolean saddle) {
        this.field_70180_af.func_187227_b(SADDLE, (Object)saddle);
    }

    public boolean isChested() {
        return (Boolean)this.field_70180_af.func_187225_a(CHESTED);
    }

    public void setChested(boolean chested) {
        this.field_70180_af.func_187227_b(CHESTED, (Object)chested);
        this.hasChestVarChanged = true;
    }

    public boolean func_70906_o() {
        if (this.field_70170_p.field_72995_K) {
            boolean isSitting;
            this.isSitting = isSitting = ((Byte)this.field_70180_af.func_187225_a(field_184755_bv) & 1) != 0;
            return isSitting;
        }
        return this.isSitting;
    }

    public void func_70904_g(boolean sitting) {
        if (!this.field_70170_p.field_72995_K) {
            this.isSitting = sitting;
        }
        byte b0 = (Byte)this.field_70180_af.func_187225_a(field_184755_bv);
        if (sitting) {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public boolean isHovering() {
        if (this.field_70170_p.field_72995_K) {
            this.isHovering = (Boolean)this.field_70180_af.func_187225_a(HOVERING);
            return this.isHovering;
        }
        return this.isHovering;
    }

    public void setHovering(boolean hovering) {
        this.field_70180_af.func_187227_b(HOVERING, (Object)hovering);
        if (!this.field_70170_p.field_72995_K) {
            this.isHovering = hovering;
        }
    }

    public boolean isFlying() {
        if (this.field_70170_p.field_72995_K) {
            this.isFlying = (Boolean)this.field_70180_af.func_187225_a(FLYING);
            return this.isFlying;
        }
        return this.isFlying;
    }

    public void setFlying(boolean flying) {
        this.field_70180_af.func_187227_b(FLYING, (Object)flying);
        if (!this.field_70170_p.field_72995_K) {
            this.isFlying = flying;
        }
    }

    public int getArmor() {
        return (Integer)this.field_70180_af.func_187225_a(ARMOR);
    }

    public void setArmor(int armorType) {
        this.field_70180_af.func_187227_b(ARMOR, (Object)armorType);
        double armorValue = 0.0;
        switch (armorType) {
            case 1: {
                armorValue = 10.0;
                break;
            }
            case 2: {
                armorValue = 20.0;
                break;
            }
            case 3: {
                armorValue = 30.0;
            }
        }
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(armorValue);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    public boolean canMove() {
        StoneEntityProperties properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)this, StoneEntityProperties.class);
        if (properties != null && properties.isStone) {
            return false;
        }
        return !this.func_70906_o() && this.func_184179_bs() == null && this.sitProgress == 0.0f;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setEnumVariant(EnumHippogryphTypes.getBiomeType(this.field_70170_p.func_180494_b(this.func_180425_c())));
        return livingdata;
    }

    public boolean func_70097_a(DamageSource dmg, float i) {
        if (this.func_184207_aI() && dmg.func_76346_g() != null && this.func_184179_bs() != null && dmg.func_76346_g() == this.func_184179_bs()) {
            return false;
        }
        return super.func_70097_a(dmg, i);
    }

    @Nullable
    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public void func_70642_aH() {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.func_70642_aH();
    }

    protected void func_184581_c(DamageSource source) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.func_184581_c(source);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return ModSounds.HIPPOGRYPH_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return ModSounds.HIPPOGRYPH_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return ModSounds.HIPPOGRYPH_DIE;
    }

    public Animation[] getAnimations() {
        return new Animation[]{IAnimatedEntity.NO_ANIMATION, ANIMATION_EAT, ANIMATION_BITE, ANIMATION_SPEAK, ANIMATION_SCRATCH};
    }

    public boolean isRidingPlayer(EntityPlayer player) {
        return this.func_184179_bs() != null && this.func_184179_bs() instanceof EntityPlayer && this.func_184179_bs().func_110124_au().equals(player.func_110124_au());
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public boolean isDirectPathBetweenPoints(Vec3d vec1, Vec3d vec2) {
        RayTraceResult movingobjectposition = this.field_70170_p.func_147447_a(vec1, new Vec3d(vec2.field_72450_a, vec2.field_72448_b + (double)this.field_70131_O * 0.5, vec2.field_72449_c), false, true, false);
        return movingobjectposition == null || movingobjectposition.field_72313_a != RayTraceResult.Type.BLOCK;
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateClientControls() {
        byte controlState;
        byte previousState;
        Minecraft mc = Minecraft.func_71410_x();
        if (this.isRidingPlayer((EntityPlayer)mc.field_71439_g)) {
            previousState = this.getControlState();
            this.up(mc.field_71474_y.field_74314_A.func_151470_d());
            this.down(ModKeys.dragon_down.func_151470_d());
            this.attack(ModKeys.dragon_strike.func_151470_d());
            this.dismount(mc.field_71474_y.field_74311_E.func_151470_d());
            controlState = this.getControlState();
            if (controlState != previousState) {
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonControl(this.func_145782_y(), controlState, this.field_70165_t, this.field_70163_u, this.field_70161_v));
            }
        }
        if (this.func_184187_bx() != null && this.func_184187_bx() == mc.field_71439_g) {
            previousState = this.getControlState();
            this.dismount(mc.field_71474_y.field_74311_E.func_151470_d());
            controlState = this.getControlState();
            if (controlState != previousState) {
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonControl(this.func_145782_y(), controlState, this.field_70165_t, this.field_70163_u, this.field_70161_v));
            }
        }
    }

    public void func_191986_a(float strafe, float forward, float vertical) {
        EntityLivingBase controller;
        if (!this.canMove() && !this.func_184207_aI()) {
            strafe = 0.0f;
            forward = 0.0f;
            super.func_191986_a(strafe, forward, vertical);
            return;
        }
        if (this.func_184207_aI() && this.func_82171_bF() && (controller = (EntityLivingBase)this.func_184179_bs()) != null) {
            strafe = controller.field_70702_br * 0.5f;
            forward = controller.field_191988_bg;
            if (forward <= 0.0f) {
                forward *= 0.25f;
            }
            if (this.isFlying() || this.isHovering()) {
                this.field_70159_w *= 1.06;
                this.field_70179_y *= 1.06;
            }
            this.field_70747_aH = 0.05f;
            this.func_70659_e(this.field_70122_E ? (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() : 2.0f);
            vertical = 0.0f;
            super.func_191986_a(strafe, 0.0f, forward);
            return;
        }
        super.func_191986_a(strafe, forward, vertical);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() == ANIMATION_SCRATCH) return true;
        if (this.getAnimation() == ANIMATION_BITE) return true;
        this.setAnimation(this.func_70681_au().nextBoolean() ? ANIMATION_SCRATCH : ANIMATION_BITE);
        return false;
    }

    public EntityItem createEgg(EntityHippogryph partner) {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70163_u);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        ItemStack stack = new ItemStack(ModItems.hippogryph_egg);
        EntityItem egg = new EntityItem(this.field_70170_p, (double)i, (double)j, (double)k, stack);
        return egg;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_70636_d() {
        boolean flying;
        boolean sitting;
        StoneEntityProperties properties;
        double dist;
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70906_o() && (this.getCommand() != 1 || this.func_184179_bs() != null)) {
                this.func_70904_g(false);
            }
            if (!this.func_70906_o() && this.getCommand() == 1 && this.func_184179_bs() == null) {
                this.func_70904_g(true);
            }
            if (this.func_70906_o()) {
                this.func_70661_as().func_75499_g();
            }
            if (this.field_70146_Z.nextInt(900) == 0 && this.field_70725_aQ == 0) {
                this.func_70691_i(1.0f);
            }
        }
        if (this.getAnimation() == ANIMATION_BITE && this.func_70638_az() != null && this.getAnimationTick() == 6 && (dist = this.func_70068_e((Entity)this.func_70638_az())) < 8.0) {
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        }
        if (this.getAnimation() == ANIMATION_SCRATCH && this.func_70638_az() != null && this.getAnimationTick() == 6 && (dist = this.func_70068_e((Entity)this.func_70638_az())) < 8.0) {
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
            this.func_70638_az().field_70160_al = true;
            float f = MathHelper.func_76133_a((double)0.5);
            this.func_70638_az().field_70159_w /= 2.0;
            this.func_70638_az().field_70179_y /= 2.0;
            this.func_70638_az().field_70159_w -= 0.5 / (double)f * 4.0;
            this.func_70638_az().field_70179_y -= 0.5 / (double)f * 4.0;
            if (this.func_70638_az().field_70122_E) {
                this.func_70638_az().field_70181_x /= 2.0;
                this.func_70638_az().field_70181_x += 4.0;
                if (this.func_70638_az().field_70181_x > (double)0.4f) {
                    this.func_70638_az().field_70181_x = 0.4f;
                }
            }
        }
        if (!this.field_70170_p.field_72995_K && this.field_70122_E && this.func_70661_as().func_75500_f() && this.func_70638_az() != null && this.func_70638_az().field_70163_u - 3.0 > this.field_70163_u && this.func_70681_au().nextInt(15) == 0 && this.canMove() && !this.isHovering() && !this.isFlying()) {
            this.setHovering(true);
            this.hoverTicks = 0;
            this.flyTicks = 0;
        }
        if ((properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)this, StoneEntityProperties.class)) != null && properties.isStone) {
            this.setFlying(false);
            this.setHovering(false);
        }
        this.airBorneCounter = !this.field_70122_E ? ++this.airBorneCounter : 0;
        if (this.hasChestVarChanged && this.hippogryphInventory != null && !this.isChested()) {
            for (int i = 3; i < 18; ++i) {
                if (this.hippogryphInventory.func_70301_a(i).func_190926_b()) continue;
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70099_a(this.hippogryphInventory.func_70301_a(i), 1.0f);
                }
                this.hippogryphInventory.func_70304_b(i);
            }
            this.hasChestVarChanged = false;
        }
        if (!this.field_70122_E && this.airTarget != null) {
            this.setFlying(true);
        }
        if (this.isFlying() && this.field_70173_aa % 40 == 0 || this.isFlying() && this.func_70906_o()) {
            this.setFlying(true);
        }
        if (!this.canMove() && this.func_70638_az() != null) {
            this.func_70624_b(null);
        }
        if (!this.canMove()) {
            this.func_70661_as().func_75499_g();
        }
        if (this.func_184179_bs() != null) {
            if (this.field_70181_x > 0.5 && (this.isFlying() || this.isHovering())) {
                this.field_70181_x = 0.5;
            }
            if (this.field_70181_x < -0.5) {
                this.field_70181_x = -0.5;
            }
        } else {
            if (this.field_70181_x > 0.8) {
                this.field_70181_x = 0.5;
            }
            if (this.field_70181_x < -0.8) {
                this.field_70181_x = -0.8;
            }
            if (this.field_70181_x > 1.0) {
                this.field_70181_x = 0.0;
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        boolean bl = sitting = this.func_70906_o() && !this.isHovering() && !this.isFlying();
        if (sitting && this.sitProgress < 20.0f) {
            this.sitProgress += 0.5f;
        } else if (!sitting && this.sitProgress > 0.0f) {
            this.sitProgress -= 0.5f;
        }
        boolean hovering = this.isHovering();
        if (hovering && this.hoverProgress < 20.0f) {
            this.hoverProgress += 0.5f;
        } else if (!hovering && this.hoverProgress > 0.0f) {
            this.hoverProgress -= 0.5f;
        }
        boolean bl2 = flying = this.isFlying() || !this.isHovering() && this.airBorneCounter > 50;
        if (flying && this.flyProgress < 20.0f) {
            this.flyProgress += 0.5f;
        } else if (!flying && this.flyProgress > 0.0f) {
            this.flyProgress -= 0.5f;
        }
        if ((flying || hovering) && this.field_70173_aa % 20 == 0 && !this.field_70122_E) {
            this.func_184185_a(SoundEvents.field_187524_aN, this.func_70599_aP() * (float)(IceAndFire.CONFIG.dragonFlapNoiseDistance / 2), 0.6f + this.field_70146_Z.nextFloat() * 0.6f * this.func_70647_i());
        }
        if (this.field_70122_E && this.doesWantToLand() && (this.isFlying() || this.isHovering())) {
            this.setFlying(false);
            this.setHovering(false);
        }
        if (this.func_184179_bs() != null && !this.field_70122_E && (this.isFlying() || this.isHovering())) {
            this.field_70181_x *= 0.0;
        }
        if (this.isHovering()) {
            if (this.func_70906_o()) {
                this.setHovering(false);
            }
            ++this.hoverTicks;
            if (this.doesWantToLand()) {
                this.field_70181_x -= 0.25;
            } else {
                if (this.func_184179_bs() == null) {
                    this.field_70181_x += 0.08;
                }
                if (this.hoverTicks > 40) {
                    if (!this.func_70631_g_()) {
                        this.setFlying(true);
                    }
                    this.setHovering(false);
                    this.hoverTicks = 0;
                    this.flyTicks = 0;
                }
            }
        }
        if (this.func_70906_o()) {
            this.func_70661_as().func_75499_g();
        }
        if (!this.isFlying() && !this.isHovering() && this.airTarget != null && this.field_70122_E) {
            this.airTarget = null;
        }
        if (this.isFlying() && this.airTarget == null && this.field_70122_E && this.func_184179_bs() == null) {
            this.setFlying(false);
        }
        if (this.isFlying() && this.func_70638_az() == null) {
            this.flyAround();
        } else if (this.func_70638_az() != null) {
            this.flyTowardsTarget();
        }
        if (this.field_70122_E && this.flyTicks != 0) {
            this.flyTicks = 0;
        }
        if (this.isFlying() && this.doesWantToLand()) {
            this.setFlying(false);
            this.setHovering(!this.field_70122_E);
            if (this.field_70122_E) {
                this.flyTicks = 0;
                this.setFlying(false);
            }
        }
        if (this.isFlying()) {
            ++this.flyTicks;
        }
        if ((this.isHovering() || this.isFlying()) && this.func_70906_o()) {
            this.setFlying(false);
            this.setHovering(false);
        }
        if (!(properties != null && (properties == null || properties.isStone) || (this.field_70170_p.field_72995_K || this.func_70681_au().nextInt(1200) != 0 || this.func_70906_o() || this.isFlying() || !this.func_184188_bt().isEmpty() || this.func_70631_g_() || this.isHovering() || this.func_70906_o() || !this.canMove() || !this.field_70122_E) && !(this.field_70163_u < -1.0))) {
            this.setHovering(true);
            this.hoverTicks = 0;
            this.flyTicks = 0;
        }
        if (this.func_70638_az() != null && !this.func_184188_bt().isEmpty() && this.func_70902_q() != null && this.func_184188_bt().contains(this.func_70902_q())) {
            this.func_70624_b(null);
        }
    }

    public boolean doesWantToLand() {
        return this.flyTicks > 6000 || this.down() || this.flyTicks > 40 && this.flyProgress == 0.0f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.updateClientControls();
        }
        if (this.up()) {
            if (this.airBorneCounter == 0) {
                this.field_70181_x += 1.0;
            }
            if (!this.isFlying() && !this.isHovering()) {
                this.spacebarTicks += 2;
            }
            if (this.isFlying() || this.isHovering()) {
                this.field_70181_x += 0.4;
            }
        } else if (this.dismount() && (this.isFlying() || this.isHovering())) {
            this.field_70181_x -= 0.4;
            this.setFlying(false);
            this.setHovering(false);
        }
        if (this.down() && (this.isFlying() || this.isHovering())) {
            this.field_70181_x -= 0.4;
        }
        if (!this.dismount() && (this.isFlying() || this.isHovering())) {
            this.field_70181_x += 0.01;
        }
        if (this.attack() && this.func_184179_bs() != null && this.func_184179_bs() instanceof EntityPlayer) {
            EntityLivingBase target = DragonUtils.riderLookingAtEntity((EntityLivingBase)this, (EntityLivingBase)((EntityPlayer)this.func_184179_bs()), 3.0);
            if (this.getAnimation() != ANIMATION_BITE) {
                if (this.getAnimation() != ANIMATION_SCRATCH) {
                    this.setAnimation(this.func_70681_au().nextBoolean() ? ANIMATION_SCRATCH : ANIMATION_BITE);
                }
            }
            if (target != null) {
                target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
            }
        }
        if (this.func_184179_bs() != null && this.func_184179_bs().func_70093_af()) {
            this.func_184179_bs().func_184210_p();
        }
        if (this.isFlying() && !this.isHovering() && this.func_184179_bs() != null && !this.field_70122_E && Math.max(Math.abs(this.field_70179_y), Math.abs(this.field_70159_w)) < (double)0.1f) {
            this.setHovering(true);
            this.setFlying(false);
        }
        if (this.isHovering() && !this.isFlying() && this.func_184179_bs() != null && !this.field_70122_E && Math.max(Math.abs(this.field_70179_y), Math.abs(this.field_70159_w)) > (double)0.1f) {
            this.setFlying(true);
            this.setHovering(false);
        }
        if (this.spacebarTicks > 0) {
            --this.spacebarTicks;
        }
        if (this.spacebarTicks > 20 && this.func_70902_q() != null && this.func_184188_bt().contains(this.func_70902_q()) && !this.isFlying() && !this.isHovering()) {
            this.setHovering(true);
        }
        if (this.field_70170_p.field_72995_K) {
            this.roll_buffer.calculateChainFlapBuffer(35.0f, 8, 6.0f, (EntityLivingBase)this);
        }
        if (this.func_70638_az() != null && this.func_184187_bx() == null && this.func_70638_az().field_70128_L || this.func_70638_az() != null && this.func_70638_az() instanceof EntityDragonBase && ((EntityDragonBase)this.func_70638_az()).field_70128_L) {
            this.func_70624_b(null);
        }
    }

    public void flyAround() {
        if (this.airTarget != null && this.isFlying()) {
            if (!this.isTargetInAir() || this.flyTicks > 6000 || !this.isFlying()) {
                this.airTarget = null;
            }
            this.flyTowardsTarget();
        }
    }

    public boolean isTargetBlocked(Vec3d target) {
        BlockPos pos;
        RayTraceResult rayTrace;
        return target != null && (rayTrace = this.field_70170_p.func_72901_a(new Vec3d((Vec3i)this.func_180425_c()), target, false)) != null && rayTrace.field_72307_f != null && !this.field_70170_p.func_175623_d(pos = new BlockPos(rayTrace.field_72307_f));
    }

    /*
     * Unable to fully structure code
     */
    public void flyTowardsTarget() {
        if (this.airTarget == null || !this.isTargetInAir() || !this.isFlying()) ** GOTO lbl-1000
        v0 = new Vec3d((double)this.airTarget.func_177958_n(), this.field_70163_u, (double)this.airTarget.func_177952_p());
        if (this.getDistanceSquared(v0) > 3.0f) {
            targetX = (double)this.airTarget.func_177958_n() + 0.5 - this.field_70165_t;
            targetY = (double)Math.min(this.airTarget.func_177956_o(), 256) + 1.0 - this.field_70163_u;
            targetZ = (double)this.airTarget.func_177952_p() + 0.5 - this.field_70161_v;
            this.field_70159_w += (Math.signum(targetX) * 0.5 - this.field_70159_w) * 0.100000000372529 * 2.0;
            this.field_70181_x += (Math.signum(targetY) * 0.5 - this.field_70181_x) * 0.100000000372529 * 2.0;
            this.field_70179_y += (Math.signum(targetZ) * 0.5 - this.field_70179_y) * 0.100000000372529 * 2.0;
            angle = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / 3.141592653589793) - 90.0f;
            rotation = MathHelper.func_76142_g((float)(angle - this.field_70177_z));
            this.field_191988_bg = 0.5f;
            this.field_70126_B = this.field_70177_z;
            this.field_70177_z += rotation;
            if (!this.isFlying()) {
                this.setFlying(true);
            }
        } else lbl-1000:
        // 2 sources

        {
            this.airTarget = null;
        }
        if (this.airTarget != null && this.isTargetInAir() && this.isFlying()) {
            v1 = new Vec3d((double)this.airTarget.func_177958_n(), this.field_70163_u, (double)this.airTarget.func_177952_p());
            if (this.getDistanceSquared(v1) < 3.0f && this.doesWantToLand()) {
                this.setFlying(false);
                this.setHovering(true);
            }
        }
    }

    protected boolean isTargetInAir() {
        return this.airTarget != null && (this.field_70170_p.func_180495_p(this.airTarget).func_185904_a() == Material.field_151579_a || this.field_70170_p.func_180495_p(this.airTarget).func_185904_a() == Material.field_151579_a);
    }

    public float getDistanceSquared(Vec3d vec3d) {
        float f = (float)(this.field_70165_t - vec3d.field_72450_a);
        float f1 = (float)(this.field_70163_u - vec3d.field_72448_b);
        float f2 = (float)(this.field_70161_v - vec3d.field_72449_c);
        return f * f + f1 * f1 + f2 * f2;
    }

    public boolean func_174820_d(int inventorySlot, @Nullable ItemStack itemStackIn) {
        int j = inventorySlot - 500 + 2;
        if (j >= 0 && j < this.hippogryphInventory.func_70302_i_()) {
            this.hippogryphInventory.func_70299_a(j, itemStackIn);
            return true;
        }
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (this.hippogryphInventory != null && !this.field_70170_p.field_72995_K) {
            for (int i = 0; i < this.hippogryphInventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.hippogryphInventory.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                this.func_70099_a(itemstack, 0.0f);
            }
        }
    }

    public void refreshInventory() {
        ItemStack saddle = this.hippogryphInventory.func_70301_a(0);
        ItemStack chest = this.hippogryphInventory.func_70301_a(1);
        this.setSaddled(saddle != null && saddle.func_77973_b() == Items.field_151141_av && !saddle.func_190926_b());
        this.setChested(chest != null && chest.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae) && !chest.func_190926_b());
        this.setArmor(this.getIntFromArmor(this.hippogryphInventory.func_70301_a(2)));
        if (this.field_70170_p.field_72995_K) {
            IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageHippogryphArmor(this.func_145782_y(), 0, saddle != null && saddle.func_77973_b() == Items.field_151141_av && !saddle.func_190926_b() ? 1 : 0));
            IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageHippogryphArmor(this.func_145782_y(), 1, chest != null && chest.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae) && !chest.func_190926_b() ? 1 : 0));
            IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageHippogryphArmor(this.func_145782_y(), 2, this.getIntFromArmor(this.hippogryphInventory.func_70301_a(2))));
        }
    }

    @Override
    public void onHearFlute(EntityPlayer player) {
        if (this.func_70909_n() && this.func_152114_e((EntityLivingBase)player) && (this.isFlying() || this.isHovering())) {
            this.airTarget = null;
            this.setFlying(false);
            this.setHovering(false);
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return DragonUtils.canTameDragonAttack(this, entity);
    }

    @Override
    public void dropArmor() {
        if (this.hippogryphInventory != null && !this.field_70170_p.field_72995_K) {
            for (int i = 0; i < this.hippogryphInventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.hippogryphInventory.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                this.func_70099_a(itemstack, 0.0f);
            }
        }
    }

    class HippogryphInventoryListener
    implements IInventoryChangedListener {
        EntityHippogryph hippogryph;

        public HippogryphInventoryListener(EntityHippogryph hippogryph) {
            this.hippogryph = hippogryph;
        }

        public void func_76316_a(IInventory invBasic) {
            this.hippogryph.refreshInventory();
        }
    }

    public class HippogryphInventory
    extends ContainerHorseChest {
        public HippogryphInventory(String inventoryTitle, int slotCount, EntityHippogryph hippogryph) {
            super(inventoryTitle, slotCount);
            this.func_110134_a(new HippogryphInventoryListener(hippogryph));
        }
    }
}

