/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.player;

import com.legacy.aether.AetherConfig;
import com.legacy.aether.api.player.IPlayerAether;
import com.legacy.aether.api.player.util.IAccessoryInventory;
import com.legacy.aether.api.player.util.IAetherAbility;
import com.legacy.aether.api.player.util.IAetherBoss;
import com.legacy.aether.blocks.BlocksAether;
import com.legacy.aether.containers.inventory.InventoryAccessories;
import com.legacy.aether.entities.movement.AetherPoisonMovement;
import com.legacy.aether.entities.passive.mountable.EntityParachute;
import com.legacy.aether.items.ItemsAether;
import com.legacy.aether.networking.AetherNetworkingManager;
import com.legacy.aether.networking.packets.PacketAccessory;
import com.legacy.aether.player.abilities.AbilityAccessories;
import com.legacy.aether.player.abilities.AbilityArmor;
import com.legacy.aether.player.abilities.AbilityFlight;
import com.legacy.aether.player.abilities.AbilityRepulsion;
import com.legacy.aether.player.perks.AetherRankings;
import com.legacy.aether.player.perks.util.DonatorMoaSkin;
import com.legacy.aether.world.TeleporterAether;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class PlayerAether
implements IPlayerAether {
    public EntityPlayer thePlayer;
    private UUID healthUUID = UUID.fromString("df6eabe7-6947-4a56-9099-002f90370706");
    private UUID extendedReachUUID = UUID.fromString("df6eabe7-6947-4a56-9099-002f90370707");
    private AttributeModifier healthModifier;
    private AttributeModifier reachModifier;
    public IAccessoryInventory accessories;
    private AetherPoisonMovement poison;
    public float wingSinage;
    public IAetherBoss currentBoss;
    private final ArrayList<IAetherAbility> abilities = new ArrayList();
    public final ArrayList<Entity> clouds = new ArrayList(2);
    private boolean isJumping;
    public int lifeShardsUsed;
    public float prevPortalAnimTime;
    public float portalAnimTime;
    public int timeInPortal;
    public boolean hasTeleported = false;
    public boolean inPortal = false;
    public boolean shouldPlayPortalSound = false;
    private String cooldownName = "Hammer of Notch";
    private int cooldown;
    private int cooldownMax;
    public boolean shouldRenderHalo = true;
    public boolean shouldRenderGlow = false;
    public boolean seenSpiritDialog = false;
    public DonatorMoaSkin donatorMoaSkin;
    public List<Item> extendedReachItems = Arrays.asList(ItemsAether.valkyrie_shovel, ItemsAether.valkyrie_pickaxe, ItemsAether.valkyrie_axe);

    public PlayerAether() {
    }

    public PlayerAether(EntityPlayer player) {
        this.thePlayer = player;
        this.donatorMoaSkin = new DonatorMoaSkin();
        this.poison = new AetherPoisonMovement((EntityLivingBase)player);
        this.accessories = new InventoryAccessories(player);
        this.reachModifier = new AttributeModifier(this.extendedReachUUID, "Aether Reach Modifier", 5.0, 0);
        this.abilities.addAll(Arrays.asList(new AbilityArmor(this), new AbilityAccessories(this), new AbilityFlight(this), new AbilityRepulsion(this)));
    }

    @Override
    public void onUpdate() {
        EntityLiving boss;
        int i;
        if (this.inPortal && this.thePlayer.field_70170_p.field_72995_K && this.portalAnimTime == 0.0f) {
            this.shouldPlayPortalSound = true;
        }
        for (i = 0; i < this.abilities.size(); ++i) {
            IAetherAbility ability = this.abilities.get(i);
            if (!ability.shouldExecute()) continue;
            ability.onUpdate();
        }
        for (i = 0; i < this.clouds.size(); ++i) {
            Entity entity = this.clouds.get(i);
            if (!entity.field_70128_L) continue;
            this.clouds.remove(i);
        }
        this.poison.onUpdate();
        this.wingSinage = !this.thePlayer.field_70122_E && this.thePlayer.func_184218_aH() && !this.thePlayer.func_184187_bx().field_70122_E ? (this.wingSinage += 0.75f) : (this.wingSinage += 0.15f);
        this.wingSinage = this.wingSinage > 6.283186f ? (this.wingSinage -= 6.283186f) : (this.wingSinage += 0.1f);
        if (this.currentBoss instanceof EntityLiving && ((boss = (EntityLiving)this.currentBoss).func_110143_aJ() <= 0.0f || boss.field_70128_L || Math.sqrt(Math.pow(boss.field_70165_t - this.thePlayer.field_70165_t, 2.0) + Math.pow(boss.field_70163_u - this.thePlayer.field_70163_u, 2.0) + Math.pow(boss.field_70161_v - this.thePlayer.field_70161_v, 2.0)) > 50.0)) {
            this.currentBoss = null;
        }
        if (this.isInBlock(BlocksAether.aercloud)) {
            this.thePlayer.field_70143_R = 0.0f;
        }
        if (this.getHammerCooldown() > 0) {
            --this.cooldown;
        }
        if (this.thePlayer.field_70181_x < -2.0) {
            this.activateParachute();
        }
        if (this.thePlayer.field_71093_bK == AetherConfig.dimension.aether_dimension_id && this.thePlayer.field_70163_u < -2.0) {
            this.teleportPlayer(false);
        }
        this.updatePlayerReach();
        if (this.thePlayer.field_70170_p.field_72995_K) {
            this.prevPortalAnimTime = this.portalAnimTime;
            if (this.inPortal) {
                this.portalAnimTime += 0.0125f;
                this.inPortal = false;
            } else {
                if (this.portalAnimTime > 0.0f) {
                    this.portalAnimTime -= 0.05f;
                }
                if (this.portalAnimTime < 0.0f) {
                    this.portalAnimTime = 0.0f;
                }
            }
        } else if (this.inPortal) {
            int limit = this.thePlayer.func_82145_z();
            if (this.timeInPortal++ >= limit) {
                this.timeInPortal = limit;
                this.thePlayer.field_71088_bW = this.thePlayer.func_82147_ab();
                this.teleportPlayer(true);
            }
            this.inPortal = false;
        } else {
            if (this.timeInPortal > 0) {
                this.timeInPortal -= 4;
            }
            if (this.timeInPortal < 0) {
                this.timeInPortal = 0;
            }
            if (this.thePlayer.field_71088_bW > 0) {
                --this.thePlayer.field_71088_bW;
            }
        }
    }

    public boolean onPlayerAttacked(DamageSource source) {
        return this.getAccessoryInventory().isWearingPhoenixSet() && source.func_76347_k();
    }

    public void onPlayerDeath() {
        if (!this.thePlayer.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            this.accessories.dropAccessories();
        }
    }

    public void onPlayerRespawn() {
        this.updateShardCount(0);
        this.thePlayer.func_70606_j(this.thePlayer.func_110138_aP());
        this.updateAccessories();
    }

    public void onChangedDimension(int toDim, int fromDim) {
        this.updateAccessories();
    }

    @Override
    public void saveNBTData(NBTTagCompound output) {
        if (AetherRankings.isRankedPlayer(this.thePlayer.func_110124_au())) {
            output.func_74757_a("halo", this.shouldRenderHalo);
        }
        if (AetherRankings.isDeveloper(this.thePlayer.func_110124_au())) {
            output.func_74757_a("glow", this.shouldRenderGlow);
        }
        output.func_74757_a("seen_spirit_dialog", this.seenSpiritDialog);
        output.func_74768_a("hammer_cooldown", this.cooldown);
        output.func_74778_a("notch_hammer_name", this.cooldownName);
        output.func_74768_a("max_hammer_cooldown", this.cooldownMax);
        output.func_74776_a("shard_count", (float)this.lifeShardsUsed);
        this.accessories.writeToNBT(output);
    }

    @Override
    public void loadNBTData(NBTTagCompound input) {
        if (input.func_74764_b("halo")) {
            this.shouldRenderHalo = input.func_74767_n("halo");
        }
        if (input.func_74764_b("glow")) {
            this.shouldRenderGlow = input.func_74767_n("glow");
        }
        if (input.func_74764_b("shards_used")) {
            input.func_74768_a("shard_count", (int)(input.func_74760_g("shards_used") / 2.0f));
        }
        if (input.func_74764_b("seen_spirit_dialog")) {
            this.seenSpiritDialog = input.func_74767_n("seen_spirit_dialog");
        }
        this.cooldown = input.func_74762_e("hammer_cooldown");
        this.cooldownName = input.func_74779_i("notch_hammer_name");
        this.cooldownMax = input.func_74762_e("max_hammer_cooldown");
        this.updateShardCount(input.func_74762_e("shard_count"));
        this.accessories.readFromNBT(input);
    }

    public float getCurrentPlayerStrVsBlock(float original) {
        float f = original;
        if (this.getAccessoryInventory().wearingAccessory(new ItemStack(ItemsAether.zanite_pendant))) {
            f *= 1.0f + (float)((InventoryAccessories)this.accessories).getStackFromItem(ItemsAether.zanite_pendant).func_77952_i() / ((float)((InventoryAccessories)this.accessories).getStackFromItem(ItemsAether.zanite_pendant).func_77958_k() * 3.0f);
        }
        if (this.getAccessoryInventory().wearingAccessory(new ItemStack(ItemsAether.zanite_ring))) {
            f *= 1.0f + (float)((InventoryAccessories)this.accessories).getStackFromItem(ItemsAether.zanite_ring).func_77952_i() / ((float)((InventoryAccessories)this.accessories).getStackFromItem(ItemsAether.zanite_ring).func_77958_k() * 3.0f);
        }
        return f == original ? original : f + original;
    }

    public void updatePlayerReach() {
        ItemStack stack = this.thePlayer.func_184614_ca();
        if (!this.thePlayer.func_110148_a(EntityPlayer.REACH_DISTANCE).func_180374_a(this.reachModifier) && this.extendedReachItems.contains(stack.func_77973_b())) {
            this.thePlayer.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111121_a(this.reachModifier);
        } else if (this.thePlayer.func_110148_a(EntityPlayer.REACH_DISTANCE).func_180374_a(this.reachModifier) && !this.extendedReachItems.contains(stack.func_77973_b())) {
            this.thePlayer.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111124_b(this.reachModifier);
        }
    }

    private void teleportPlayer(boolean shouldSpawnPortal) {
        if (this.thePlayer instanceof EntityPlayerMP) {
            int transferDimension;
            int previousDimension = this.thePlayer.field_71093_bK;
            int n = transferDimension = previousDimension == AetherConfig.dimension.aether_dimension_id ? 0 : AetherConfig.dimension.aether_dimension_id;
            if (ForgeHooks.onTravelToDimension((Entity)this.thePlayer, (int)transferDimension)) {
                MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                TeleporterAether teleporter = new TeleporterAether(shouldSpawnPortal, server.func_71218_a(transferDimension));
                for (Entity passenger : this.thePlayer.func_184188_bt()) {
                    PlayerAether.transferEntity(shouldSpawnPortal, passenger, server.func_71218_a(previousDimension), server.func_71218_a(transferDimension));
                    passenger.func_184210_p();
                }
                server.func_184103_al().transferPlayerToDimension((EntityPlayerMP)this.thePlayer, transferDimension, (Teleporter)teleporter);
                if (this.thePlayer.func_184187_bx() != null) {
                    this.thePlayer.func_184210_p();
                }
            }
        }
    }

    private static void transferEntity(boolean shouldSpawnPortal, Entity entityIn, WorldServer previousWorldIn, WorldServer newWorldIn) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        entityIn.field_71093_bK = newWorldIn.field_73011_w.getDimension();
        previousWorldIn.func_72973_f(entityIn);
        entityIn.field_70128_L = false;
        server.func_184103_al().transferEntityToWorld(entityIn, previousWorldIn.field_73011_w.getDimension(), previousWorldIn, newWorldIn, (Teleporter)new TeleporterAether(shouldSpawnPortal, newWorldIn));
    }

    private void activateParachute() {
        EntityParachute parachute = null;
        if (this.thePlayer.field_71071_by.func_70431_c(new ItemStack(ItemsAether.cloud_parachute))) {
            parachute = new EntityParachute(this.thePlayer.field_70170_p, this.thePlayer, false);
            parachute.func_70107_b(this.thePlayer.field_70165_t, this.thePlayer.field_70163_u, this.thePlayer.field_70161_v);
            this.thePlayer.field_70170_p.func_72838_d((Entity)parachute);
            this.thePlayer.field_71071_by.func_184437_d(new ItemStack(ItemsAether.cloud_parachute));
        } else if (this.thePlayer.field_71071_by.func_70431_c(new ItemStack(ItemsAether.golden_parachute))) {
            for (int i = 0; i < this.thePlayer.field_71071_by.func_70302_i_(); ++i) {
                ItemStack itemstack = this.thePlayer.field_71071_by.func_70301_a(i);
                if (itemstack == null || itemstack.func_77973_b() != ItemsAether.golden_parachute) continue;
                itemstack.func_77972_a(1, (EntityLivingBase)this.thePlayer);
                parachute = new EntityParachute(this.thePlayer.field_70170_p, this.thePlayer, true);
                parachute.func_70107_b(this.thePlayer.field_70165_t, this.thePlayer.field_70163_u, this.thePlayer.field_70161_v);
                this.thePlayer.field_71071_by.func_70299_a(i, itemstack);
                this.thePlayer.field_70170_p.func_72838_d((Entity)parachute);
            }
        }
    }

    public boolean isInBlock(Block blockID) {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)this.thePlayer.field_70165_t);
        BlockPos pos = new BlockPos(x, y = MathHelper.func_76128_c((double)this.thePlayer.field_70163_u), z = MathHelper.func_76128_c((double)this.thePlayer.field_70161_v));
        return this.thePlayer.field_70170_p.func_180495_p(pos).func_177230_c() == blockID || this.thePlayer.field_70170_p.func_180495_p(pos.func_177984_a()).func_177230_c() == blockID || this.thePlayer.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() == blockID;
    }

    @Override
    public void updateShardCount(int amount) {
        this.lifeShardsUsed += amount;
        this.healthModifier = new AttributeModifier(this.healthUUID, "Aether Health Modifier", (double)((float)this.lifeShardsUsed * 2.0f), 0);
        if (this.thePlayer.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111127_a(this.healthUUID) != null) {
            this.thePlayer.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111124_b(this.healthModifier);
        }
        this.thePlayer.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(this.healthModifier);
    }

    @Override
    public int getShardsUsed() {
        return this.lifeShardsUsed;
    }

    @Override
    public int getMaxShardCount() {
        return AetherConfig.gameplay_changes.max_life_shards;
    }

    @Override
    public void setFocusedBoss(IAetherBoss boss) {
        this.currentBoss = boss;
    }

    @Override
    public IAetherBoss getFocusedBoss() {
        return this.currentBoss;
    }

    @Override
    public boolean setHammerCooldown(int cooldown, String hammerName) {
        if (this.cooldown == 0) {
            this.cooldown = cooldown;
            this.cooldownMax = cooldown;
            this.cooldownName = hammerName;
            return true;
        }
        return false;
    }

    @Override
    public void shouldPortalSound(boolean playSound) {
        this.shouldPlayPortalSound = playSound;
    }

    @Override
    public boolean shouldPortalSound() {
        return this.shouldPlayPortalSound;
    }

    @Override
    public String getHammerName() {
        return this.cooldownName;
    }

    @Override
    public int getHammerCooldown() {
        return this.cooldown;
    }

    @Override
    public int getHammerMaxCooldown() {
        return this.cooldownMax;
    }

    public AetherPoisonMovement poisonInstance() {
        return this.poison;
    }

    @Override
    public void inflictPoison(int ticks) {
        this.poison.afflictPoison(ticks);
    }

    @Override
    public void inflictCure(int ticks) {
        this.poison.curePoison(ticks);
    }

    @Override
    public boolean isPoisoned() {
        return this.poison.poisonTime > 0;
    }

    @Override
    public boolean isCured() {
        return this.poison.poisonTime < 0;
    }

    @Override
    public boolean isJumping() {
        return this.isJumping;
    }

    @Override
    public void setJumping(boolean isJumping) {
        this.isJumping = isJumping;
    }

    @Override
    public boolean isDonator() {
        return true;
    }

    @Override
    public void setInPortal() {
        if (this.thePlayer.field_71088_bW > 0) {
            this.thePlayer.field_71088_bW = this.thePlayer.func_82147_ab();
        } else {
            this.inPortal = true;
        }
    }

    public void updateAccessories() {
        if (!this.thePlayer.field_70170_p.field_72995_K) {
            AetherNetworkingManager.sendToAll(new PacketAccessory(this));
        }
    }

    @Override
    public void setAccessoryInventory(IAccessoryInventory inventory) {
        this.accessories = inventory;
    }

    @Override
    public IAccessoryInventory getAccessoryInventory() {
        return this.accessories;
    }

    @Override
    public ArrayList<IAetherAbility> getAbilities() {
        return this.abilities;
    }

    @Override
    public EntityPlayer getEntity() {
        return this.thePlayer;
    }

    @Override
    public boolean inPortalBlock() {
        return this.inPortal;
    }
}

