/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.networking.packets;

import com.legacy.aether.api.AetherAPI;
import com.legacy.aether.networking.packets.AetherPacket;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class PacketSendJump
extends AetherPacket<PacketSendJump> {
    private UUID uuid;
    private boolean isJumping;

    public PacketSendJump() {
    }

    public PacketSendJump(UUID uuid, boolean isJumping) {
        this.uuid = uuid;
        this.isJumping = isJumping;
    }

    public void fromBytes(ByteBuf buf) {
        this.uuid = new UUID(buf.readLong(), buf.readLong());
        this.isJumping = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.uuid.getMostSignificantBits());
        buf.writeLong(this.uuid.getLeastSignificantBits());
        buf.writeBoolean(this.isJumping);
    }

    @Override
    public void handleClient(PacketSendJump message, EntityPlayer player) {
    }

    @Override
    public void handleServer(PacketSendJump message, EntityPlayer player) {
        EntityPlayerMP user;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null && (user = server.func_184103_al().func_177451_a(message.uuid)) != null) {
            AetherAPI.getInstance().get((EntityPlayer)user).setJumping(message.isJumping);
        }
    }
}

