/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.networking.packets;

import com.legacy.aether.api.AetherAPI;
import com.legacy.aether.api.player.IPlayerAether;
import com.legacy.aether.networking.AetherNetworkingManager;
import com.legacy.aether.networking.packets.AetherPacket;
import com.legacy.aether.player.PlayerAether;
import com.legacy.aether.player.perks.util.DonatorMoaSkin;
import com.legacy.aether.player.perks.util.EnumAetherPerkType;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;

public class PacketPerkChanged
extends AetherPacket<PacketPerkChanged> {
    public int entityID;
    public boolean renderHalo;
    public boolean renderGlow;
    public DonatorMoaSkin moaSkin;
    public EnumAetherPerkType perkType;

    public PacketPerkChanged() {
    }

    public PacketPerkChanged(int entityID, EnumAetherPerkType type, boolean info) {
        this.entityID = entityID;
        this.perkType = type;
        if (type == EnumAetherPerkType.Halo) {
            this.renderHalo = info;
        }
        if (type == EnumAetherPerkType.Glow) {
            this.renderGlow = info;
        }
    }

    public PacketPerkChanged(int entityID, EnumAetherPerkType type, DonatorMoaSkin moa) {
        this.entityID = entityID;
        this.moaSkin = moa;
        this.perkType = type;
    }

    public void fromBytes(ByteBuf buf) {
        this.perkType = EnumAetherPerkType.getPerkByID(buf.readInt());
        this.entityID = buf.readInt();
        if (this.perkType == EnumAetherPerkType.Halo) {
            this.renderHalo = buf.readBoolean();
        } else if (this.perkType == EnumAetherPerkType.Moa) {
            this.moaSkin = DonatorMoaSkin.readMoaSkin(buf);
        } else if (this.perkType == EnumAetherPerkType.Glow) {
            this.renderGlow = buf.readBoolean();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.perkType.getPerkID());
        buf.writeInt(this.entityID);
        if (this.perkType == EnumAetherPerkType.Halo) {
            buf.writeBoolean(this.renderHalo);
        } else if (this.perkType == EnumAetherPerkType.Moa) {
            this.moaSkin.writeMoaSkin(buf);
        } else if (this.perkType == EnumAetherPerkType.Glow) {
            buf.writeBoolean(this.renderGlow);
        }
    }

    @Override
    public void handleClient(PacketPerkChanged message, EntityPlayer player) {
        EntityPlayer parent;
        if (player != null && player.field_70170_p != null && (parent = (EntityPlayer)player.field_70170_p.func_73045_a(message.entityID)) != null) {
            IPlayerAether instance = AetherAPI.getInstance().get(parent);
            if (message.perkType == EnumAetherPerkType.Halo) {
                ((PlayerAether)instance).shouldRenderHalo = message.renderHalo;
            } else if (message.perkType == EnumAetherPerkType.Moa) {
                ((PlayerAether)instance).donatorMoaSkin = message.moaSkin;
            } else if (message.perkType == EnumAetherPerkType.Glow) {
                ((PlayerAether)instance).shouldRenderGlow = message.renderGlow;
            }
        }
    }

    @Override
    public void handleServer(PacketPerkChanged message, EntityPlayer player) {
        if (player != null && player.field_70170_p != null && !player.field_70170_p.field_72995_K) {
            AetherNetworkingManager.sendToAll(message);
        }
    }
}

