/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.entities.ai.aerwhale;

import com.legacy.aether.entities.passive.EntityAerwhale;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class AerwhaleAITravelCourse
extends EntityAIBase {
    private EntityAerwhale aerwhale;
    private World worldObj;
    private double motionYaw;
    private double motionPitch;
    private double origin_direction;
    private double westward_direction;
    private double eastward_direction;
    private double upward_direction;
    private double downward_direction;

    public AerwhaleAITravelCourse(EntityAerwhale aerwhale) {
        this.aerwhale = aerwhale;
        this.worldObj = aerwhale.field_70170_p;
        this.func_75248_a(4);
    }

    public boolean func_75250_a() {
        return !this.aerwhale.field_70128_L;
    }

    public void func_75246_d() {
        this.origin_direction = this.checkForTravelableCourse(0.0f, 0.0f);
        this.westward_direction = this.checkForTravelableCourse(45.0f, 0.0f);
        this.upward_direction = this.checkForTravelableCourse(0.0f, 45.0f);
        this.eastward_direction = this.checkForTravelableCourse(-45.0f, 0.0f);
        this.downward_direction = this.checkForTravelableCourse(0.0f, -45.0f);
        int course = this.getCorrectCourse();
        if (course == 0) {
            if (this.origin_direction == 50.0) {
                this.motionYaw *= (double)0.9f;
                this.motionPitch *= (double)0.9f;
                if (this.aerwhale.field_70163_u > 100.0) {
                    this.motionPitch -= 2.0;
                }
                if (this.aerwhale.field_70163_u < 20.0) {
                    this.motionPitch += 2.0;
                }
            } else {
                this.aerwhale.field_70125_A = -this.aerwhale.field_70125_A;
                this.aerwhale.field_70177_z = -this.aerwhale.field_70177_z;
            }
        } else if (course == 1) {
            this.motionYaw += 5.0;
        } else if (course == 2) {
            this.motionPitch -= 5.0;
        } else if (course == 3) {
            this.motionYaw -= 5.0;
        } else {
            this.motionPitch += 5.0;
        }
        this.motionYaw += (double)(2.0f * this.aerwhale.func_70681_au().nextFloat() - 1.0f);
        this.motionPitch += (double)(2.0f * this.aerwhale.func_70681_au().nextFloat() - 1.0f);
        this.aerwhale.field_70125_A = (float)((double)this.aerwhale.field_70125_A + 0.1 * this.motionPitch);
        this.aerwhale.field_70177_z = (float)((double)this.aerwhale.field_70177_z + 0.1 * this.motionYaw);
        if (this.aerwhale.field_70125_A < -60.0f) {
            this.aerwhale.field_70125_A = -60.0f;
        }
        if (this.aerwhale.field_70125_A > 60.0f) {
            this.aerwhale.field_70125_A = 60.0f;
        }
        this.aerwhale.field_70125_A = (float)((double)this.aerwhale.field_70125_A * 0.99);
        this.aerwhale.field_70159_w += 0.005 * Math.cos((double)this.aerwhale.field_70177_z / 180.0 * Math.PI) * Math.cos((double)this.aerwhale.field_70125_A / 180.0 * Math.PI);
        this.aerwhale.field_70181_x += 0.005 * Math.sin((double)this.aerwhale.field_70125_A / 180.0 * Math.PI);
        this.aerwhale.field_70179_y += 0.005 * Math.sin((double)this.aerwhale.field_70177_z / 180.0 * Math.PI) * Math.cos((double)this.aerwhale.field_70125_A / 180.0 * Math.PI);
        this.aerwhale.field_70159_w *= 0.98;
        this.aerwhale.field_70181_x *= 0.98;
        this.aerwhale.field_70179_y *= 0.98;
        if (this.aerwhale.field_70159_w > 0.0 && this.worldObj.func_180495_p(this.aerwhale.func_180425_c().func_177974_f()).func_177230_c() != Blocks.field_150350_a) {
            this.aerwhale.field_70159_w = -this.aerwhale.field_70159_w;
            this.motionYaw -= 10.0;
        } else if (this.aerwhale.field_70159_w < 0.0 && this.worldObj.func_180495_p(this.aerwhale.func_180425_c().func_177976_e()).func_177230_c() != Blocks.field_150350_a) {
            this.aerwhale.field_70159_w = -this.aerwhale.field_70159_w;
            this.motionYaw += 10.0;
        } else if (this.aerwhale.field_70181_x > 0.0 && this.worldObj.func_180495_p(this.aerwhale.func_180425_c().func_177984_a()).func_177230_c() != Blocks.field_150350_a) {
            this.aerwhale.field_70181_x = -this.aerwhale.field_70181_x;
            this.motionPitch -= 10.0;
        } else if (this.aerwhale.field_70181_x < 0.0 && this.worldObj.func_180495_p(this.aerwhale.func_180425_c().func_177977_b()).func_177230_c() != Blocks.field_150350_a) {
            this.aerwhale.field_70181_x = -this.aerwhale.field_70181_x;
            this.motionPitch += 10.0;
        }
        if (this.aerwhale.field_70179_y > 0.0 && this.worldObj.func_180495_p(this.aerwhale.func_180425_c().func_177968_d()).func_177230_c() != Blocks.field_150350_a) {
            this.aerwhale.field_70179_y = -this.aerwhale.field_70179_y;
            this.motionYaw -= 10.0;
        } else if (this.aerwhale.field_70179_y < 0.0 && this.worldObj.func_180495_p(this.aerwhale.func_180425_c().func_177978_c()).func_177230_c() != Blocks.field_150350_a) {
            this.aerwhale.field_70179_y = -this.aerwhale.field_70179_y;
            this.motionYaw += 10.0;
        }
        this.aerwhale.func_70091_d(MoverType.SELF, this.aerwhale.field_70159_w, this.aerwhale.field_70181_x, this.aerwhale.field_70179_y);
    }

    private int getCorrectCourse() {
        double[] distances = new double[]{this.origin_direction, this.westward_direction, this.upward_direction, this.eastward_direction, this.downward_direction};
        int correctCourse = 0;
        for (int i = 1; i < 5; ++i) {
            if (!(distances[i] > distances[correctCourse])) continue;
            correctCourse = i;
        }
        return correctCourse;
    }

    private double checkForTravelableCourse(float rotationYawOffset, float rotationPitchOffset) {
        Vec3d vec3d1;
        double standard = 50.0;
        float yaw = this.aerwhale.field_70177_z + rotationYawOffset;
        float pitch = this.aerwhale.field_70177_z + rotationYawOffset;
        float f3 = MathHelper.func_76134_b((float)(-yaw * 0.01745329f - 3.141593f));
        float f4 = MathHelper.func_76126_a((float)(-yaw * 0.01745329f - 3.141593f));
        float f5 = MathHelper.func_76134_b((float)(-pitch * 0.01745329f));
        float f7 = f4 * f5;
        float f8 = MathHelper.func_76126_a((float)(-pitch * 0.01745329f));
        float f9 = f3 * f5;
        Vec3d vec3d = new Vec3d((Vec3i)this.aerwhale.func_180425_c());
        RayTraceResult movingobjectposition = this.worldObj.func_72901_a(vec3d, vec3d1 = vec3d.func_72441_c((double)f7 * standard, (double)f8 * standard, (double)f9 * standard), false);
        if (movingobjectposition == null) {
            return standard;
        }
        if (movingobjectposition.field_72313_a == RayTraceResult.Type.BLOCK) {
            double i = (double)movingobjectposition.func_178782_a().func_177958_n() - this.aerwhale.field_70165_t;
            double j = (double)movingobjectposition.func_178782_a().func_177956_o() - this.aerwhale.field_70163_u;
            double k = (double)movingobjectposition.func_178782_a().func_177952_p() - this.aerwhale.field_70161_v;
            return Math.sqrt(i * i + j * j + k * k);
        }
        return standard;
    }
}

