/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.jei.proxy;

import codechicken.nei.api.API;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.jei.proxy.IJEIProxy;
import codechicken.nei.util.LogHelper;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mezz.jei.Internal;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.recipes.RecipeRegistry;
import mezz.jei.runtime.JeiRuntime;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class JEIProxy
implements IJEIProxy {
    private static IJeiHelpers helpers;
    private static Set<Rectangle> extraAreasCache;

    public JEIProxy() {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        API.registerNEIGuiHandler(new INEIGuiHandler(){

            @Override
            public boolean hideItemPanelSlot(GuiContainer gui, int x, int y, int w, int h) {
                if (extraAreasCache == null) {
                    extraAreasCache = JEIProxy.this.getExtraAreas(gui);
                }
                for (Rectangle rectangle : extraAreasCache) {
                    if (!rectangle.intersects(x, y, w, h)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public boolean isJEIEnabled() {
        return true;
    }

    @Override
    public void openRecipeGui(ItemStack stack) {
        IFocus focus;
        RecipeRegistry registry = Internal.getRuntime().getRecipeRegistry();
        if (registry.getRecipeCategories(focus = registry.createFocus(IFocus.Mode.OUTPUT, (Object)stack)).isEmpty()) {
            return;
        }
        Internal.getRuntime().getRecipesGui().show(focus);
    }

    @Override
    public void openUsageGui(ItemStack stack) {
        IFocus focus;
        RecipeRegistry registry = Internal.getRuntime().getRecipeRegistry();
        if (registry.getRecipeCategories(focus = registry.createFocus(IFocus.Mode.INPUT, (Object)stack)).isEmpty()) {
            return;
        }
        Internal.getRuntime().getRecipesGui().show(focus);
    }

    @Override
    public boolean isBlacklistedJEI(ItemStack stack) {
        return stack.func_190926_b() || helpers.getIngredientBlacklist().isIngredientBlacklisted((Object)stack);
    }

    @Override
    public Set<Rectangle> getExtraAreas(GuiContainer container) {
        try {
            JeiRuntime runtime = Internal.getRuntime();
            if (runtime != null) {
                HashSet<Rectangle> rectangles = new HashSet<Rectangle>();
                for (IAdvancedGuiHandler handler : runtime.getActiveAdvancedGuiHandlers(container)) {
                    List ret = handler.getGuiExtraAreas(container);
                    if (ret == null) continue;
                    rectangles.addAll(ret);
                }
                return rectangles;
            }
        }
        catch (Throwable e) {
            LogHelper.errorOnce(e, "ExtraAreas", "Error thrown whilst accessing JEI internals!", new Object[0]);
        }
        return new HashSet<Rectangle>();
    }

    public static class EventHandler {
        @SubscribeEvent
        public void tickEvent(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                extraAreasCache = null;
            }
        }
    }

    @JEIPlugin
    public static class Plugin
    implements IModPlugin {
        public void register(IModRegistry registry) {
            helpers = registry.getJeiHelpers();
        }
    }
}

