/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.config;

import com.google.common.collect.SetMultimap;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.server.config.Config;
import net.ilexiconn.llibrary.server.config.ConfigEntry;
import net.ilexiconn.llibrary.server.config.EntryProperty;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;

@Deprecated
public enum ConfigHandler {
    INSTANCE;

    private Map<Class<?>, Class<EntryProperty>> entryPropertyClasses = new HashMap();
    private Map<String, ConfigContainer> configContainers = new HashMap<String, ConfigContainer>();

    public <T> void registerEntryPropertyClass(Class<T> type, Class<EntryProperty> entryAdapter) {
        this.entryPropertyClasses.put(type, entryAdapter);
    }

    public boolean hasConfigForID(String modid) {
        return this.configContainers.containsKey(modid);
    }

    public Configuration getConfigForID(String modid) {
        ConfigContainer configContainer = this.configContainers.get(modid);
        if (configContainer != null) {
            return configContainer.forgeConfiguration;
        }
        return null;
    }

    @Deprecated
    public Object getObjectForID(String modid) {
        ConfigContainer configContainer = this.configContainers.get(modid);
        if (configContainer != null) {
            return configContainer.wrappedConfig;
        }
        return null;
    }

    public <T> T getObjectForID(String modid, Class<T> type) {
        ConfigContainer configContainer = this.configContainers.get(modid);
        if (configContainer != null) {
            return type.cast(configContainer.wrappedConfig);
        }
        return null;
    }

    public void saveConfigForID(String modid) {
        ConfigContainer configContainer = this.configContainers.get(modid);
        if (configContainer != null) {
            configContainer.save();
        }
    }

    public void loadConfigForID(String modid) {
        ConfigContainer configContainer = this.configContainers.get(modid);
        if (configContainer != null) {
            configContainer.load();
        }
    }

    public void injectConfig(ModContainer mod, ASMDataTable data) {
        SetMultimap annotations = data.getAnnotationsFor(mod);
        if (annotations != null) {
            Set targetList = annotations.get((Object)Config.class.getName());
            ModClassLoader classLoader = Loader.instance().getModClassLoader();
            for (ASMDataTable.ASMData target : targetList) {
                try {
                    Class<?> targetClass = Class.forName(target.getClassName(), true, (ClassLoader)classLoader);
                    Field field = targetClass.getDeclaredField(target.getObjectName());
                    field.setAccessible(true);
                    Class<?> configClass = field.getType();
                    File configFile = new File(".", "config" + File.separator + mod.getModId() + ".cfg");
                    field.set(null, this.registerConfig(mod, configFile, configClass.newInstance()));
                }
                catch (Exception e) {
                    LLibrary.LOGGER.fatal("Failed to inject config for mod container " + mod, (Throwable)e);
                }
            }
        }
    }

    private <T> T registerConfig(ModContainer mod, File file, T config) {
        ConfigContainer configContainer = new ConfigContainer(mod, config, new Configuration(file));
        this.configContainers.put(mod.getModId(), configContainer);
        configContainer.load();
        configContainer.save();
        return config;
    }

    private class ConfigContainer {
        public final Object wrappedConfig;
        public final Configuration forgeConfiguration;
        private final List<EntryProperty> entryProperties;

        public ConfigContainer(ModContainer mod, Object wrappedConfig, Configuration forgeConfiguration) {
            this.wrappedConfig = wrappedConfig;
            this.forgeConfiguration = forgeConfiguration;
            this.entryProperties = Arrays.stream(wrappedConfig.getClass().getFields()).filter(field -> field.isAnnotationPresent(ConfigEntry.class)).map(field -> {
                Class entryPropertyClass = EntryProperty.getBuiltInPropertyClass(field.getType());
                if (entryPropertyClass == null) {
                    entryPropertyClass = (Class)ConfigHandler.this.entryPropertyClasses.get(field.getType());
                }
                if (entryPropertyClass != null) {
                    try {
                        return (EntryProperty)entryPropertyClass.getConstructor(Object.class, Field.class, Configuration.class).newInstance(wrappedConfig, field, forgeConfiguration);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    LLibrary.LOGGER.error("Found unsupported config entry " + field.getName() + " for mod " + mod.getName());
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }

        public void save() {
            this.entryProperties.forEach(EntryProperty::save);
            this.forgeConfiguration.save();
        }

        public void load() {
            this.entryProperties.forEach(EntryProperty::load);
        }

        public void reset() {
            this.entryProperties.forEach(EntryProperty::reset);
        }
    }
}

