/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.asm;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.ilexiconn.llibrary.server.asm.ClassPatcher;
import net.ilexiconn.llibrary.server.asm.Method;
import net.ilexiconn.llibrary.server.asm.RuntimePatcher;
import net.minecraftforge.fml.relauncher.FMLRelaunchLog;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class MethodPatcher {
    private ClassPatcher patcher;
    private String cls;
    private String method;
    private List<PatchData> patches = new ArrayList<PatchData>();

    public MethodPatcher(ClassPatcher patcher, String cls, String method) {
        this.patcher = patcher;
        this.cls = cls;
        this.method = method;
    }

    public ClassPatcher pop() {
        return this.patcher;
    }

    void handlePatches(MethodNode methodNode) {
        FMLRelaunchLog.info((String)("   Patching method " + this.method), (Object[])new Object[0]);
        this.patches.stream().filter(patch -> patch.predicate == null).forEach(patch -> {
            Method method = new Method(this.patcher, null);
            patch.consumer.accept(method);
            patch.at.apply((PatchData)patch, methodNode, null, method);
        });
        for (AbstractInsnNode insnNode : methodNode.instructions.toArray()) {
            this.patches.stream().filter(patch -> patch.predicate != null && patch.predicate.test(new PredicateData(this.patcher, this.cls, insnNode))).forEach(patch -> {
                Method method = new Method(this.patcher, insnNode);
                patch.consumer.accept(method);
                patch.at.apply((PatchData)patch, methodNode, insnNode, method);
            });
        }
    }

    public MethodPatcher apply(RuntimePatcher.Patch at, Consumer<Method> consumer) {
        return this.apply(at, null, consumer);
    }

    public MethodPatcher apply(RuntimePatcher.Patch at, Predicate<PredicateData> insnType, Consumer<Method> consumer) {
        this.patches.add(new PatchData(at, insnType, consumer));
        return this;
    }

    public String toString() {
        return "method:" + this.method;
    }

    public class PredicateData {
        public final ClassPatcher patcher;
        public final String cls;
        public final AbstractInsnNode node;

        public PredicateData(ClassPatcher patcher, String cls, AbstractInsnNode node) {
            this.patcher = patcher;
            this.cls = cls;
            this.node = node;
        }
    }

    public class PatchData {
        public final RuntimePatcher.Patch at;
        public final Predicate<PredicateData> predicate;
        public final Consumer<Method> consumer;

        public PatchData(RuntimePatcher.Patch at, Predicate<PredicateData> predicate, Consumer<Method> consumer) {
            this.at = at;
            this.predicate = predicate;
            this.consumer = consumer;
        }
    }
}

