/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client;

import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.client.ClientProxy;
import net.ilexiconn.llibrary.client.event.PlayerModelEvent;
import net.ilexiconn.llibrary.client.gui.SnackbarGUI;
import net.ilexiconn.llibrary.client.gui.survivaltab.PageButtonGUI;
import net.ilexiconn.llibrary.client.gui.survivaltab.SurvivalTab;
import net.ilexiconn.llibrary.client.gui.survivaltab.SurvivalTabGUI;
import net.ilexiconn.llibrary.client.gui.survivaltab.SurvivalTabHandler;
import net.ilexiconn.llibrary.client.gui.update.ModUpdateGUI;
import net.ilexiconn.llibrary.client.model.VoxelModel;
import net.ilexiconn.llibrary.client.util.ClientUtils;
import net.ilexiconn.llibrary.server.config.ConfigHandler;
import net.ilexiconn.llibrary.server.event.SurvivalTabClickEvent;
import net.ilexiconn.llibrary.server.snackbar.Snackbar;
import net.ilexiconn.llibrary.server.snackbar.SnackbarHandler;
import net.ilexiconn.llibrary.server.update.UpdateHandler;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.Rectangle;

@SideOnly(value=Side.CLIENT)
public enum ClientEventHandler {
    INSTANCE;

    private SnackbarGUI snackbarGUI;
    private boolean checkedForUpdates;
    private ModelBase voxelModel = new VoxelModel();

    public void setOpenSnackbar(SnackbarGUI snackbarGUI) {
        this.snackbarGUI = snackbarGUI;
    }

    @SubscribeEvent
    public void onInitGuiPost(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof GuiMainMenu) {
            int n;
            int offsetX = 0;
            int offsetY = 0;
            int buttonX = event.getGui().field_146294_l / 2 - 124 + offsetX;
            int n2 = event.getGui().field_146295_m / 4 + 48 + 48 + offsetY;
            while (true) {
                int n3;
                if (buttonX < 0) {
                    if (offsetY <= -48) {
                        buttonX = 0;
                        n = 0;
                        break;
                    }
                    offsetX = 0;
                    buttonX = event.getGui().field_146294_l / 2 - 124 + offsetX;
                    n3 = event.getGui().field_146295_m / 4 + 48 + 48 + (offsetY -= 24);
                }
                Rectangle rectangle = new Rectangle(buttonX, n3, 20, 20);
                boolean intersects = false;
                for (int i = 0; i < event.getButtonList().size(); ++i) {
                    GuiButton button = (GuiButton)event.getButtonList().get(i);
                    if (intersects) continue;
                    intersects = rectangle.intersects((ReadableRectangle)new Rectangle(button.field_146128_h, button.field_146129_i, button.field_146120_f, button.field_146121_g));
                }
                if (!intersects) break;
                buttonX -= 24;
            }
            if (!this.checkedForUpdates && !UpdateHandler.INSTANCE.getOutdatedModList().isEmpty()) {
                event.getButtonList().add(new GuiButton(ClientProxy.UPDATE_BUTTON_ID, buttonX, n, 20, 20, "U"));
                this.checkedForUpdates = true;
                SnackbarHandler.INSTANCE.showSnackbar(Snackbar.create(I18n.func_135052_a((String)"snackbar.llibrary.updates_found", (Object[])new Object[0])));
            }
        } else if (event.getGui() instanceof GuiContainer && (LLibrary.CONFIG.areTabsAlwaysVisible() || SurvivalTabHandler.INSTANCE.getSurvivalTabList().size() > 1)) {
            GuiContainer container = (GuiContainer)event.getGui();
            boolean flag = false;
            for (SurvivalTab survivalTab : SurvivalTabHandler.INSTANCE.getSurvivalTabList()) {
                if (survivalTab.getContainer() == null || !survivalTab.getContainer().isInstance(event.getGui())) continue;
                flag = true;
                break;
            }
            if (flag) {
                int count = 2;
                for (SurvivalTab tab : SurvivalTabHandler.INSTANCE.getSurvivalTabList()) {
                    if (tab.getPage() == SurvivalTabHandler.INSTANCE.getCurrentPage()) {
                        event.getButtonList().add(new SurvivalTabGUI(count, tab));
                    }
                    ++count;
                }
                if (count > 7) {
                    int n = (container.field_147000_g - 136) / 2 - 10;
                    if (LLibrary.CONFIG.areTabsLeftSide()) {
                        event.getButtonList().add(new PageButtonGUI(-1, container.field_147003_i - 82, container.field_147009_r + 136 + n, (GuiScreen)container));
                        event.getButtonList().add(new PageButtonGUI(-2, container.field_147003_i - 22, container.field_147009_r + 136 + n, (GuiScreen)container));
                    } else {
                        event.getButtonList().add(new PageButtonGUI(-1, container.field_147003_i + container.field_146999_f + 2, container.field_147009_r + 136 + n, (GuiScreen)container));
                        event.getButtonList().add(new PageButtonGUI(-2, container.field_147003_i + container.field_146999_f + 62, container.field_147009_r + 136 + n, (GuiScreen)container));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onButtonPressPre(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        if (event.getGui() instanceof GuiMainMenu && event.getButton().field_146127_k == ClientProxy.UPDATE_BUTTON_ID) {
            ClientProxy.MINECRAFT.func_147108_a((GuiScreen)new ModUpdateGUI((GuiMainMenu)event.getGui()));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onClientUpdate(TickEvent.ClientTickEvent event) {
        if (this.snackbarGUI == null && !ClientProxy.SNACKBAR_LIST.isEmpty()) {
            this.setOpenSnackbar(ClientProxy.SNACKBAR_LIST.get(0));
            ClientProxy.SNACKBAR_LIST.remove((Object)this.snackbarGUI);
        }
        if (this.snackbarGUI != null) {
            this.snackbarGUI.updateSnackbar();
        }
    }

    @SubscribeEvent
    public void onRenderUpdate(TickEvent.RenderTickEvent event) {
        ClientUtils.updateLast();
    }

    @SubscribeEvent
    public void onRenderOverlayPost(RenderGameOverlayEvent.Post event) {
        if (ClientProxy.MINECRAFT.field_71462_r == null && this.snackbarGUI != null && event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            this.snackbarGUI.drawSnackbar();
        }
    }

    @SubscribeEvent
    public void onDrawScreenPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (this.snackbarGUI != null) {
            this.snackbarGUI.drawSnackbar();
        }
    }

    @SubscribeEvent
    public void onRenderModel(PlayerModelEvent.Render event) {
        if (LLibrary.CONFIG.hasPatreonEffects() && ClientProxy.PATRONS != null && (ClientProxy.MINECRAFT.field_71474_y.field_74320_O != 0 || event.getEntityPlayer() != ClientProxy.MINECRAFT.field_71439_g)) {
            for (String name : ClientProxy.PATRONS) {
                if (!event.getEntityPlayer().func_146103_bH().getId().toString().equals(name)) continue;
                GlStateManager.func_179094_E();
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179140_f();
                GlStateManager.func_179109_b((float)0.0f, (float)-1.37f, (float)0.0f);
                this.renderVoxel(event, 1.1f, 0.23f);
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179145_e();
                GlStateManager.func_179109_b((float)0.0f, (float)0.128f, (float)0.0f);
                this.renderVoxel(event, 1.0f, 1.0f);
                GlStateManager.func_179121_F();
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        ConfigHandler.INSTANCE.loadConfigForID(event.getModID());
        ConfigHandler.INSTANCE.saveConfigForID(event.getModID());
    }

    @SubscribeEvent
    public void onSurvivalTabClick(SurvivalTabClickEvent event) {
        if (event.getLabel().equals("container.inventory")) {
            ClientProxy.MINECRAFT.func_147108_a((GuiScreen)new GuiInventory((EntityPlayer)ClientProxy.MINECRAFT.field_71439_g));
        }
    }

    private void renderVoxel(PlayerModelEvent.Render event, float scale, float color) {
        EntityPlayer player = event.getEntityPlayer();
        int ticksExisted = player.field_70173_aa;
        float partialTicks = LLibrary.PROXY.getPartialTicks();
        float bob = MathHelper.func_76126_a((float)(((float)ticksExisted + partialTicks) / 15.0f)) * 0.1f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179114_b((float)(-ClientUtils.interpolateRotation(player.field_70760_ar, player.field_70761_aq, partialTicks)), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179131_c((float)color, (float)color, (float)color, (float)1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(-1.0f + bob), (float)0.0f);
        GlStateManager.func_179114_b((float)ClientUtils.interpolateRotation((ticksExisted - 1) % 360, ticksExisted % 360, partialTicks), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.75f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)ClientUtils.interpolateRotation((ticksExisted - 1) % 360, ticksExisted % 360, partialTicks), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        this.voxelModel.func_78088_a((Entity)player, event.getLimbSwing(), event.getLimbSwingAmount(), event.getRotation(), event.getRotationYaw(), event.getRotationPitch(), event.getScale());
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }
}

