/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.flighthelper;

import de.guntram.mcmod.fabrictools.ConfigChangedEvent;
import de.guntram.mcmod.fabrictools.Configuration;
import de.guntram.mcmod.fabrictools.ModConfigurationHandler;
import java.io.File;

public class ConfigurationHandler
implements ModConfigurationHandler {
    private static ConfigurationHandler instance;
    private Configuration config;
    private String configFileName;
    private float lockUpAngle;
    private float lockFrontAngle;
    private boolean autoUnlock;

    public static ConfigurationHandler getInstance() {
        if (instance == null) {
            instance = new ConfigurationHandler();
        }
        return instance;
    }

    public void load(File configFile) {
        if (this.config == null) {
            this.config = new Configuration(configFile);
            this.configFileName = configFile.getPath();
            this.loadConfig();
        }
    }

    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("flighthelper")) {
            this.loadConfig();
        }
    }

    private void loadConfig() {
        this.config.migrate("Pitch Up", "flighthelper.config.pitchup");
        this.config.migrate("Pitch Front", "flighthelper.config.pitchfront");
        this.config.migrate("Auto unlock", "flighthelper.config.autounlock");
        this.lockUpAngle = this.config.getFloat("flighthelper.config.pitchup", 0, -55.0f, -90.0f, 90.0f, "flighthelper.config.tt.pitchup");
        this.lockFrontAngle = this.config.getFloat("flighthelper.config.pitchfront", 0, -2.2f, -90.0f, 90.0f, "flighthelper.config.tt.pitchfront");
        this.autoUnlock = this.config.getBoolean("flighthelper.config.autounlock", 0, false, "flighthelper.config.tt.autounlock");
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public Configuration getConfig() {
        return this.config;
    }

    public static String getConfigFileName() {
        return ConfigurationHandler.getInstance().configFileName;
    }

    public static float getUpAngle() {
        return ConfigurationHandler.getInstance().lockUpAngle;
    }

    public static float getFrontAngle() {
        return ConfigurationHandler.getInstance().lockFrontAngle;
    }

    public static boolean getAutoUnlock() {
        return ConfigurationHandler.getInstance().autoUnlock;
    }
}

