/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.GBForgetools.GuiElements;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import de.guntram.mcmod.GBForgetools.GuiModOptions;
import de.guntram.mcmod.GBForgetools.Types.ConfigurationMinecraftColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ColorSelector
extends Widget {
    private ColorButton[] buttons;
    private ConfigurationMinecraftColor currentColor;
    private String option;
    private Widget element;
    private GuiModOptions optionScreen;
    private int[] standardColors = new int[]{0, 170, 43520, 43690, 0xAA0000, 0xAA00AA, 0xFFAA00, 0xAAAAAA, 0x555555, 0x5555FF, 0x55FF55, 0x55FFFF, 0xFF5555, 0xFF55FF, 0xFFFF55, 0xFFFFFF};

    public ColorSelector(GuiModOptions optionScreen, StringTextComponent message) {
        super(0, 0, 120, 120, (ITextComponent)message);
        this.buttons = new ColorButton[16];
        this.optionScreen = optionScreen;
    }

    public void init() {
        StringTextComponent buttonText = new StringTextComponent("");
        this.field_230690_l_ = (this.optionScreen.field_230708_k_ - this.field_230688_j_) / 2;
        this.field_230691_m_ = (this.optionScreen.field_230709_l_ - this.field_230689_k_) / 2;
        for (int i = 0; i < 16; ++i) {
            this.buttons[i] = new ColorButton(this, this.field_230690_l_ + i / 4 * 25, this.field_230691_m_ + i % 4 * 25, 20, 20, buttonText, i, this.standardColors[i]);
        }
        this.field_230694_p_ = false;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.field_230694_p_) {
            for (int i = 0; i < this.buttons.length; ++i) {
                if (!this.buttons[i].func_231044_a_(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return false;
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        if (this.field_230694_p_) {
            for (int i = 0; i < 16; ++i) {
                this.buttons[i].func_230430_a_(stack, mouseX, mouseY, partialTicks);
            }
        }
    }

    public void setLink(String option, Widget element) {
        this.option = option;
        this.element = element;
    }

    public void setCurrentColor(ConfigurationMinecraftColor color) {
        this.currentColor = color;
    }

    public ConfigurationMinecraftColor getCurrentColor() {
        return this.currentColor;
    }

    public void onColorSelected(int color) {
        this.currentColor.colorIndex = color;
        this.optionScreen.onConfigChanging(this.option, this.currentColor);
        this.element.func_238482_a_(null);
        this.optionScreen.subscreenFinished();
    }

    private class ColorButton
    extends Widget {
        private final ColorSelector parent;
        private final int index;
        private final int color;

        public ColorButton(ColorSelector parent, int x, int y, int width, int height, StringTextComponent message, int index, int color) {
            super(x, y, width, height, (ITextComponent)message);
            this.index = index;
            this.color = color;
            this.parent = parent;
        }

        protected void func_230441_a_(MatrixStack stack, Minecraft mc, int mouseX, int mouseY) {
            if (this.field_230694_p_) {
                super.func_230441_a_(stack, mc, mouseX, mouseY);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferBuilder = tessellator.func_178180_c();
                float red = (float)(this.color >> 16) / 255.0f;
                float green = (float)(this.color >> 8 & 0xFF) / 255.0f;
                float blue = (float)(this.color >> 0 & 0xFF) / 255.0f;
                GlStateManager.func_227621_I_();
                bufferBuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
                Matrix4f model = stack.func_227866_c_().func_227870_a_();
                int x1 = this.field_230690_l_ + 3;
                int x2 = this.field_230690_l_ + this.field_230688_j_ - 3;
                int y1 = this.field_230691_m_ + 3;
                int y2 = this.field_230691_m_ + this.field_230689_k_ - 3;
                if (this.index == this.parent.getCurrentColor().colorIndex) {
                    bufferBuilder.func_227888_a_(model, (float)x1, (float)y1, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
                    bufferBuilder.func_227888_a_(model, (float)x1, (float)y2, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
                    bufferBuilder.func_227888_a_(model, (float)x2, (float)y2, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
                    bufferBuilder.func_227888_a_(model, (float)x2, (float)y1, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
                    tessellator.func_78381_a();
                    bufferBuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
                    ++x1;
                    ++y1;
                    --x2;
                    --y2;
                }
                bufferBuilder.func_227888_a_(model, (float)x1, (float)y1, 0.0f).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
                bufferBuilder.func_227888_a_(model, (float)x1, (float)y2, 0.0f).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
                bufferBuilder.func_227888_a_(model, (float)x2, (float)y2, 0.0f).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
                bufferBuilder.func_227888_a_(model, (float)x2, (float)y1, 0.0f).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_227619_H_();
            }
        }

        public void func_230982_a_(double mouseX, double mouseY) {
            this.parent.onColorSelected(this.index);
        }
    }
}

