/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.patcher;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiConsumer;
import net.fabricmc.tinyremapper.IMappingProvider;
import net.fabricmc.tinyremapper.OutputConsumerPath;
import net.fabricmc.tinyremapper.TinyRemapper;

public class RemapUtils {
    public static void mapJar(Path output, Path input, IMappingProvider mappings, List<Path> libraries) throws IOException {
        Files.deleteIfExists(output);
        TinyRemapper remapper = TinyRemapper.newRemapper().withMappings(mappings).renameInvalidLocals(true).rebuildSourceFilenames(true).build();
        try (OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(output).build();){
            outputConsumer.addNonClassFiles(input);
            remapper.readInputs(new Path[]{input});
            for (Path path : libraries) {
                remapper.readClassPath(new Path[]{path});
            }
            remapper.apply((BiConsumer)outputConsumer);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to remap jar", e);
        }
        finally {
            remapper.finish();
        }
    }
}

