/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.patcher;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import me.modmuss50.optifabric.patcher.ClassCache;
import me.modmuss50.optifabric.util.ZipUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class PatchSplitter {
    public static ClassCache generateClassCache(File inputFile, File classCacheOutput, byte[] inputHash) throws IOException {
        boolean extractClasses = Boolean.parseBoolean(System.getProperty("optifabric.extract", "false"));
        File classesDir = new File(classCacheOutput.getParent(), "classes");
        if (extractClasses) {
            classesDir.mkdir();
        }
        ClassCache classCache = new ClassCache(inputHash);
        ZipUtils.transformInPlace(inputFile, (jarFile, entry) -> {
            String name = entry.getName();
            if ((name.startsWith("net/minecraft/") || name.startsWith("com/mojang/")) && name.endsWith(".class")) {
                try (InputStream inputStream = jarFile.getInputStream(entry);){
                    byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
                    classCache.addClass(name.substring(0, name.length() - 6), bytes);
                    if (extractClasses) {
                        File classFile = new File(classesDir, name);
                        FileUtils.writeByteArrayToFile((File)classFile, (byte[])bytes);
                    }
                }
                return false;
            }
            return true;
        });
        System.out.println("Found " + classCache.getClasses().size() + " patched classes");
        classCache.save(classCacheOutput);
        return classCache;
    }
}

