/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.mod;

import com.chocohead.mm.api.ClassTinkerers;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import me.modmuss50.optifabric.patcher.ASMUtils;
import me.modmuss50.optifabric.patcher.ClassCache;
import me.modmuss50.optifabric.patcher.fixes.OptifineFixer;
import net.fabricmc.loader.api.FabricLoader;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.MethodNode;

public class OptifineInjector {
    private static Set<String> patched = new HashSet<String>();
    private final ClassCache classCache;

    public OptifineInjector(ClassCache classCache) {
        this.classCache = classCache;
    }

    public Optional<ClassNode> predictFuture(String className) {
        byte[] bytes = this.classCache.getClass(className);
        return bytes != null ? Optional.of(ASMUtils.readClassFromBytes(bytes)) : Optional.empty();
    }

    public void setup() {
        Consumer<ClassNode> transformer = target -> {
            if (!patched.add(target.name)) {
                System.out.println("Already patched " + target.name);
                return;
            }
            if (OptifineFixer.INSTANCE.shouldSkip(target.name)) {
                return;
            }
            Object2IntArrayMap memberToAccess = new Object2IntArrayMap(target.methods.size());
            memberToAccess.defaultReturnValue(-1);
            for (MethodNode method : target.methods) {
                memberToAccess.put((Object)(method.name + method.desc), method.access);
            }
            for (FieldNode field : target.fields) {
                memberToAccess.put((Object)(field.name + ' ' + field.desc), field.access);
            }
            ClassNode source = this.getSourceClassNode((ClassNode)target);
            OptifineFixer.INSTANCE.getFixers(target.name).forEach(classFixer -> classFixer.fix(source, (ClassNode)target));
            target.methods = source.methods;
            target.fields = source.fields;
            target.interfaces = source.interfaces;
            target.superName = source.superName;
            for (MethodNode methodNode : target.methods) {
                for (AbstractInsnNode insnNode : methodNode.instructions.toArray()) {
                    if (!(insnNode instanceof FrameNode)) continue;
                    FrameNode frameNode = (FrameNode)insnNode;
                    if (frameNode.local != null) continue;
                    throw new IllegalStateException("Null locals in " + frameNode.type + " frame @ " + source.name + "#" + methodNode.name + methodNode.desc);
                }
            }
            target.access = OptifineInjector.widerAccess(target.access, source.access);
            for (MethodNode method : target.methods) {
                int access = memberToAccess.getInt((Object)(method.name + method.desc));
                if (access == -1) continue;
                method.access = OptifineInjector.widerAccess(access, method.access);
            }
            for (FieldNode field : target.fields) {
                int access = memberToAccess.getInt((Object)(field.name + ' ' + field.desc));
                if (access == -1) continue;
                field.access = OptifineInjector.widerAccess(access, field.access);
            }
        };
        for (String name : this.classCache.getClasses()) {
            ClassTinkerers.addReplacement((String)name, transformer);
        }
    }

    private static int widerAccess(int origin, int target) {
        if (!Modifier.isFinal(origin)) {
            target &= 0xFFFFFFEF;
        }
        switch (target & 7) {
            case 1: {
                return target;
            }
            case 4: {
                return Modifier.isPublic(origin) ? target & 0xFFFFFFF8 | 1 : target;
            }
            case 0: {
                return Modifier.isPrivate(origin) ? target : target & 0xFFFFFFF8 | origin & 7;
            }
            case 2: {
                return target & 0xFFFFFFF8 | origin & 7;
            }
        }
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            throw new AssertionError((Object)("Unexpected access: " + target + " (transformed from " + origin + ')'));
        }
        return target;
    }

    private ClassNode getSourceClassNode(ClassNode classNode) {
        byte[] bytes = this.classCache.popClass(classNode.name);
        if (bytes == null) {
            throw new RuntimeException("Failed to find patched class for: " + classNode.name);
        }
        return ASMUtils.readClassFromBytes(bytes);
    }
}

