/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.compat;

import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import me.modmuss50.optifabric.compat.EmptyMixinPlugin;
import me.modmuss50.optifabric.compat.InterceptingMixin;
import me.modmuss50.optifabric.compat.LoudCoerce;
import me.modmuss50.optifabric.compat.PlacatingSurrogate;
import me.modmuss50.optifabric.compat.Shim;
import me.modmuss50.optifabric.util.MixinFinder;
import me.modmuss50.optifabric.util.RemappingUtils;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.Surrogate;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.util.Annotations;

public class InterceptingMixinPlugin
extends EmptyMixinPlugin {
    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        ClassNode thisMixin = MixinFinder.Mixin.create(mixinInfo).getClassNode();
        AnnotationNode interception = Annotations.getInvisible((ClassNode)thisMixin, InterceptingMixin.class);
        if (interception == null) {
            return;
        }
        MixinFinder.Mixin interceptionMixin = InterceptingMixinPlugin.findMixin(targetClassName, (String)Annotations.getValue((AnnotationNode)interception));
        block0: for (MethodNode method : thisMixin.methods) {
            AnnotationNode surrogateNode = Annotations.getInvisible((MethodNode)method, PlacatingSurrogate.class);
            if (surrogateNode == null) continue;
            for (ClassInfo.Method realMethod : interceptionMixin.getMethods()) {
                if (!realMethod.getOriginalName().equals(method.name)) continue;
                method.name = realMethod.getName();
                method.invisibleAnnotations.remove(surrogateNode);
                Annotations.setVisible((MethodNode)method, Surrogate.class, (Object[])new Object[0]);
                if (method.invisibleParameterAnnotations != null) {
                    Type[] arguments = Type.getArgumentTypes((String)method.desc);
                    boolean madeChange = false;
                    int end = arguments.length;
                    for (int i = 0; i < end; ++i) {
                        AnnotationNode coercionNode = Annotations.getInvisibleParameter((MethodNode)method, LoudCoerce.class, (int)i);
                        if (coercionNode == null) continue;
                        String type = (String)Annotations.getValue((AnnotationNode)coercionNode);
                        if (Annotations.getValue((AnnotationNode)coercionNode, (String)"remap") != Boolean.FALSE) {
                            type = RemappingUtils.getClassName(type);
                        }
                        arguments[i] = Type.getObjectType((String)type);
                        madeChange = true;
                    }
                    if (madeChange) {
                        method.desc = Type.getMethodDescriptor((Type)Type.getReturnType((String)method.desc), (Type[])arguments);
                    }
                }
                targetClass.methods.add(method);
                continue block0;
            }
            throw new IllegalStateException("Cannot find original Mixin method for surrogate " + method.name + method.desc + " in " + interceptionMixin);
        }
    }

    private static MixinFinder.Mixin findMixin(String targetClass, String mixinTarget) {
        for (MixinFinder.Mixin mixin : MixinFinder.getMixinsFor(targetClass)) {
            if (!mixinTarget.equals(mixin.getName())) continue;
            return mixin;
        }
        throw new IllegalArgumentException("Can't find Mixin class " + mixinTarget + " targetting " + targetClass);
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        ClassNode thisMixin = MixinFinder.Mixin.create(mixinInfo).getClassNode();
        AnnotationNode interception = Annotations.getInvisible((ClassNode)thisMixin, InterceptingMixin.class);
        if (interception == null) {
            return;
        }
        MixinFinder.Mixin interceptionMixin = InterceptingMixinPlugin.findMixin(targetClassName, (String)Annotations.getValue((AnnotationNode)interception));
        Map<String, String> shims = thisMixin.methods.stream().filter(method -> Annotations.getInvisible((MethodNode)method, Shim.class) != null).collect(Collectors.toMap(method -> method.name.concat(method.desc), method -> {
            ClassInfo.Method realMethod = interceptionMixin.getMethod(method.name, method.desc);
            if (realMethod == null) {
                throw new IllegalStateException("Cannot find shim method " + method.name + method.desc + " in " + interceptionMixin);
            }
            assert (method.name.equals(realMethod.getOriginalName()));
            return realMethod.getName();
        }));
        if (shims.isEmpty()) {
            return;
        }
        targetClassName = targetClassName.replace('.', '/');
        Iterator it = targetClass.methods.iterator();
        while (it.hasNext()) {
            MethodNode method2 = (MethodNode)it.next();
            if (shims.containsKey(method2.name.concat(method2.desc)) || Annotations.getInvisible((MethodNode)method2, PlacatingSurrogate.class) != null) {
                it.remove();
                continue;
            }
            for (AbstractInsnNode insn : method2.instructions) {
                if (insn.getType() != 5) continue;
                MethodInsnNode methodInsn = (MethodInsnNode)insn;
                String replacedName = shims.get(methodInsn.name.concat(methodInsn.desc));
                if (replacedName == null || !targetClassName.equals(methodInsn.owner)) continue;
                methodInsn.name = replacedName;
            }
        }
    }
}

