/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.NativeUnixSocket;
import org.newsclub.net.unix.SuppressFBWarnings;

@SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
final class NativeLibraryLoader
implements Closeable {
    private static final String PROP_LIBRARY_OVERRIDE = "org.newsclub.net.unix.library.override";
    private static final String PROP_LIBRARY_TMPDIR = "org.newsclub.net.unix.library.tmpdir";
    private static final File TEMP_DIR;
    private static final String ARCHITECTURE_AND_OS;
    private static final String LIBRARY_NAME = "junixsocket-native";
    private static boolean loaded;

    NativeLibraryLoader() {
    }

    public static String getJunixsocketVersion() throws IOException {
        return NativeLibraryLoader.getArtifactVersion(AFUNIXSocket.class, "junixsocket-common");
    }

    private static String getArtifactVersion(Class<?> providerClass, String ... artifactNames) throws IOException {
        int n = 0;
        String[] stringArray = artifactNames;
        int n2 = stringArray.length;
        if (n < n2) {
            String artifactName = stringArray[n];
            Properties p = new Properties();
            String resource = "/META-INF/maven/com.kohlschutter.junixsocket/" + artifactName + "/pom.properties";
            try (InputStream in = providerClass.getResourceAsStream(resource);){
                if (in == null) {
                    throw new FileNotFoundException("Could not find resource " + resource + " relative to " + providerClass);
                }
                p.load(in);
                String version = p.getProperty("version");
                Objects.requireNonNull(version, "Could not read version from pom.properties");
                String string = version;
                return string;
            }
        }
        throw new IllegalStateException("No artifact names specified");
    }

    private static String architectureAndOS() {
        return System.getProperty("os.arch") + "-" + System.getProperty("os.name").replaceAll(" ", "");
    }

    private static File createTempFile(String prefix, String suffix) throws IOException {
        return File.createTempFile(prefix, suffix, TEMP_DIR);
    }

    private List<LibraryCandidate> tryProviderClass(String providerClassname, String artifactName) throws IOException, ClassNotFoundException {
        Class<?> providerClass = Class.forName(providerClassname);
        String version = NativeLibraryLoader.getArtifactVersion(providerClass, artifactName);
        String libraryNameAndVersion = "junixsocket-native-" + version;
        return this.findLibraryCandidates(artifactName, libraryNameAndVersion, providerClass);
    }

    private synchronized void setLoaded(String library) {
        if (!loaded) {
            loaded = true;
            AFUNIXSocket.loadedLibrary = library;
            try {
                NativeUnixSocket.init();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadLibrary() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        synchronized (classLoader) {
            if (loaded) {
                return;
            }
            String libraryOverride = System.getProperty(PROP_LIBRARY_OVERRIDE, "");
            if (!libraryOverride.isEmpty()) {
                System.load(libraryOverride);
                this.setLoaded(libraryOverride);
                return;
            }
            ArrayList candidates = Lists.newArrayList();
            ArrayList suppressedThrowables = Lists.newArrayList();
            try {
                candidates.add(new StandardLibraryCandidate(NativeLibraryLoader.getArtifactVersion(this.getClass(), "junixsocket-common", "junixsocket-core")));
            }
            catch (Exception e) {
                suppressedThrowables.add(e);
            }
            try {
                candidates.addAll(this.tryProviderClass("org.newsclub.lib.junixsocket.custom.NarMetadata", "junixsocket-native-custom"));
            }
            catch (Exception e) {
                suppressedThrowables.add(e);
            }
            try {
                candidates.addAll(this.tryProviderClass("org.newsclub.lib.junixsocket.common.NarMetadata", "junixsocket-native-common"));
            }
            catch (Exception e) {
                suppressedThrowables.add(e);
            }
            String loadedLibraryId = null;
            for (LibraryCandidate candidate : candidates) {
                try {
                    loadedLibraryId = candidate.load();
                    if (loadedLibraryId == null) continue;
                    break;
                }
                catch (Exception | LinkageError e) {
                    suppressedThrowables.add(e);
                }
            }
            for (LibraryCandidate candidate : candidates) {
                candidate.close();
            }
            if (loadedLibraryId == null) {
                String message = "Could not load native library junixsocket-native for architecture " + ARCHITECTURE_AND_OS;
                String cp = System.getProperty("java.class.path", "");
                if (cp.contains("junixsocket-native-custom/target-eclipse") || cp.contains("junixsocket-native-common/target-eclipse")) {
                    message = message + "\n\n*** ECLIPSE USERS ***\nIf you're running from within Eclipse, please close the projects \"junixsocket-native-common\" and \"junixsocket-native-custom\"\n";
                }
                UnsatisfiedLinkError e = new UnsatisfiedLinkError(message);
                for (Throwable suppressed : suppressedThrowables) {
                    e.addSuppressed(suppressed);
                }
                throw e;
            }
            this.setLoaded(loadedLibraryId);
        }
    }

    private List<LibraryCandidate> findLibraryCandidates(String artifactName, String libraryNameAndVersion, Class<?> providerClass) {
        String mappedName = System.mapLibraryName(libraryNameAndVersion);
        ArrayList list = Lists.newArrayList();
        for (String compiler : new String[]{"gpp", "g++", "linker", "clang", "gcc", "cc", "CC", "icpc", "icc", "xlC", "xlC_r", "msvc", "icl", "ecpc", "ecc"}) {
            String nodepsPath;
            String path = "/lib/" + ARCHITECTURE_AND_OS + "-" + compiler + "/jni/" + mappedName;
            InputStream in = providerClass.getResourceAsStream(path);
            if (in != null) {
                list.add(new ClasspathLibraryCandidate(artifactName, libraryNameAndVersion, path, in));
            }
            if ((nodepsPath = this.nodepsPath(path)) == null || (in = providerClass.getResourceAsStream(nodepsPath)) == null) continue;
            list.add(new ClasspathLibraryCandidate(artifactName, libraryNameAndVersion, nodepsPath, in));
        }
        return list;
    }

    private String nodepsPath(String path) {
        int lastDot = path.lastIndexOf(46);
        if (lastDot == -1) {
            return null;
        }
        return path.substring(0, lastDot) + ".nodeps" + path.substring(lastDot);
    }

    @Override
    public void close() {
    }

    static {
        ARCHITECTURE_AND_OS = NativeLibraryLoader.architectureAndOS();
        loaded = false;
        String dir = System.getProperty(PROP_LIBRARY_TMPDIR, null);
        TEMP_DIR = dir == null ? null : new File(dir);
    }

    private static final class ClasspathLibraryCandidate
    extends LibraryCandidate {
        private final String artifactName;
        private final InputStream libraryIn;
        private final String path;

        ClasspathLibraryCandidate(String artifactName, String libraryNameAndVersion, String path, InputStream libraryIn) {
            super(libraryNameAndVersion);
            this.artifactName = artifactName;
            this.path = path;
            this.libraryIn = libraryIn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        synchronized String load() throws IOException, LinkageError {
            if (this.libraryNameAndVersion == null) {
                return null;
            }
            File libFile = NativeLibraryLoader.createTempFile("libtmp", System.mapLibraryName(this.libraryNameAndVersion));
            try (FileOutputStream out = new FileOutputStream(libFile);){
                int read;
                byte[] buf = new byte[4096];
                while ((read = this.libraryIn.read(buf)) >= 0) {
                    ((OutputStream)out).write(buf, 0, read);
                }
            }
            finally {
                this.libraryIn.close();
            }
            System.load(libFile.getAbsolutePath());
            if (!libFile.delete()) {
                libFile.deleteOnExit();
            }
            return this.artifactName + "/" + this.libraryNameAndVersion;
        }

        @Override
        public void close() {
            try {
                this.libraryIn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public String toString() {
            return super.toString() + "(" + this.artifactName + ":" + this.path + ")";
        }
    }

    private static final class StandardLibraryCandidate
    extends LibraryCandidate {
        StandardLibraryCandidate(String version) {
            super(version == null ? null : "junixsocket-native-" + version);
        }

        @Override
        String load() throws LinkageError {
            if (this.libraryNameAndVersion != null) {
                System.loadLibrary(this.libraryNameAndVersion);
                return this.libraryNameAndVersion;
            }
            return null;
        }

        @Override
        public void close() {
        }

        @Override
        public String toString() {
            return super.toString() + "(standard library path)";
        }
    }

    private static abstract class LibraryCandidate
    implements Closeable {
        protected final String libraryNameAndVersion;

        protected LibraryCandidate(String libraryNameAndVersion) {
            this.libraryNameAndVersion = libraryNameAndVersion;
        }

        abstract String load() throws Exception;

        @Override
        public abstract void close();

        public String toString() {
            return super.toString() + "[" + this.libraryNameAndVersion + "]";
        }
    }
}

