/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.world;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.impl.Pair;
import com.gitlab.cdagaming.craftpresence.utils.FileUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1959;
import net.minecraft.class_2378;

public class BiomeUtils {
    private final List<class_1959> BIOME_TYPES = Lists.newArrayList();
    public boolean isInUse = false;
    public boolean enabled = false;
    public List<String> BIOME_NAMES = Lists.newArrayList();
    private String CURRENT_BIOME_NAME;

    private void emptyData() {
        this.BIOME_NAMES.clear();
        this.BIOME_TYPES.clear();
        this.clearClientData();
    }

    public void clearClientData() {
        this.CURRENT_BIOME_NAME = null;
        this.isInUse = false;
        CraftPresence.CLIENT.initArgument("&BIOME&");
    }

    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.detectBiomeData : this.enabled;
        boolean bl = needsUpdate = this.enabled && (this.BIOME_NAMES.isEmpty() || this.BIOME_TYPES.isEmpty());
        if (needsUpdate) {
            this.getBiomes();
        }
        if (this.enabled) {
            if (CraftPresence.player != null) {
                this.isInUse = true;
                this.updateBiomeData();
            } else if (this.isInUse) {
                this.clearClientData();
            }
        } else {
            this.emptyData();
        }
    }

    private void updateBiomeData() {
        class_1959 newBiome = CraftPresence.player.field_6002.method_23753(CraftPresence.player.method_5704());
        String newBiomeName = newBiome.method_8693().method_10863();
        if (!newBiomeName.equals(this.CURRENT_BIOME_NAME)) {
            this.CURRENT_BIOME_NAME = newBiomeName;
            if (!this.BIOME_NAMES.contains(newBiomeName)) {
                this.BIOME_NAMES.add(newBiomeName);
            }
            if (!this.BIOME_TYPES.contains(newBiome)) {
                this.BIOME_TYPES.add(newBiome);
            }
            this.updateBiomePresence();
        }
    }

    public void updateBiomePresence() {
        ArrayList biomeArgs = Lists.newArrayList();
        biomeArgs.add(new Pair<String, String>("&BIOME&", this.CURRENT_BIOME_NAME));
        if (!CraftPresence.CLIENT.generalArgs.isEmpty()) {
            biomeArgs.addAll(CraftPresence.CLIENT.generalArgs);
        }
        String defaultBiomeMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.biomeMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        String currentBiomeMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.biomeMessages, this.CURRENT_BIOME_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultBiomeMessage);
        String currentBiomeIcon = StringUtils.getConfigPart(CraftPresence.CONFIG.biomeMessages, this.CURRENT_BIOME_NAME, 0, 2, CraftPresence.CONFIG.splitCharacter, this.CURRENT_BIOME_NAME);
        String formattedIconKey = StringUtils.formatAsIcon(currentBiomeIcon.replace(" ", "_"));
        String CURRENT_BIOME_ICON = formattedIconKey.replace("&icon&", CraftPresence.CONFIG.defaultBiomeIcon);
        String CURRENT_BIOME_MESSAGE = StringUtils.sequentialReplaceAnyCase(currentBiomeMessage, biomeArgs);
        CraftPresence.CLIENT.syncArgument("&BIOME&", CURRENT_BIOME_MESSAGE, false);
        CraftPresence.CLIENT.syncArgument("&BIOME&", CraftPresence.CLIENT.imageOf(CURRENT_BIOME_ICON, CraftPresence.CONFIG.defaultBiomeIcon, true), true);
    }

    private List<class_1959> getBiomeTypes() {
        ArrayList biomeTypes = Lists.newArrayList();
        ArrayList defaultBiomeTypes = Lists.newArrayList((Iterator)class_2378.field_11153.iterator());
        if (!defaultBiomeTypes.isEmpty()) {
            for (class_1959 class_19592 : defaultBiomeTypes) {
                if (class_19592 == null || biomeTypes.contains(class_19592)) continue;
                biomeTypes.add(class_19592);
            }
        }
        if (biomeTypes.isEmpty()) {
            for (Class clazz : FileUtils.getClassNamesMatchingSuperType(class_1959.class, true, "net.minecraft", "com.gitlab.cdagaming.craftpresence")) {
                if (clazz == null) continue;
                try {
                    class_1959 biomeObj = (class_1959)clazz.newInstance();
                    if (biomeTypes.contains(biomeObj)) continue;
                    biomeTypes.add(biomeObj);
                }
                catch (Error | Exception ex) {
                    if (!ModUtils.IS_VERBOSE) continue;
                    ex.printStackTrace();
                }
            }
        }
        return biomeTypes;
    }

    public void getBiomes() {
        for (class_1959 biome : this.getBiomeTypes()) {
            if (biome == null) continue;
            if (!this.BIOME_NAMES.contains(biome.method_8693().method_10863())) {
                this.BIOME_NAMES.add(biome.method_8693().method_10863());
            }
            if (this.BIOME_TYPES.contains(biome)) continue;
            this.BIOME_TYPES.add(biome);
        }
        for (String biomeMessage : CraftPresence.CONFIG.biomeMessages) {
            String[] part;
            if (StringUtils.isNullOrEmpty(biomeMessage) || StringUtils.isNullOrEmpty((part = biomeMessage.split(CraftPresence.CONFIG.splitCharacter))[0]) || this.BIOME_NAMES.contains(part[0])) continue;
            this.BIOME_NAMES.add(part[0]);
        }
    }
}

