/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.gui.impl;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.impl.Pair;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedScreen;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_437;

public class CharacterEditorGui
extends ExtendedScreen {
    private ExtendedButtonControl saveButton;
    private ExtendedButtonControl syncSingleButton;
    private ExtendedTextControl charInput;
    private ExtendedTextControl charWidth;
    private String lastScannedString;
    private char lastScannedChar;
    private int[] originalCharArray = (int[])StringUtils.MC_CHAR_WIDTH.clone();
    private byte[] originalGlyphArray = (byte[])StringUtils.MC_GLYPH_WIDTH.clone();

    public CharacterEditorGui(class_437 parentScreen) {
        super(parentScreen);
    }

    @Override
    public void initializeUi() {
        this.charInput = this.addControl(new ExtendedTextControl(this.getFontRenderer(), this.width / 2 + 3, CraftPresence.GUIS.getButtonY(1), 180, 20));
        this.charWidth = this.addControl(new ExtendedTextControl(this.getFontRenderer(), this.width / 2 + 3, CraftPresence.GUIS.getButtonY(2), 180, 20));
        this.charInput.method_1880(1);
        this.charWidth.method_1880(2);
        ExtendedButtonControl resetCharsButton = this.addControl(new ExtendedButtonControl(this.width / 2 - 90, this.height - 30, 180, 20, ModUtils.TRANSLATOR.translate("gui.config.message.button.reset", new Object[0]), () -> ModUtils.loadCharData(true, "UTF-8"), new String[0]));
        ExtendedButtonControl syncAllButton = this.addControl(new ExtendedButtonControl(this.width / 2 - 90, resetCharsButton.getControlPosY() - 25, 180, 20, ModUtils.TRANSLATOR.translate("gui.config.message.button.sync.all", new Object[0]), () -> {
            for (int currentCharIndex = 0; currentCharIndex < StringUtils.MC_CHAR_WIDTH.length - 1; ++currentCharIndex) {
                char characterObj = (char)currentCharIndex;
                StringUtils.MC_CHAR_WIDTH[currentCharIndex] = this.getFontRenderer().method_1727(Character.toString(characterObj));
            }
            for (int currentGlyphIndex = 0; currentGlyphIndex < StringUtils.MC_GLYPH_WIDTH.length - 1; ++currentGlyphIndex) {
                char glyphObj = (char)(currentGlyphIndex & 0xFF);
                StringUtils.MC_GLYPH_WIDTH[currentGlyphIndex] = (byte)this.getFontRenderer().method_1727(Character.toString(glyphObj));
            }
        }, new String[0]));
        this.syncSingleButton = this.addControl(new ExtendedButtonControl(this.width / 2 - 90, syncAllButton.getControlPosY() - 25, 180, 20, ModUtils.TRANSLATOR.translate("gui.config.message.button.sync.single", this.charInput.method_1882()), () -> {
            if (this.lastScannedChar > '\u0000' && this.lastScannedChar < StringUtils.MC_CHAR_WIDTH.length && !ModUtils.TRANSLATOR.isUnicode) {
                StringUtils.MC_CHAR_WIDTH[this.lastScannedChar] = this.getFontRenderer().method_1727(Character.toString(this.lastScannedChar));
            } else if (StringUtils.MC_GLYPH_WIDTH[this.lastScannedChar] != 0) {
                StringUtils.MC_GLYPH_WIDTH[this.lastScannedChar & 0xFF] = (byte)this.getFontRenderer().method_1727(Character.toString(this.lastScannedChar));
            }
        }, new String[0]));
        this.addControl(new ExtendedButtonControl(5, this.height - 30, 100, 20, ModUtils.TRANSLATOR.translate("gui.config.message.button.back", new Object[0]), () -> CraftPresence.GUIS.openScreen(this.parentScreen), new String[0]));
        this.saveButton = this.addControl(new ExtendedButtonControl(this.width - 105, this.height - 30, 100, 20, ModUtils.TRANSLATOR.translate("gui.config.message.button.save", new Object[0]), () -> {
            Pair<Boolean, Integer> charData = StringUtils.getValidInteger(this.charWidth.method_1882());
            if (charData.getFirst().booleanValue()) {
                int characterWidth = charData.getSecond();
                if (this.lastScannedChar > '\u0000' && this.lastScannedChar <= StringUtils.MC_CHAR_WIDTH.length && !ModUtils.TRANSLATOR.isUnicode) {
                    StringUtils.MC_CHAR_WIDTH[this.lastScannedChar] = characterWidth;
                } else if (StringUtils.MC_GLYPH_WIDTH[this.lastScannedChar] != 0) {
                    StringUtils.MC_GLYPH_WIDTH[this.lastScannedChar & 0xFF] = (byte)characterWidth;
                }
            }
        }, new String[0]));
        super.initializeUi();
    }

    @Override
    public void preRender() {
        this.checkValues();
        String mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title.editor.character", new Object[0]);
        String charInputTitle = ModUtils.TRANSLATOR.translate("gui.config.message.editor.char.input", new Object[0]);
        String charWidthTitle = ModUtils.TRANSLATOR.translate("gui.config.message.editor.char.width", new Object[0]);
        List<String> notice = StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.character.notice", new Object[0]));
        this.renderNotice(notice, 2.0f, 2.0f);
        this.renderString(mainTitle, (float)this.width / 2.0f - (float)StringUtils.getStringWidth(mainTitle) / 2.0f, 15.0f, 0xFFFFFF);
        this.renderString(charInputTitle, (float)this.width / 2.0f - 130.0f, CraftPresence.GUIS.getButtonY(1) + 5, 0xFFFFFF);
        if (StringUtils.isNullOrEmpty(this.charInput.method_1882())) {
            this.charWidth.method_1852("");
            this.charWidth.method_1862(false);
            this.charWidth.method_1888(this.charWidth.method_1885());
            this.syncSingleButton.setControlEnabled(false);
        }
        if (!this.charInput.method_1882().equals(this.lastScannedString)) {
            this.lastScannedString = this.charInput.method_1882();
            if (!StringUtils.isNullOrEmpty(this.lastScannedString)) {
                this.lastScannedChar = this.lastScannedString.charAt(0);
                this.charWidth.method_1852(Integer.toString(StringUtils.getStringWidth(this.lastScannedString)));
                this.charWidth.method_1862(true);
                this.charWidth.method_1888(this.charWidth.method_1885());
                this.syncSingleButton.setControlEnabled(true);
            } else {
                this.lastScannedChar = '\u0000';
            }
        }
        if (this.charWidth.method_1885()) {
            this.renderString(charWidthTitle, (float)this.width / 2.0f - 130.0f, CraftPresence.GUIS.getButtonY(2) + 10, 0xFFFFFF);
        }
        this.syncSingleButton.setControlMessage(ModUtils.TRANSLATOR.translate("gui.config.message.button.sync.single", this.charInput.method_1882()));
        this.saveButton.setControlEnabled(this.syncSingleButton.isControlEnabled());
        this.syncSingleButton.setControlVisible(this.syncSingleButton.isControlEnabled());
        this.saveButton.setControlVisible(this.syncSingleButton.isControlVisible());
    }

    private void checkValues() {
        if (!Arrays.equals(this.originalCharArray, StringUtils.MC_CHAR_WIDTH) || !Arrays.equals(this.originalGlyphArray, StringUtils.MC_GLYPH_WIDTH)) {
            ModUtils.writeToCharData("UTF-8");
            this.originalCharArray = (int[])StringUtils.MC_CHAR_WIDTH.clone();
            this.originalGlyphArray = (byte[])StringUtils.MC_GLYPH_WIDTH.clone();
            this.lastScannedString = null;
            this.lastScannedChar = '\u0000';
            this.charInput.method_1852("");
            this.charWidth.method_1852("");
        }
    }
}

