/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.gui.controls;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.impl.Pair;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;

public class CheckBoxControl
extends ExtendedButtonControl {
    public int boxWidth;
    private boolean is_Checked;

    public CheckBoxControl(int id, int xPos, int yPos, String displayString, boolean isChecked) {
        super(id, xPos, yPos, displayString);
        this.is_Checked = isChecked;
        this.boxWidth = 11;
        this.height = 11;
        this.width = this.boxWidth + 2 + StringUtils.getStringWidth(displayString);
    }

    public CheckBoxControl(int id, int xPos, int yPos, String displayString, boolean isChecked, Runnable onPushEvent) {
        this(id, xPos, yPos, displayString, isChecked);
        this.setOnClick(onPushEvent);
    }

    public CheckBoxControl(int id, int xPos, int yPos, String displayString, boolean isChecked, Runnable onPushEvent, Runnable onHoverEvent) {
        this(id, xPos, yPos, displayString, isChecked, onPushEvent);
        this.setOnHover(onHoverEvent);
    }

    public CheckBoxControl(int xPos, int yPos, String displayString, boolean isChecked) {
        this(CraftPresence.GUIS.getNextIndex(), xPos, yPos, displayString, isChecked);
    }

    public CheckBoxControl(int xPos, int yPos, String displayString, boolean isChecked, Runnable onPushEvent) {
        this(xPos, yPos, displayString, isChecked);
        this.setOnClick(onPushEvent);
    }

    public CheckBoxControl(int xPos, int yPos, String displayString, boolean isChecked, Runnable onPushEvent, Runnable onHoverEvent) {
        this(xPos, yPos, displayString, isChecked, onPushEvent);
        this.setOnHover(onHoverEvent);
    }

    @Override
    public void render(int mouseX, int mouseY, float partial) {
        if (this.visible) {
            int color;
            this.isHovered = CraftPresence.GUIS.isMouseOver((double)mouseX, (double)mouseY, this);
            CraftPresence.GUIS.drawContinuousTexturedBox(new Pair<Integer, Integer>(this.getControlPosX(), this.getControlPosY()), new Pair<Integer, Integer>(0, 46), new Pair<Integer, Integer>(this.boxWidth, this.getControlHeight()), new Pair<Integer, Integer>(200, 20), new Pair<Integer, Integer>(2, 3), new Pair<Integer, Integer>(2, 2), this.getBlitOffset(), WIDGETS_LOCATION);
            this.renderBg(CraftPresence.instance, mouseX, mouseY);
            int n = color = !this.isControlEnabled() ? 0xA0A0A0 : 0xE0E0E0;
            if (this.is_Checked) {
                this.drawCenteredString(this.getFontRenderer(), "x", this.getControlPosX() + this.boxWidth / 2 + 1, this.getControlPosY() + 1, 0xE0E0E0);
            }
            this.drawString(this.getFontRenderer(), this.getControlMessage(), this.getControlPosX() + this.boxWidth + 2, this.getControlPosY() + 2, color);
        }
    }

    @Override
    public void onClick(double mouseX, double mouseY) {
        if (this.isControlEnabled() && this.visible && this.isHovered) {
            this.is_Checked = !this.is_Checked;
        }
    }

    public boolean isChecked() {
        return this.is_Checked;
    }
}

