/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.entity;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.impl.Pair;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2378;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_3966;
import net.minecraft.class_640;

public class EntityUtils {
    private final List<String> ENTITY_CLASSES = Lists.newArrayList();
    public boolean isInUse = false;
    public boolean enabled = false;
    public String CURRENT_TARGET_NAME;
    public String CURRENT_ATTACKING_NAME;
    public String CURRENT_RIDING_NAME;
    public List<String> ENTITY_NAMES = Lists.newArrayList();
    public List<String> CURRENT_TARGET_TAGS = Lists.newArrayList();
    public List<String> CURRENT_ATTACKING_TAGS = Lists.newArrayList();
    public List<String> CURRENT_RIDING_TAGS = Lists.newArrayList();
    private class_1297 CURRENT_TARGET;
    private class_1297 CURRENT_ATTACKING;
    private class_1297 CURRENT_RIDING;
    private class_2487 CURRENT_TARGET_TAG;
    private class_2487 CURRENT_ATTACKING_TAG;
    private class_2487 CURRENT_RIDING_TAG;
    private boolean allEntitiesEmpty = false;
    private boolean currentlyCleared = true;

    private void emptyData() {
        this.ENTITY_NAMES.clear();
        this.ENTITY_CLASSES.clear();
        this.clearClientData();
    }

    public void clearClientData() {
        this.CURRENT_TARGET = null;
        this.CURRENT_ATTACKING = null;
        this.CURRENT_RIDING = null;
        this.CURRENT_TARGET_NAME = null;
        this.CURRENT_ATTACKING_NAME = null;
        this.CURRENT_RIDING_NAME = null;
        this.CURRENT_TARGET_TAG = null;
        this.CURRENT_ATTACKING_TAG = null;
        this.CURRENT_RIDING_TAG = null;
        this.CURRENT_TARGET_TAGS.clear();
        this.CURRENT_ATTACKING_TAGS.clear();
        this.CURRENT_RIDING_TAGS.clear();
        this.allEntitiesEmpty = true;
        this.isInUse = false;
        this.currentlyCleared = true;
    }

    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.enablePerEntity : this.enabled;
        boolean bl = needsUpdate = this.enabled && (this.ENTITY_NAMES.isEmpty() || this.ENTITY_CLASSES.isEmpty());
        if (needsUpdate) {
            this.getEntities();
        }
        if (this.enabled) {
            if (CraftPresence.player != null) {
                this.isInUse = true;
                this.updateEntityData();
            } else if (this.isInUse) {
                this.clearClientData();
            }
        } else {
            this.emptyData();
        }
    }

    private void updateEntityData() {
        boolean hasRidingChanged;
        String NEW_CURRENT_RIDING_NAME;
        String NEW_CURRENT_ATTACKING_NAME;
        String NEW_CURRENT_TARGET_NAME;
        class_1297 NEW_CURRENT_TARGET = CraftPresence.instance.field_1765 != null && CraftPresence.instance.field_1765.method_17783() == class_239.class_240.field_1331 ? ((class_3966)CraftPresence.instance.field_1765).method_17782() : null;
        class_1309 NEW_CURRENT_ATTACKING = CraftPresence.player.method_6052();
        class_1297 NEW_CURRENT_RIDING = CraftPresence.player.method_5854();
        if (NEW_CURRENT_TARGET instanceof class_1657) {
            class_1657 NEW_CURRENT_PLAYER_TARGET = (class_1657)NEW_CURRENT_TARGET;
            NEW_CURRENT_TARGET_NAME = StringUtils.stripColors(NEW_CURRENT_PLAYER_TARGET.method_7334().getId().toString());
        } else {
            String string = NEW_CURRENT_TARGET_NAME = NEW_CURRENT_TARGET != null ? StringUtils.stripColors(NEW_CURRENT_TARGET.method_5476().method_10863()) : "";
        }
        if (NEW_CURRENT_ATTACKING instanceof class_1657) {
            class_1657 NEW_CURRENT_PLAYER_ATTACKING = (class_1657)NEW_CURRENT_ATTACKING;
            NEW_CURRENT_ATTACKING_NAME = StringUtils.stripColors(NEW_CURRENT_PLAYER_ATTACKING.method_7334().getId().toString());
        } else {
            String string = NEW_CURRENT_ATTACKING_NAME = NEW_CURRENT_ATTACKING != null ? StringUtils.stripColors(NEW_CURRENT_ATTACKING.method_5476().method_10863()) : "";
        }
        if (NEW_CURRENT_RIDING instanceof class_1657) {
            class_1657 NEW_CURRENT_PLAYER_RIDING = (class_1657)NEW_CURRENT_RIDING;
            NEW_CURRENT_RIDING_NAME = StringUtils.stripColors(NEW_CURRENT_PLAYER_RIDING.method_7334().getId().toString());
        } else {
            NEW_CURRENT_RIDING_NAME = NEW_CURRENT_RIDING != null ? StringUtils.stripColors(NEW_CURRENT_RIDING.method_5476().method_10863()) : "";
        }
        boolean hasTargetChanged = NEW_CURRENT_TARGET != null && !NEW_CURRENT_TARGET.equals((Object)this.CURRENT_TARGET) || !NEW_CURRENT_TARGET_NAME.equals(this.CURRENT_TARGET_NAME) || NEW_CURRENT_TARGET == null && this.CURRENT_TARGET != null;
        boolean hasAttackingChanged = NEW_CURRENT_ATTACKING != null && !NEW_CURRENT_ATTACKING.equals((Object)this.CURRENT_ATTACKING) || !NEW_CURRENT_ATTACKING_NAME.equals(this.CURRENT_ATTACKING_NAME) || NEW_CURRENT_ATTACKING == null && this.CURRENT_ATTACKING != null;
        boolean bl = hasRidingChanged = NEW_CURRENT_RIDING != null && !NEW_CURRENT_RIDING.equals((Object)this.CURRENT_RIDING) || !NEW_CURRENT_RIDING_NAME.equals(this.CURRENT_RIDING_NAME) || NEW_CURRENT_RIDING == null && this.CURRENT_RIDING != null;
        if (hasTargetChanged) {
            ArrayList NEW_CURRENT_TARGET_TAGS;
            this.CURRENT_TARGET = NEW_CURRENT_TARGET;
            this.CURRENT_TARGET_TAG = this.CURRENT_TARGET != null ? this.CURRENT_TARGET.method_5647(new class_2487()) : null;
            ArrayList arrayList = NEW_CURRENT_TARGET_TAGS = this.CURRENT_TARGET_TAG != null ? Lists.newArrayList((Iterable)this.CURRENT_TARGET_TAG.method_10541()) : Lists.newArrayList();
            if (!NEW_CURRENT_TARGET_TAGS.equals(this.CURRENT_TARGET_TAGS)) {
                this.CURRENT_TARGET_TAGS = NEW_CURRENT_TARGET_TAGS;
            }
            this.CURRENT_TARGET_NAME = NEW_CURRENT_TARGET_NAME;
        }
        if (hasAttackingChanged) {
            ArrayList NEW_CURRENT_ATTACKING_TAGS;
            this.CURRENT_ATTACKING = NEW_CURRENT_ATTACKING;
            this.CURRENT_ATTACKING_TAG = this.CURRENT_ATTACKING != null ? this.CURRENT_ATTACKING.method_5647(new class_2487()) : null;
            ArrayList arrayList = NEW_CURRENT_ATTACKING_TAGS = this.CURRENT_ATTACKING_TAG != null ? Lists.newArrayList((Iterable)this.CURRENT_ATTACKING_TAG.method_10541()) : Lists.newArrayList();
            if (!NEW_CURRENT_ATTACKING_TAGS.equals(this.CURRENT_ATTACKING_TAGS)) {
                this.CURRENT_ATTACKING_TAGS = NEW_CURRENT_ATTACKING_TAGS;
            }
            this.CURRENT_ATTACKING_NAME = NEW_CURRENT_ATTACKING_NAME;
        }
        if (hasRidingChanged) {
            ArrayList NEW_CURRENT_RIDING_TAGS;
            this.CURRENT_RIDING = NEW_CURRENT_RIDING;
            this.CURRENT_RIDING_TAG = this.CURRENT_RIDING != null ? this.CURRENT_RIDING.method_5647(new class_2487()) : null;
            ArrayList arrayList = NEW_CURRENT_RIDING_TAGS = this.CURRENT_RIDING_TAG != null ? Lists.newArrayList((Iterable)this.CURRENT_RIDING_TAG.method_10541()) : Lists.newArrayList();
            if (!NEW_CURRENT_RIDING_TAGS.equals(this.CURRENT_RIDING_TAGS)) {
                this.CURRENT_RIDING_TAGS = NEW_CURRENT_RIDING_TAGS;
            }
            this.CURRENT_RIDING_NAME = NEW_CURRENT_RIDING_NAME;
        }
        if (hasTargetChanged || hasAttackingChanged || hasRidingChanged) {
            this.allEntitiesEmpty = this.CURRENT_TARGET == null && this.CURRENT_ATTACKING == null && this.CURRENT_RIDING == null;
            this.updateEntityPresence();
        }
    }

    public void updateEntityPresence() {
        String defaultEntityTargetMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.entityTargetMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        String defaultEntityAttackingMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.entityAttackingMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        String defaultEntityRidingMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.entityRidingMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        String targetEntityMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.entityTargetMessages, this.CURRENT_TARGET_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultEntityTargetMessage);
        String attackingEntityMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.entityAttackingMessages, this.CURRENT_ATTACKING_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultEntityAttackingMessage);
        String ridingEntityMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.entityRidingMessages, this.CURRENT_RIDING_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultEntityRidingMessage);
        ArrayList entityTargetArgs = Lists.newArrayList();
        ArrayList entityAttackingArgs = Lists.newArrayList();
        ArrayList entityRidingArgs = Lists.newArrayList();
        entityTargetArgs.add(new Pair<String, String>("&entity&", this.CURRENT_TARGET_NAME));
        entityAttackingArgs.add(new Pair<String, String>("&entity&", this.CURRENT_ATTACKING_NAME));
        entityRidingArgs.add(new Pair<String, String>("&entity&", this.CURRENT_RIDING_NAME));
        if (!this.CURRENT_TARGET_TAGS.isEmpty()) {
            for (String tagName : this.CURRENT_TARGET_TAGS) {
                entityTargetArgs.add(new Pair<String, String>("&" + tagName + "&", this.CURRENT_TARGET_TAG.method_10580(tagName).toString()));
            }
        }
        if (!this.CURRENT_ATTACKING_TAGS.isEmpty()) {
            for (String tagName : this.CURRENT_ATTACKING_TAGS) {
                entityAttackingArgs.add(new Pair<String, String>("&" + tagName + "&", this.CURRENT_ATTACKING_TAG.method_10580(tagName).toString()));
            }
        }
        if (!this.CURRENT_RIDING_TAGS.isEmpty()) {
            for (String tagName : this.CURRENT_RIDING_TAGS) {
                entityRidingArgs.add(new Pair<String, String>("&" + tagName + "&", this.CURRENT_RIDING_TAG.method_10580(tagName).toString()));
            }
        }
        if (!CraftPresence.CLIENT.generalArgs.isEmpty()) {
            entityTargetArgs.addAll(CraftPresence.CLIENT.generalArgs);
            entityAttackingArgs.addAll(CraftPresence.CLIENT.generalArgs);
            entityRidingArgs.addAll(CraftPresence.CLIENT.generalArgs);
        }
        String CURRENT_TARGET_MESSAGE = StringUtils.sequentialReplaceAnyCase(targetEntityMessage, entityTargetArgs);
        String CURRENT_ATTACKING_MESSAGE = StringUtils.sequentialReplaceAnyCase(attackingEntityMessage, entityAttackingArgs);
        String CURRENT_RIDING_MESSAGE = StringUtils.sequentialReplaceAnyCase(ridingEntityMessage, entityRidingArgs);
        if (!this.allEntitiesEmpty) {
            CraftPresence.CLIENT.syncArgument("&TARGETENTITY&", CURRENT_TARGET_MESSAGE, false);
            CraftPresence.CLIENT.syncArgument("&ATTACKINGENTITY&", CURRENT_ATTACKING_MESSAGE, false);
            CraftPresence.CLIENT.syncArgument("&RIDINGENTITY&", CURRENT_RIDING_MESSAGE, false);
        } else if (!this.currentlyCleared) {
            CraftPresence.CLIENT.initArgument("&TARGETENTITY&", "&ATTACKINGENTITY&", "&RIDINGENTITY&");
        }
    }

    public List<String> getListFromName(String name) {
        return name.equalsIgnoreCase(this.CURRENT_TARGET_NAME) ? this.CURRENT_TARGET_TAGS : (name.equalsIgnoreCase(this.CURRENT_ATTACKING_NAME) ? this.CURRENT_ATTACKING_TAGS : (name.equalsIgnoreCase(this.CURRENT_RIDING_NAME) ? this.CURRENT_RIDING_TAGS : Lists.newArrayList()));
    }

    public String generatePlaceholderString(String name, List<String> tags) {
        StringBuilder finalString = new StringBuilder();
        if (!tags.isEmpty()) {
            for (String tagName : tags) {
                String tagValue;
                finalString.append("\n - &").append(tagName).append("&");
                if (!ModUtils.IS_DEV || StringUtils.isNullOrEmpty(tagValue = tags.equals(this.CURRENT_TARGET_TAGS) ? this.CURRENT_TARGET_TAG.method_10580(tagName).toString() : (tags.equals(this.CURRENT_ATTACKING_TAGS) ? this.CURRENT_ATTACKING_TAG.method_10580(tagName).toString() : (tags.equals(this.CURRENT_RIDING_TAGS) ? this.CURRENT_RIDING_TAG.method_10580(tagName).toString() : null)))) continue;
                finalString.append(" (Value -> ").append(tagValue).append(")");
            }
        }
        return (!StringUtils.isNullOrEmpty(name) ? name : "None") + " " + (!StringUtils.isNullOrEmpty(finalString.toString()) ? finalString.toString() : "\\n - N/A");
    }

    public void getEntities() {
        String[] part;
        ArrayList defaultEntityTypes = Lists.newArrayList((Iterator)class_2378.field_11145.iterator());
        if (!defaultEntityTypes.isEmpty()) {
            for (class_1299 entityLocation : defaultEntityTypes) {
                if (entityLocation == null) continue;
                String entityName = entityLocation.method_5897().method_10863();
                Class<?> entityClass = entityLocation.getClass();
                if (!this.ENTITY_NAMES.contains(entityName)) {
                    this.ENTITY_NAMES.add(entityName);
                }
                if (this.ENTITY_CLASSES.contains(entityClass.getName())) continue;
                this.ENTITY_CLASSES.add(entityClass.getName());
            }
        }
        if (CraftPresence.SERVER.enabled) {
            for (class_640 playerInfo : CraftPresence.SERVER.currentPlayerList) {
                String uuidString = playerInfo.method_2966().getId().toString();
                if (StringUtils.isNullOrEmpty(uuidString) || this.ENTITY_NAMES.contains(uuidString)) continue;
                this.ENTITY_NAMES.add(uuidString);
            }
        }
        for (String entityTargetMessage : CraftPresence.CONFIG.entityTargetMessages) {
            if (StringUtils.isNullOrEmpty(entityTargetMessage) || StringUtils.isNullOrEmpty((part = entityTargetMessage.split(CraftPresence.CONFIG.splitCharacter))[0]) || this.ENTITY_NAMES.contains(part[0])) continue;
            this.ENTITY_NAMES.add(part[0]);
        }
        for (String entityAttackingMessage : CraftPresence.CONFIG.entityAttackingMessages) {
            if (StringUtils.isNullOrEmpty(entityAttackingMessage) || StringUtils.isNullOrEmpty((part = entityAttackingMessage.split(CraftPresence.CONFIG.splitCharacter))[0]) || this.ENTITY_NAMES.contains(part[0])) continue;
            this.ENTITY_NAMES.add(part[0]);
        }
        for (String entityRidingMessage : CraftPresence.CONFIG.entityRidingMessages) {
            if (StringUtils.isNullOrEmpty(entityRidingMessage) || StringUtils.isNullOrEmpty((part = entityRidingMessage.split(CraftPresence.CONFIG.splitCharacter))[0]) || this.ENTITY_NAMES.contains(part[0])) continue;
            this.ENTITY_NAMES.add(part[0]);
        }
        this.verifyEntities();
    }

    private void verifyEntities() {
    }
}

