/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.updater;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.UrlUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedScreen;
import com.gitlab.cdagaming.craftpresence.utils.updater.ModUpdaterUtils;
import java.util.List;
import net.minecraft.class_437;

public class UpdateInfoGui
extends ExtendedScreen {
    private final ModUpdaterUtils modUpdater;
    private ExtendedButtonControl downloadButton;
    private ExtendedButtonControl checkButton;

    public UpdateInfoGui(class_437 parentScreen, ModUpdaterUtils modUpdater) {
        super(parentScreen);
        this.modUpdater = modUpdater;
    }

    @Override
    public void initializeUi() {
        this.checkButton = this.addControl(new ExtendedButtonControl(this.width / 2 - 90, this.height - 30, 180, 20, ModUtils.TRANSLATOR.translate("gui.config.message.button.checkForUpdates", new Object[0]), () -> this.modUpdater.checkForUpdates(() -> {
            if (this.modUpdater.isInvalidVersion) {
                StringUtils.updateField(ModUtils.class, null, new Tuple<String, String, Integer>("VERSION_ID", "v" + this.modUpdater.targetVersion, -17));
                StringUtils.updateField(ModUtils.class, null, new Tuple<String, String, Integer>("VERSION_TYPE", this.modUpdater.currentState.getDisplayName(), -17));
                StringUtils.updateField(ModUtils.class, null, new Tuple<String, String, Integer>("VERSION_LABEL", this.modUpdater.currentState.getDisplayName(), -17));
                StringUtils.updateField(ModUtils.class, null, new Tuple<String, String, Integer>("NAME", CraftPresence.class.getSimpleName(), -17));
                this.modUpdater.currentVersion = this.modUpdater.targetVersion;
                this.modUpdater.isInvalidVersion = false;
            }
        }), new String[0]));
        this.addControl(new ExtendedButtonControl(10, this.height - 30, 95, 20, ModUtils.TRANSLATOR.translate("gui.config.message.button.back", new Object[0]), () -> CraftPresence.GUIS.openScreen(this.parentScreen), new String[0]));
        this.downloadButton = this.addControl(new ExtendedButtonControl(this.width - 105, this.height - 30, 95, 20, ModUtils.TRANSLATOR.translate("gui.config.message.button.download", new Object[0]), () -> {
            try {
                UrlUtils.openUrl(this.modUpdater.downloadUrl);
            }
            catch (Exception ex) {
                ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.web", this.modUpdater.downloadUrl), new Object[0]);
                ex.printStackTrace();
            }
        }, new String[0]));
        super.initializeUi();
    }

    @Override
    public void preRender() {
        this.downloadButton.setControlEnabled(this.modUpdater.currentState == ModUpdaterUtils.UpdateState.OUTDATED || this.modUpdater.currentState == ModUpdaterUtils.UpdateState.BETA_OUTDATED);
        this.checkButton.setControlEnabled(this.modUpdater.currentState != ModUpdaterUtils.UpdateState.PENDING);
        String mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title", new Object[0]);
        String subTitle = ModUtils.TRANSLATOR.translate("gui.config.title.changes", this.modUpdater.currentState.getDisplayName());
        List<String> notice = StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.changelog", this.modUpdater.targetVersion, this.modUpdater.targetChangelogData));
        this.renderString(mainTitle, (float)this.width / 2.0f - (float)StringUtils.getStringWidth(mainTitle) / 2.0f, 10.0f, 0xFFFFFF);
        this.renderString(subTitle, (float)this.width / 2.0f - (float)StringUtils.getStringWidth(subTitle) / 2.0f, 20.0f, 0xFFFFFF);
        CraftPresence.GUIS.drawMultiLineString(notice, 10, 45, this.width, this.height, this.getWrapWidth(), this.getFontRenderer(), false);
    }
}

