/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.gui.controls;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.impl.Pair;
import com.gitlab.cdagaming.craftpresence.utils.ImageUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_358;
import net.minecraft.class_642;

public class ScrollableListControl
extends class_358 {
    public String currentValue;
    public List<String> itemList;
    public RenderType renderType;

    public ScrollableListControl(class_310 mc, int width, int height, int topIn, int bottomIn, int slotHeightIn, List<String> itemList, String currentValue) {
        this(mc, width, height, topIn, bottomIn, slotHeightIn, itemList, currentValue, RenderType.None);
    }

    public ScrollableListControl(class_310 mc, int width, int height, int topIn, int bottomIn, int slotHeightIn, List<String> itemList, String currentValue, RenderType renderType) {
        super(mc, width, height, topIn, bottomIn, slotHeightIn);
        this.itemList = itemList;
        this.currentValue = currentValue;
        this.renderType = renderType;
    }

    protected int getItemCount() {
        return this.itemList.size();
    }

    public boolean mouseClicked(double mouseX, double mouseZ, int mouseButton) {
        int scrollIndex;
        if (this.isMouseInList(mouseX, mouseZ) && (scrollIndex = this.getItemAtPosition(mouseX, mouseZ)) != -1) {
            this.currentValue = this.getSelectedItem(scrollIndex);
        }
        return super.mouseClicked(mouseX, mouseZ, mouseButton);
    }

    public boolean isSelectedItem(int slotIndex) {
        return this.getSelectedItem(slotIndex).equals(this.currentValue);
    }

    protected void renderBackground() {
    }

    protected void renderItem(int slotIndex, int xPos, int yPos, int heightIn, int mouseXIn, int mouseYIn, float partialTicks) {
        int xOffset = xPos;
        String displayName = this.getSelectedItem(slotIndex);
        if (!CraftPresence.CONFIG.stripExtraGuiElements && (this.renderType == RenderType.DiscordAsset || this.renderType == RenderType.ServerData && CraftPresence.SERVER.enabled || this.renderType == RenderType.EntityData && CraftPresence.ENTITIES.enabled || this.renderType == RenderType.ItemData && CraftPresence.TILE_ENTITIES.enabled)) {
            class_2960 texture = new class_2960("");
            if (this.renderType == RenderType.ServerData) {
                class_642 data = CraftPresence.SERVER.getDataFromName(displayName);
                if (data != null) {
                    String assetUrl = "data:image/unknown;base64," + data.method_2991();
                    texture = ImageUtils.getTextureFromUrl(displayName, new Pair<ImageUtils.InputType, Object>(ImageUtils.InputType.ByteStream, assetUrl));
                }
            } else if (this.renderType == RenderType.DiscordAsset) {
                String assetUrl = DiscordAssetUtils.getAssetUrl(CraftPresence.CONFIG.clientId, displayName, true);
                texture = ImageUtils.getTextureFromUrl(displayName, assetUrl);
            } else if (this.renderType == RenderType.EntityData) {
                if (StringUtils.isValidUuid(displayName)) {
                    displayName = displayName.replaceAll("-", "");
                    texture = ImageUtils.getTextureFromUrl(displayName, "https://crafatar.com/avatars/" + displayName);
                }
            } else if (this.renderType == RenderType.ItemData) {
                texture = CraftPresence.TILE_ENTITIES.TILE_ENTITY_RESOURCES.getOrDefault(displayName, texture);
            }
            if (!ImageUtils.isTextureNull(texture)) {
                CraftPresence.GUIS.drawTextureRect(0.0, xOffset, (double)yPos + 4.5, 32.0f, 32.0f, 0.0f, texture);
            }
            xOffset += 35;
        }
        class_327 class_3272 = this.getFontRenderer();
        float f = xOffset;
        float f2 = yPos;
        float f3 = (float)heightIn / 2.0f;
        this.getFontRenderer().getClass();
        class_3272.method_1720(displayName, f, f2 + (f3 - 9.0f / 2.0f), 0xFFFFFF);
    }

    public String getSelectedItem(int slotIndex) {
        try {
            return this.itemList.get(slotIndex);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public class_327 getFontRenderer() {
        return this.minecraft.field_1772 != null ? this.minecraft.field_1772 : GuiUtils.getDefaultFontRenderer();
    }

    public int getFontHeight() {
        this.getFontRenderer().getClass();
        return 9;
    }

    public static enum RenderType {
        DiscordAsset,
        ServerData,
        EntityData,
        ItemData,
        None;

    }
}

