/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.gui.controls;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class ExtendedScreen
extends class_437 {
    public final class_437 parentScreen;
    public final class_437 currentScreen;
    private final List<class_364> extendedControls = Lists.newArrayList();
    private final List<ScrollableListControl> extendedLists = Lists.newArrayList();
    private boolean initialized = false;
    private int lastMouseX = 0;
    private int lastMouseY = 0;

    public ExtendedScreen(class_437 parentScreen) {
        super((class_2561)new class_2585(""));
        this.minecraft = CraftPresence.instance;
        this.currentScreen = this;
        this.parentScreen = parentScreen;
    }

    public void init() {
        this.buttons.clear();
        this.extendedControls.clear();
        this.extendedLists.clear();
        this.minecraft.field_1774.method_1462(true);
        this.initializeUi();
        super.init();
        this.initialized = true;
    }

    public void initializeUi() {
    }

    public void resize(class_310 mcIn, int w, int h) {
        this.initialized = false;
        super.resize(mcIn, w, h);
    }

    protected <T extends class_339> T addButton(T buttonIn) {
        return this.addControl(buttonIn);
    }

    protected <T extends class_364> T addControl(T buttonIn) {
        if (buttonIn instanceof class_4185 && !this.buttons.contains(buttonIn)) {
            this.buttons.add((class_4185)buttonIn);
        }
        if (!this.extendedControls.contains(buttonIn)) {
            this.extendedControls.add(buttonIn);
        }
        return buttonIn;
    }

    protected <T extends ScrollableListControl> T addList(T buttonIn) {
        if (!this.extendedLists.contains(buttonIn)) {
            this.extendedLists.add(buttonIn);
        }
        return buttonIn;
    }

    public void renderCriticalData() {
        CraftPresence.GUIS.drawBackground(this.width, this.height);
    }

    public void preRender() {
    }

    public void postRender() {
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.initialized) {
            this.renderCriticalData();
            this.preRender();
            for (ScrollableListControl listControl : this.extendedLists) {
                listControl.render(mouseX, mouseY, partialTicks);
            }
            for (class_364 extendedControl : this.extendedControls) {
                if (extendedControl instanceof ExtendedButtonControl) {
                    ExtendedButtonControl button = (ExtendedButtonControl)extendedControl;
                    button.render(mouseX, mouseY, partialTicks);
                }
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.render(mouseX, mouseY, partialTicks);
            }
            super.render(mouseX, mouseY, partialTicks);
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            for (class_364 extendedControl : this.extendedControls) {
                ExtendedButtonControl extendedButton;
                if (!(extendedControl instanceof ExtendedButtonControl) || !CraftPresence.GUIS.isMouseOver((double)mouseX, (double)mouseY, extendedButton = (ExtendedButtonControl)extendedControl)) continue;
                extendedButton.onHover();
            }
            this.postRender();
        }
    }

    public boolean keyPressed(int keyCode, int mouseX, int mouseY) {
        if (keyCode == 256) {
            CraftPresence.GUIS.openScreen(this.parentScreen);
        }
        for (class_364 extendedControl : this.extendedControls) {
            if (extendedControl instanceof ExtendedButtonControl) {
                ExtendedButtonControl button = (ExtendedButtonControl)extendedControl;
                button.keyPressed(keyCode, mouseX, mouseY);
            }
            if (!(extendedControl instanceof ExtendedTextControl)) continue;
            ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
            textField.keyPressed(keyCode, mouseX, mouseY);
        }
        return super.keyPressed(keyCode, mouseX, mouseY);
    }

    public boolean charTyped(char typedChar, int keyCode) {
        for (ScrollableListControl listControl : this.extendedLists) {
            listControl.charTyped(typedChar, keyCode);
        }
        for (class_364 extendedControl : this.extendedControls) {
            if (extendedControl instanceof ExtendedButtonControl) {
                ExtendedButtonControl button = (ExtendedButtonControl)extendedControl;
                button.charTyped(typedChar, keyCode);
            }
            if (!(extendedControl instanceof ExtendedTextControl)) continue;
            ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
            textField.charTyped(typedChar, keyCode);
        }
        return super.charTyped(typedChar, keyCode);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        for (ScrollableListControl listControl : this.extendedLists) {
            listControl.mouseClicked(mouseX, mouseY, mouseButton);
        }
        for (class_364 extendedControl : this.extendedControls) {
            if (extendedControl instanceof ExtendedButtonControl) {
                ExtendedButtonControl button = (ExtendedButtonControl)extendedControl;
                button.mouseClicked(mouseX, mouseY, mouseButton);
            }
            if (!(extendedControl instanceof ExtendedTextControl)) continue;
            ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
            textField.mouseClicked(mouseX, mouseY, mouseButton);
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollAmount) {
        for (ScrollableListControl listControl : this.extendedLists) {
            listControl.mouseScrolled(mouseX, mouseY, scrollAmount);
        }
        for (class_364 extendedControl : this.extendedControls) {
            if (extendedControl instanceof ExtendedButtonControl) {
                ExtendedButtonControl button = (ExtendedButtonControl)extendedControl;
                button.mouseScrolled(mouseX, mouseY, scrollAmount);
            }
            if (!(extendedControl instanceof ExtendedTextControl)) continue;
            ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
            textField.mouseScrolled(mouseX, mouseY, scrollAmount);
        }
        return super.mouseScrolled(mouseX, mouseY, scrollAmount);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double scrollX, double scrollY) {
        for (ScrollableListControl listControl : this.extendedLists) {
            listControl.mouseDragged(mouseX, mouseY, mouseButton, scrollX, scrollY);
        }
        for (class_364 extendedControl : this.extendedControls) {
            if (extendedControl instanceof ExtendedButtonControl) {
                ExtendedButtonControl button = (ExtendedButtonControl)extendedControl;
                button.mouseDragged(mouseX, mouseY, mouseButton, scrollX, scrollY);
            }
            if (!(extendedControl instanceof ExtendedTextControl)) continue;
            ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
            textField.mouseDragged(mouseX, mouseY, mouseButton, scrollX, scrollY);
        }
        return super.mouseDragged(mouseX, mouseY, mouseButton, scrollX, scrollY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        for (ScrollableListControl listControl : this.extendedLists) {
            listControl.mouseReleased(mouseX, mouseY, mouseButton);
        }
        for (class_364 extendedControl : this.extendedControls) {
            if (extendedControl instanceof ExtendedButtonControl) {
                ExtendedButtonControl button = (ExtendedButtonControl)extendedControl;
                button.mouseReleased(mouseX, mouseY, mouseButton);
            }
            if (!(extendedControl instanceof ExtendedTextControl)) continue;
            ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
            textField.mouseReleased(mouseX, mouseY, mouseButton);
        }
        return super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    public void tick() {
        for (class_364 extendedControl : this.extendedControls) {
            if (!(extendedControl instanceof ExtendedTextControl)) continue;
            ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
            textField.method_1865();
        }
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public void onClose() {
        this.initialized = false;
        CraftPresence.GUIS.resetIndex();
        this.minecraft.field_1774.method_1462(false);
    }

    public void renderNotice(List<String> notice) {
        this.renderNotice(notice, 2.0f, 3.0f, false, false);
    }

    public void renderNotice(List<String> notice, float widthScale, float heightScale) {
        this.renderNotice(notice, widthScale, heightScale, false, false);
    }

    public void renderNotice(List<String> notice, float widthScale, float heightScale, boolean useXAsActual, boolean useYAsActual) {
        if (notice != null && !notice.isEmpty()) {
            for (int i = 0; i < notice.size(); ++i) {
                String string = notice.get(i);
                this.renderString(string, (useXAsActual ? widthScale : (float)this.width / widthScale) - (float)StringUtils.getStringWidth(string) / widthScale, (useYAsActual ? heightScale : (float)this.height / heightScale) + (float)(i * 10), 0xFFFFFF);
            }
        }
    }

    public void renderString(String text, float xPos, float yPos, int color) {
        this.getFontRenderer().method_1720(text, xPos, yPos, color);
    }

    public int getMouseX() {
        return this.lastMouseX;
    }

    public int getWrapWidth() {
        return -1;
    }

    public int getMouseY() {
        return this.lastMouseY;
    }

    public class_327 getFontRenderer() {
        return this.minecraft.field_1772 != null ? this.minecraft.field_1772 : GuiUtils.getDefaultFontRenderer();
    }

    public int getFontHeight() {
        this.getFontRenderer().getClass();
        return 9;
    }
}

