/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.gui.controls;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.utils.ImageUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import java.io.File;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_4185;

public class ExtendedButtonControl
extends class_4185 {
    private String[] optionalArgs;
    private Runnable onPushEvent = null;
    private Runnable onHoverEvent = null;
    private class_327 currentFontRender = null;

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, String ... optionalArgs) {
        super(x, y, widthIn, heightIn, buttonText, button -> {});
        this.optionalArgs = optionalArgs;
    }

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, String ... optionalArgs) {
        this(buttonId, x, y, widthIn, heightIn, buttonText, optionalArgs);
        this.onPushEvent = onPushEvent;
    }

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, Runnable onHoverEvent, String ... optionalArgs) {
        this(buttonId, x, y, widthIn, heightIn, buttonText, onPushEvent, optionalArgs);
        this.onHoverEvent = onHoverEvent;
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, String ... optionalArgs) {
        super(x, y, widthIn, heightIn, buttonText, button -> {});
        this.optionalArgs = optionalArgs;
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, String ... optionalArgs) {
        this(x, y, widthIn, heightIn, buttonText, optionalArgs);
        this.setOnClick(onPushEvent);
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, Runnable onHoverEvent, String ... optionalArgs) {
        this(x, y, widthIn, heightIn, buttonText, onPushEvent, optionalArgs);
        this.setOnHover(onHoverEvent);
    }

    public ExtendedButtonControl(int id, int xPos, int yPos, String displayString) {
        this(xPos, yPos, 200, 20, displayString, new String[0]);
    }

    public ExtendedButtonControl(int xPos, int yPos, String displayString) {
        this(CraftPresence.GUIS.getNextIndex(), xPos, yPos, displayString);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            this.isHovered = CraftPresence.GUIS.isMouseOver((double)mouseX, (double)mouseY, this);
            int hoverState = this.getYImage(this.isHovered);
            String backgroundCode = CraftPresence.CONFIG.buttonBackgroundColor;
            if (StringUtils.isValidColorCode(backgroundCode)) {
                CraftPresence.GUIS.drawGradientRect(this.getBlitOffset(), this.getControlPosX(), this.getControlPosY(), this.getControlWidth(), this.getControlHeight(), backgroundCode, backgroundCode);
            } else {
                class_2960 texLocation;
                boolean usingExternalTexture = ImageUtils.isExternalImage(backgroundCode);
                if (!usingExternalTexture) {
                    if (backgroundCode.contains(CraftPresence.CONFIG.splitCharacter)) {
                        backgroundCode = backgroundCode.replace(CraftPresence.CONFIG.splitCharacter, ":");
                    }
                    if (backgroundCode.contains(":")) {
                        String[] splitInput = backgroundCode.split(":", 2);
                        texLocation = new class_2960(splitInput[0], splitInput[1]);
                    } else {
                        texLocation = new class_2960(backgroundCode);
                    }
                } else {
                    String formattedConvertedName = backgroundCode.replaceFirst("file://", "");
                    String[] urlBits = formattedConvertedName.trim().split("/");
                    String textureName = urlBits[urlBits.length - 1].trim();
                    texLocation = ImageUtils.getTextureFromUrl(textureName, backgroundCode.toLowerCase().startsWith("file://") ? new File(formattedConvertedName) : formattedConvertedName);
                }
                CraftPresence.GUIS.renderButton(this.getControlPosX(), this.getControlPosY(), this.getControlWidth(), this.getControlHeight(), hoverState, this.getBlitOffset(), texLocation);
            }
            this.renderBg(CraftPresence.instance, mouseX, mouseY);
            int color = !this.active ? 0xA0A0A0 : (this.isHovered ? 0xFFFFA0 : 0xE0E0E0);
            this.drawCenteredString(this.getFontRenderer(), this.getControlMessage(), this.getControlPosX() + this.getControlWidth() / 2, this.getControlPosY() + (this.getControlHeight() - 8) / 2, color);
        }
    }

    public int getControlWidth() {
        return this.width;
    }

    public int getControlHeight() {
        return this.height;
    }

    public int getControlPosX() {
        return this.x;
    }

    public int getControlPosY() {
        return this.y;
    }

    public class_327 getFontRenderer() {
        return this.currentFontRender != null ? this.currentFontRender : GuiUtils.getDefaultFontRenderer();
    }

    public void setCurrentFontRender(class_327 currentFontRender) {
        this.currentFontRender = currentFontRender;
    }

    public int getFontHeight() {
        this.getFontRenderer().getClass();
        return 9;
    }

    public String[] getOptionalArgs() {
        return this.optionalArgs;
    }

    public void setOnClick(Runnable event) {
        this.onPushEvent = event;
    }

    public void onClick() {
        if (this.onPushEvent != null) {
            this.onPushEvent.run();
        }
    }

    public void onClick(double mouseX, double mouseY) {
        this.onClick();
        super.onClick(mouseX, mouseY);
    }

    public void setOnHover(Runnable event) {
        this.onHoverEvent = event;
    }

    public void onHover() {
        if (this.onHoverEvent != null) {
            this.onHoverEvent.run();
        }
    }

    public String getControlMessage() {
        return this.getMessage();
    }

    public void setControlMessage(String newMessage) {
        this.setMessage(newMessage);
    }

    public boolean isControlEnabled() {
        return this.active;
    }

    public void setControlEnabled(boolean isEnabled) {
        this.active = isEnabled;
    }

    public boolean isControlVisible() {
        return this.visible;
    }

    public void setControlVisible(boolean isVisible) {
        this.visible = isVisible;
    }
}

