/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import net.minecraft.class_1297;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModLogger {
    private final String loggerName;
    private final Logger logInstance;

    ModLogger(String loggerName) {
        this.loggerName = loggerName;
        this.logInstance = LogManager.getLogger((String)loggerName);
    }

    public void error(String logMessage, Object ... logArguments) {
        if (CraftPresence.player != null && !CraftPresence.CONFIG.hasChanged && !CraftPresence.closing && CraftPresence.CONFIG.showLoggingInChat) {
            StringUtils.sendMessageToPlayer((class_1297)CraftPresence.player, "\u00a76\u00a7l[\u00a7f\u00a7l" + this.loggerName + "\u00a76]\u00a7r\u00a7c " + logMessage);
        } else {
            this.logInstance.error(logMessage, logArguments);
        }
    }

    public void warn(String logMessage, Object ... logArguments) {
        if (CraftPresence.player != null && !CraftPresence.CONFIG.hasChanged && !CraftPresence.closing && CraftPresence.CONFIG.showLoggingInChat) {
            StringUtils.sendMessageToPlayer((class_1297)CraftPresence.player, "\u00a76\u00a7l[\u00a7f\u00a7l" + this.loggerName + "\u00a76]\u00a7r\u00a7e " + logMessage);
        } else {
            this.logInstance.warn(logMessage, logArguments);
        }
    }

    public void info(String logMessage, Object ... logArguments) {
        if (CraftPresence.player != null && !CraftPresence.CONFIG.hasChanged && !CraftPresence.closing && CraftPresence.CONFIG.showLoggingInChat) {
            StringUtils.sendMessageToPlayer((class_1297)CraftPresence.player, "\u00a76\u00a7l[\u00a7f\u00a7l" + this.loggerName + "\u00a76]\u00a7r " + logMessage);
        } else {
            this.logInstance.info(logMessage, logArguments);
        }
    }

    public void debugInfo(String logMessage, Object ... logArguments) {
        if (ModUtils.IS_DEV) {
            this.info("[Debug] " + logMessage, logArguments);
        }
    }

    public void debugWarn(String logMessage, Object ... logArguments) {
        if (ModUtils.IS_DEV) {
            this.warn("[Debug] " + logMessage, logArguments);
        }
    }

    public void debugError(String logMessage, Object ... logArguments) {
        if (ModUtils.IS_DEV) {
            this.error("[Debug] " + logMessage, logArguments);
        }
    }
}

