/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.grid;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.guntram.mcmod.GBForgetools.ConfigChangedEvent;
import de.guntram.mcmod.GBForgetools.Configuration;
import de.guntram.mcmod.GBForgetools.ConfigurationItem;
import de.guntram.mcmod.GBForgetools.ConfigurationProvider;
import de.guntram.mcmod.GBForgetools.GuiModOptions;
import de.guntram.mcmod.GBForgetools.IConfiguration;
import de.guntram.mcmod.GBForgetools.ModConfigurationHandler;
import de.guntram.mcmod.GBForgetools.Types.ConfigurationSelectList;
import de.guntram.mcmod.GBForgetools.VolatileConfiguration;
import de.guntram.mcmod.grid.ConfigurationHandler;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Grid
implements ModConfigurationHandler {
    static final String MODID = "grid";
    static final String MODNAME = "Grid";
    public static Grid instance;
    private int gridX = 16;
    private int gridZ = 16;
    private int fixY = -1;
    private int offsetX = 0;
    private int offsetZ = 0;
    private int distance = 30;
    private int lightLevel = 8;
    private boolean showGrid = false;
    private boolean isBlocks = true;
    private boolean isCircles = false;
    private boolean isHexes = false;
    private boolean showSpawns = false;
    private Pattern showBiomes = null;
    private Logger LOGGER;
    private float[] blockColor = this.colorToRgb(0x8080FF);
    private float[] lineColor = this.colorToRgb(0xFF8000);
    private float[] circleColor = this.colorToRgb(58496);
    private float[] spawnNightColor = this.colorToRgb(0xFFFF00);
    private float[] spawnDayColor = this.colorToRgb(0xFF0000);
    private float[] biomeColor = this.colorToRgb(0xFF00FF);
    private static final String[] modes;
    VolatileConfiguration runtimeSettings;
    private boolean settingsRequested;
    KeyBinding showHide;
    KeyBinding gridHere;
    KeyBinding gridFixY;
    KeyBinding gridSpawns;
    KeyBinding gridSettings;
    private boolean dump;
    private long lastDumpTime;
    private long thisDumpTime;
    private int[][] biomeCache;
    private int[][] spawnCache;
    int biomeUpdateX;
    int spawnUpdateX;
    private boolean configRequested;
    ConfigurationHandler instConfHandler;
    CommandDispatcher cd;

    public Grid() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::init);
    }

    public void init(FMLCommonSetupEvent event) {
        this.cd = new CommandDispatcher();
        this.registerCommands(this.cd);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.onInitializeClient();
    }

    public void onInitializeClient() {
        instance = this;
        ConfigurationHandler confHandler = this.instConfHandler = ConfigurationHandler.getInstance();
        ConfigurationProvider.register(MODNAME, confHandler);
        confHandler.load(ConfigurationProvider.getSuggestedFile(MODID));
        this.biomeCache = new int[256][];
        this.spawnCache = new int[256][];
        for (int i = 0; i < 256; ++i) {
            this.spawnCache[i] = new int[256];
            this.biomeCache[i] = new int[256];
        }
        this.setKeyBindings();
        this.LOGGER = LogManager.getLogger((String)MODNAME);
    }

    private float[] colorToRgb(int color) {
        float[] result = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color >> 0 & 0xFF) / 255.0f};
        return result;
    }

    @SubscribeEvent
    public void onRender(RenderWorldLastEvent e) {
        BufferBuilder b = Tessellator.func_178181_a().func_178180_c();
        b.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        this.renderOverlay(e.getPartialTicks(), e.getMatrixStack(), (IVertexBuilder)b);
        Tessellator.func_178181_a().func_78381_a();
    }

    public void renderOverlay(float partialTicks, MatrixStack stack, IVertexBuilder consumer) {
        if (!this.showGrid && !this.showSpawns && this.showBiomes == null) {
            return;
        }
        ConfigurationHandler confHandler = ConfigurationHandler.getInstance();
        this.blockColor = this.colorToRgb(confHandler.blockColor);
        this.lineColor = this.colorToRgb(confHandler.lineColor);
        this.circleColor = this.colorToRgb(confHandler.circleColor);
        this.spawnNightColor = this.colorToRgb(confHandler.spawnNightColor);
        this.spawnDayColor = this.colorToRgb(confHandler.spawnDayColor);
        this.biomeColor = this.colorToRgb(confHandler.biomeColor);
        Entity player = Minecraft.func_71410_x().func_175606_aa();
        double cameraX = player.field_70142_S + (player.func_226277_ct_() - player.field_70142_S) * (double)partialTicks;
        double cameraY = player.field_70137_T + (player.func_226278_cu_() - player.field_70137_T) * (double)partialTicks + (double)player.func_213307_e(player.func_213283_Z());
        double cameraZ = player.field_70136_U + (player.func_226281_cx_() - player.field_70136_U) * (double)partialTicks;
        stack.func_227860_a_();
        stack.func_227861_a_(-cameraX, -cameraY, -cameraZ);
        int playerX = (int)Math.floor(player.func_226277_ct_());
        int playerZ = (int)Math.floor(player.func_226281_cx_());
        int playerXShift = Math.floorMod(playerX, this.gridX);
        int playerZShift = Math.floorMod(playerZ, this.gridZ);
        int baseX = playerX - playerXShift;
        int baseZ = playerZ - playerZShift;
        int sizeX = Math.max(this.distance / this.gridX * this.gridX, 2 * this.gridX);
        int sizeZ = Math.max(this.distance / this.gridZ * this.gridZ, 2 * this.gridZ);
        if (playerXShift > sizeX / 2) {
            baseX += this.gridX;
        }
        if (playerZShift > sizeZ / 2) {
            baseZ += this.gridZ;
        }
        this.thisDumpTime = System.currentTimeMillis();
        this.dump = false;
        if (this.thisDumpTime > this.lastDumpTime + 50000L) {
            this.dump = false;
            this.lastDumpTime = this.thisDumpTime;
        }
        if (this.showGrid) {
            float tempy = (float)(this.fixY == -1 ? player.field_70137_T + (player.func_226278_cu_() - player.field_70137_T) * (double)partialTicks : (double)this.fixY);
            float y = player.func_226278_cu_() + (double)player.func_213307_e(player.func_213283_Z()) > (double)tempy ? tempy + 0.05f : tempy - 0.05f;
            stack.func_227860_a_();
            stack.func_227861_a_((double)this.offsetX, 0.0, (double)this.offsetZ);
            int circRadSquare = this.gridX / 2 * (this.gridX / 2);
            if (this.isBlocks) {
                for (int x = baseX - sizeX; x <= baseX + sizeX; x += this.gridX) {
                    for (int z = baseZ - sizeZ; z <= baseZ + sizeZ; z += this.gridZ) {
                        if (this.isHexes) {
                            if (this.gridX >= this.gridZ) {
                                this.drawXTriangleVertex(consumer, stack, x, y, z, true, this.blockColor[0], this.blockColor[1], this.blockColor[2]);
                                this.drawXTriangleVertex(consumer, stack, (float)x - (float)this.gridZ / 4.0f, y, (float)z - (float)this.gridZ / 2.0f, false, this.blockColor[0], this.blockColor[1], this.blockColor[2]);
                                this.drawXTriangleVertex(consumer, stack, (float)x + (float)this.gridX / 2.0f - (float)this.gridZ / 4.0f, y, z, false, this.blockColor[0], this.blockColor[1], this.blockColor[2]);
                                this.drawXTriangleVertex(consumer, stack, (float)x + (float)this.gridX / 2.0f, y, (float)z - (float)this.gridZ / 2.0f, true, this.blockColor[0], this.blockColor[1], this.blockColor[2]);
                            } else {
                                this.drawYTriangleVertex(consumer, stack, x, y, z, true, this.blockColor[0], this.blockColor[1], this.blockColor[2]);
                                this.drawYTriangleVertex(consumer, stack, (float)x - (float)this.gridX / 2.0f, y, (float)z - (float)this.gridX / 4.0f, false, this.blockColor[0], this.blockColor[1], this.blockColor[2]);
                                this.drawYTriangleVertex(consumer, stack, x, y, (float)z + (float)this.gridZ / 2.0f - (float)this.gridX / 4.0f, false, this.blockColor[0], this.blockColor[1], this.blockColor[2]);
                                this.drawYTriangleVertex(consumer, stack, (float)x - (float)this.gridX / 2.0f, y, (float)z + (float)this.gridZ / 2.0f, true, this.blockColor[0], this.blockColor[1], this.blockColor[2]);
                            }
                        } else {
                            this.drawSquare(consumer, stack, x, y, z, this.blockColor[0], this.blockColor[1], this.blockColor[2]);
                        }
                        if (this.isCircles) {
                            int dx = 0;
                            int dz = this.gridX / 2;
                            while (true) {
                                int nextx = dx + 1;
                                int nextz = dz;
                                int toomuch = nextx * nextx + nextz * nextz - circRadSquare;
                                if (nextz > 0 && (nextz - 1) * (nextz - 1) + nextx * nextx > circRadSquare - toomuch) {
                                    --nextz;
                                }
                                if (nextz < nextx) {
                                    this.drawCircleSegment(consumer, stack, x, dx, dz, y, z, dz, dx, this.circleColor[0], this.circleColor[1], this.circleColor[2]);
                                    break;
                                }
                                if (this.dump) {
                                    System.out.println("circle line from " + dx + "/" + dz + " to " + nextx + "/" + nextz + ", (x/2)^2=" + (double)this.gridX / 2.0 * ((double)this.gridX / 2.0) + ", dist is " + (nextx * nextx + nextz * nextz) + ", one higher dist is " + (nextx * nextx + (nextz + 1) * (nextz + 1)) + ", one lower dist is " + (nextx * nextx + (nextz - 1) * (nextz - 1)));
                                }
                                this.drawCircleSegment(consumer, stack, x, dx, nextx, y, z, dz, nextz, this.circleColor[0], this.circleColor[1], this.circleColor[2]);
                                dx = nextx;
                                dz = nextz;
                            }
                        }
                        this.dump = false;
                    }
                }
            } else if (this.isHexes) {
                for (int x = baseX - sizeX; x <= baseX + sizeX; x += this.gridX) {
                    for (int z = baseZ - sizeZ; z <= baseZ + sizeZ; z += this.gridZ) {
                        if (this.gridX >= this.gridZ) {
                            this.drawLine(consumer, stack, (float)x + 0.5f, (float)x + 0.5f - (float)this.gridZ / 4.0f, y, y, (float)z + 0.5f, (float)z + 0.5f - (float)this.gridZ / 2.0f, this.lineColor[0], this.lineColor[1], this.lineColor[2]);
                            this.drawLine(consumer, stack, (float)x + 0.5f, (float)x + 0.5f - (float)this.gridZ / 4.0f, y, y, (float)z + 0.5f, (float)z + 0.5f + (float)this.gridZ / 2.0f, this.lineColor[0], this.lineColor[1], this.lineColor[2]);
                            this.drawLine(consumer, stack, (float)x + 0.5f, (float)x + 0.5f + (float)this.gridX / 2.0f - (float)this.gridZ / 4.0f, y, y, (float)z + 0.5f, (float)z + 0.5f, this.lineColor[0], this.lineColor[1], this.lineColor[2]);
                            this.drawLine(consumer, stack, (float)x + 0.5f + (float)this.gridX / 2.0f - (float)this.gridZ / 4.0f, (float)x + 0.5f + (float)this.gridX / 2.0f, y, y, (float)z + 0.5f, (float)z + 0.5f - (float)this.gridZ / 2.0f, this.lineColor[0], this.lineColor[1], this.lineColor[2]);
                            this.drawLine(consumer, stack, (float)x + 0.5f + (float)this.gridX / 2.0f - (float)this.gridZ / 4.0f, (float)x + 0.5f + (float)this.gridX / 2.0f, y, y, (float)z + 0.5f, (float)z + 0.5f + (float)this.gridZ / 2.0f, this.lineColor[0], this.lineColor[1], this.lineColor[2]);
                            this.drawLine(consumer, stack, (float)x + 0.5f + (float)this.gridX / 2.0f, (float)x + 0.5f + (float)this.gridX - (float)this.gridZ / 4.0f, y, y, (float)z + 0.5f + (float)this.gridZ / 2.0f, (float)z + 0.5f + (float)this.gridZ / 2.0f, this.lineColor[0], this.lineColor[1], this.lineColor[2]);
                            this.drawLine(consumer, stack, (float)x + 0.5f - (float)this.gridZ / 4.0f, (float)x + 0.5f - (float)this.gridX / 2.0f, y, y, (float)z + 0.5f + (float)this.gridZ / 2.0f, (float)z + 0.5f + (float)this.gridZ / 2.0f, this.lineColor[0], this.lineColor[1], this.lineColor[2]);
                            continue;
                        }
                        this.drawLine(consumer, stack, (float)x + 0.5f, (float)x + 0.5f - (float)this.gridX / 2.0f, y, y, (float)z + 0.5f, (float)z + 0.5f - (float)this.gridX / 4.0f, this.lineColor[0], this.lineColor[1], this.lineColor[2]);
                        this.drawLine(consumer, stack, (float)x + 0.5f, (float)x + 0.5f + (float)this.gridX / 2.0f, y, y, (float)z + 0.5f, (float)z + 0.5f - (float)this.gridX / 4.0f, this.lineColor[0], this.lineColor[1], this.lineColor[2]);
                        this.drawLine(consumer, stack, (float)x + 0.5f, (float)x + 0.5f, y, y, (float)z + 0.5f, (float)z + 0.5f + (float)this.gridZ / 2.0f - (float)this.gridX / 4.0f, this.lineColor[0], this.lineColor[1], this.lineColor[2]);
                        this.drawLine(consumer, stack, (float)x + 0.5f, (float)x + 0.5f - (float)this.gridX / 2.0f, y, y, (float)z + 0.5f + (float)this.gridZ / 2.0f - (float)this.gridX / 4.0f, (float)z + 0.5f + (float)this.gridZ / 2.0f, this.lineColor[0], this.lineColor[1], this.lineColor[2]);
                        this.drawLine(consumer, stack, (float)x + 0.5f, (float)x + 0.5f + (float)this.gridX / 2.0f, y, y, (float)z + 0.5f + (float)this.gridZ / 2.0f - (float)this.gridX / 4.0f, (float)z + 0.5f + (float)this.gridZ / 2.0f, this.lineColor[0], this.lineColor[1], this.lineColor[2]);
                        this.drawLine(consumer, stack, (float)x + 0.5f + (float)this.gridX / 2.0f, (float)x + 0.5f + (float)this.gridX / 2.0f, y, y, (float)z + 0.5f + (float)this.gridZ / 2.0f, (float)z + 0.5f + (float)this.gridZ - (float)this.gridX / 4.0f, this.lineColor[0], this.lineColor[1], this.lineColor[2]);
                        this.drawLine(consumer, stack, (float)x + 0.5f + (float)this.gridX / 2.0f, (float)x + 0.5f + (float)this.gridX / 2.0f, y, y, (float)z + 0.5f - (float)this.gridX / 4.0f, (float)z + 0.5f - (float)this.gridZ / 2.0f, this.lineColor[0], this.lineColor[1], this.lineColor[2]);
                    }
                }
            } else if (this.isCircles) {
                for (int x = baseX - sizeX; x <= baseX + sizeX; x += this.gridX) {
                    for (int z = baseZ - sizeZ; z <= baseZ + sizeZ; z += this.gridZ) {
                        float dx = 0.0f;
                        float dz = (float)this.gridX / 2.0f;
                        for (float nextx = 0.1f; nextx < (float)this.gridX; nextx += 0.1f) {
                            float nextz = (float)Math.sqrt((double)(this.gridX * this.gridX) / 4.0 - (double)(nextx * nextx));
                            this.drawCircleSegment(consumer, stack, x, dx, nextx, y, z, dz, nextz, this.circleColor[0], this.circleColor[1], this.circleColor[2]);
                            dx = nextx;
                            dz = nextz;
                            if (nextz < nextx) break;
                        }
                        this.dump = false;
                    }
                }
            } else {
                this.drawLineGrid(consumer, stack, baseX, baseZ, y, sizeX, sizeZ);
            }
            stack.func_227865_b_();
        }
        if (this.showSpawns) {
            this.showSpawns(consumer, stack, player, player.func_233580_cy_().func_177958_n(), player.func_233580_cy_().func_177952_p());
        }
        if (this.showBiomes != null) {
            this.showBiomes(consumer, stack, player, player.func_233580_cy_().func_177958_n(), player.func_233580_cy_().func_177952_p());
        }
        stack.func_227865_b_();
    }

    private void showSpawns(IVertexBuilder consumer, MatrixStack stack, Entity player, int baseX, int baseZ) {
        int miny = (int)player.func_226278_cu_() - 64;
        int maxy = (int)player.func_226278_cu_() + 2;
        if (miny < 0) {
            miny = 0;
        }
        if (maxy > 255) {
            maxy = 255;
        }
        Chunk cachedChunk = null;
        ++this.spawnUpdateX;
        if (this.spawnUpdateX < baseX - this.distance || this.spawnUpdateX > baseX + this.distance) {
            this.spawnUpdateX = baseX - this.distance;
        }
        boolean alwaysUpdate = !ConfigurationHandler.getUseCache();
        for (int x = baseX - this.distance; x <= baseX + this.distance; ++x) {
            for (int z = baseZ - this.distance; z <= baseZ + this.distance; ++z) {
                int display = 0;
                if (alwaysUpdate || x == this.spawnUpdateX) {
                    if (cachedChunk == null || cachedChunk.func_76632_l().field_77276_a != x >> 4 || cachedChunk.func_76632_l().field_77275_b != z >> 4) {
                        cachedChunk = player.field_70170_p.func_212866_a_(x >> 4, z >> 4);
                    }
                    boolean foundAir = false;
                    for (int y = maxy; y >= miny; --y) {
                        BlockPos pos = new BlockPos(x, y, z);
                        ChunkSection section = cachedChunk.func_76587_i()[y >> 4];
                        if (section == null || section.func_76663_a()) continue;
                        BlockState state = section.func_177485_a(x & 0xF, y & 0xF, z & 0xF);
                        if (state.func_215686_e((IBlockReader)player.field_70170_p, pos)) {
                            BlockPos up;
                            if (foundAir && y != maxy && WorldEntitySpawner.func_209382_a((EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (IWorldReader)player.field_70170_p, (BlockPos)(up = pos.func_177984_a()), (EntityType)EntityType.field_203780_j)) {
                                display = player.field_70170_p.func_226658_a_(LightType.BLOCK, up) >= this.lightLevel ? 0 | y : (player.field_70170_p.func_226658_a_(LightType.SKY, up) >= this.lightLevel ? 0x1000 | y : 0x2000 | y);
                            }
                            if (!foundAir) continue;
                            break;
                        }
                        foundAir = true;
                    }
                    this.spawnCache[x & 0xFF][z & 0xFF] = display;
                } else {
                    display = this.spawnCache[x & 0xFF][z & 0xFF];
                }
                if ((display & 0xF000) == 4096) {
                    this.drawCross(consumer, stack, x, (float)(display & 0xFFF) + 1.05f, z, this.spawnNightColor[0], this.spawnNightColor[1], this.spawnNightColor[2], false);
                    continue;
                }
                if ((display & 0xF000) != 8192) continue;
                this.drawCross(consumer, stack, x, (float)(display & 0xFFF) + 1.05f, z, this.spawnDayColor[0], this.spawnDayColor[1], this.spawnDayColor[2], true);
            }
        }
    }

    private void showBiomes(IVertexBuilder consumer, MatrixStack stack, Entity player, int baseX, int baseZ) {
        int miny = (int)player.func_226278_cu_() - 16;
        int maxy = (int)player.func_226278_cu_();
        if (miny < 0) {
            miny = 0;
        }
        if (maxy > 255) {
            maxy = 255;
        }
        MutableRegistry registry = player.field_70170_p.func_241828_r().func_243612_b(Registry.field_239720_u_);
        ++this.biomeUpdateX;
        if (this.biomeUpdateX < baseX - this.distance || this.biomeUpdateX > baseX + this.distance) {
            this.biomeUpdateX = baseX - this.distance;
        }
        boolean alwaysUpdate = !ConfigurationHandler.getUseCache();
        for (int x = baseX - this.distance; x <= baseX + this.distance; ++x) {
            for (int z = baseZ - this.distance; z <= baseZ + this.distance; ++z) {
                int display = 0;
                if (alwaysUpdate || x == this.biomeUpdateX) {
                    boolean match = this.showBiomes.matcher(registry.func_177774_c((Object)player.field_70170_p.func_226691_t_(new BlockPos(x, 64, z))).func_110623_a()).find();
                    if (match) {
                        int y;
                        for (y = (int)player.func_226278_cu_(); y >= miny && Grid.isAir(player.field_70170_p.func_180495_p(new BlockPos(x, y, z)).func_177230_c()); --y) {
                        }
                        display = 4096 + y;
                    } else {
                        display = 0;
                    }
                    this.biomeCache[x & 0xFF][z & 0xFF] = display;
                } else {
                    display = this.biomeCache[x & 0xFF][z & 0xFF];
                }
                if ((display & 0x1000) == 0) continue;
                int y = this.fixY == -1 ? display & 0xFFF : this.fixY - 1;
                this.drawDiamond(consumer, stack, x, y + 1, z, this.biomeColor[0], this.biomeColor[1], this.biomeColor[2]);
            }
        }
    }

    private static boolean isAir(Block block) {
        return block == Blocks.field_150350_a || block == Blocks.field_201941_jj || block == Blocks.field_201940_ji;
    }

    private void drawLineGrid(IVertexBuilder consumer, MatrixStack stack, int baseX, int baseZ, float y, int sizeX, int sizeZ) {
        for (int x = baseX - sizeX; x <= baseX + sizeX; x += this.gridX) {
            this.drawLine(consumer, stack, x, x, y, y, baseZ - this.distance, baseZ + this.distance, this.lineColor[0], this.lineColor[1], this.lineColor[2]);
        }
        for (int z = baseZ - sizeZ; z <= baseZ + sizeZ; z += this.gridZ) {
            this.drawLine(consumer, stack, baseX - this.distance, baseX + this.distance, y, y, z, z, this.lineColor[0], this.lineColor[1], this.lineColor[2]);
        }
    }

    private void drawSquare(IVertexBuilder consumer, MatrixStack stack, float x, float y, float z, float r, float g, float b) {
        this.drawLine(consumer, stack, x + 0.3f, x + 0.7f, y, y, z + 0.3f, z + 0.3f, r, g, b);
        this.drawLine(consumer, stack, x + 0.7f, x + 0.7f, y, y, z + 0.3f, z + 0.7f, r, g, b);
        this.drawLine(consumer, stack, x + 0.7f, x + 0.3f, y, y, z + 0.7f, z + 0.7f, r, g, b);
        this.drawLine(consumer, stack, x + 0.3f, x + 0.3f, y, y, z + 0.7f, z + 0.3f, r, g, b);
    }

    private void drawXTriangleVertex(IVertexBuilder consumer, MatrixStack stack, float x, float y, float z, boolean inverted, float r, float g, float b) {
        float xMult = inverted ? 1 : -1;
        this.drawLine(consumer, stack, x + 0.5f, x + 0.5f + 0.5f * xMult, y, y, z + 0.5f, z + 0.5f, r, g, b);
        this.drawLine(consumer, stack, x + 0.5f, x + 0.5f - 0.25f * xMult, y, y, z + 0.5f, z + 1.0f, r, g, b);
        this.drawLine(consumer, stack, x + 0.5f, x + 0.5f - 0.25f * xMult, y, y, z + 0.5f, z + 0.0f, r, g, b);
    }

    private void drawYTriangleVertex(IVertexBuilder consumer, MatrixStack stack, float x, float y, float z, boolean inverted, float r, float g, float b) {
        float xMult = inverted ? 1 : -1;
        this.drawLine(consumer, stack, x + 0.5f, x + 0.5f, y, y, z + 0.5f, z + 0.5f + 0.5f * xMult, r, g, b);
        this.drawLine(consumer, stack, x + 0.5f, x + 1.0f, y, y, z + 0.5f, z + 0.5f - 0.25f * xMult, r, g, b);
        this.drawLine(consumer, stack, x + 0.5f, x + 0.0f, y, y, z + 0.5f, z + 0.5f - 0.25f * xMult, r, g, b);
    }

    private void drawCircleSegment(IVertexBuilder consumer, MatrixStack stack, float xc, float x1, float x2, float y, float zc, float z1, float z2, float red, float green, float blue) {
        this.drawLine(consumer, stack, xc + x1 + 0.5f, xc + x2 + 0.5f, y, y, zc + z1 + 0.5f, zc + z2 + 0.5f, red, green, blue);
        this.drawLine(consumer, stack, xc - x1 + 0.5f, xc - x2 + 0.5f, y, y, zc + z1 + 0.5f, zc + z2 + 0.5f, red, green, blue);
        this.drawLine(consumer, stack, xc + x1 + 0.5f, xc + x2 + 0.5f, y, y, zc - z1 + 0.5f, zc - z2 + 0.5f, red, green, blue);
        this.drawLine(consumer, stack, xc - x1 + 0.5f, xc - x2 + 0.5f, y, y, zc - z1 + 0.5f, zc - z2 + 0.5f, red, green, blue);
        this.drawLine(consumer, stack, xc + z1 + 0.5f, xc + z2 + 0.5f, y, y, zc + x1 + 0.5f, zc + x2 + 0.5f, red, green, blue);
        this.drawLine(consumer, stack, xc - z1 + 0.5f, xc - z2 + 0.5f, y, y, zc + x1 + 0.5f, zc + x2 + 0.5f, red, green, blue);
        this.drawLine(consumer, stack, xc + z1 + 0.5f, xc + z2 + 0.5f, y, y, zc - x1 + 0.5f, zc - x2 + 0.5f, red, green, blue);
        this.drawLine(consumer, stack, xc - z1 + 0.5f, xc - z2 + 0.5f, y, y, zc - x1 + 0.5f, zc - x2 + 0.5f, red, green, blue);
    }

    private void drawLine(IVertexBuilder consumer, MatrixStack stack, float x1, float x2, float y1, float y2, float z1, float z2, float red, float green, float blue) {
        if (this.dump) {
            System.out.println("line from " + x1 + "," + y1 + "," + z1 + " to " + x2 + "," + y2 + "," + z2);
        }
        Matrix4f model = stack.func_227866_c_().func_227870_a_();
        consumer.func_227888_a_(model, x1, y1, z1).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
        consumer.func_227888_a_(model, x2, y2, z2).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
    }

    private void drawCross(IVertexBuilder consumer, MatrixStack stack, float x, float y, float z, float red, float green, float blue, boolean twoLegs) {
        this.drawLine(consumer, stack, x + 0.3f, x + 0.7f, y, y, z + 0.3f, z + 0.7f, red, green, blue);
        if (twoLegs) {
            this.drawLine(consumer, stack, x + 0.3f, x + 0.7f, y, y, z + 0.7f, z + 0.3f, red, green, blue);
        }
    }

    private void drawDiamond(IVertexBuilder consumer, MatrixStack stack, int x, int y, int z, float red, float green, float blue) {
        Matrix4f model = stack.func_227866_c_().func_227870_a_();
        float x1 = (float)x + 0.3f;
        float x2 = (float)x + 0.5f;
        float x3 = (float)x + 0.7f;
        float z1 = (float)z + 0.3f;
        float z2 = (float)z + 0.5f;
        float z3 = (float)z + 0.7f;
        float y1 = (float)y + 0.05f;
        consumer.func_227888_a_(model, x1, y1, z2).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
        consumer.func_227888_a_(model, x2, y1, z1).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
        consumer.func_227888_a_(model, x2, y1, z1).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
        consumer.func_227888_a_(model, x3, y1, z2).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
        consumer.func_227888_a_(model, x3, y1, z2).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
        consumer.func_227888_a_(model, x2, y1, z3).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
        consumer.func_227888_a_(model, x2, y1, z3).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
        consumer.func_227888_a_(model, x1, y1, z2).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
    }

    private void cmdShow(ClientPlayerEntity sender) {
        this.showGrid = true;
        sender.func_146105_b((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"msg.gridshown", (Object[])null)), false);
    }

    private void cmdHide(ClientPlayerEntity sender) {
        this.showGrid = false;
        sender.func_146105_b((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"msg.gridhidden", (Object[])null)), false);
    }

    private void cmdSpawns(ClientPlayerEntity sender, String newLevel) {
        int level = 8;
        try {
            level = Integer.parseInt(newLevel);
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            // empty catch block
        }
        if (level <= 0 || level > 15) {
            level = 8;
        }
        this.lightLevel = level;
        if (this.showSpawns && newLevel == null) {
            sender.func_146105_b((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"msg.spawnshidden", (Object[])new Object[0])), false);
            this.showSpawns = false;
        } else {
            sender.func_146105_b((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"msg.spawnsshown", (Object[])new Object[]{level})), false);
            this.showSpawns = true;
        }
    }

    private void cmdLines(ClientPlayerEntity sender) {
        this.showGrid = true;
        this.isBlocks = false;
        sender.func_146105_b((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"msg.gridlines", (Object[])null)), false);
    }

    private void cmdBlocks(ClientPlayerEntity sender) {
        this.showGrid = true;
        this.isBlocks = true;
        sender.func_146105_b((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"msg.gridblocks", (Object[])null)), false);
    }

    private void cmdCircles(ClientPlayerEntity sender) {
        if (this.isCircles) {
            this.isCircles = false;
            sender.func_146105_b((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"msg.gridnomorecircles", (Object[])null)), false);
        } else {
            this.isCircles = true;
            this.isHexes = false;
            this.showGrid = true;
            sender.func_146105_b((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"msg.gridcircles", (Object[])null)), false);
        }
    }

    private void cmdHere(ClientPlayerEntity sender) {
        int playerX = (int)Math.floor(sender.func_226277_ct_());
        int playerZ = (int)Math.floor(sender.func_226281_cx_());
        int playerXShift = Math.floorMod(playerX, this.gridX);
        int playerZShift = Math.floorMod(playerZ, this.gridZ);
        this.offsetX = playerXShift;
        this.offsetZ = playerZShift;
        this.showGrid = true;
        sender.func_146105_b((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"msg.gridaligned", (Object[])null)), false);
    }

    private void cmdHex(ClientPlayerEntity sender) {
        if (this.isHexes) {
            this.isHexes = false;
        } else {
            this.isHexes = true;
            this.isCircles = false;
            this.showGrid = true;
        }
    }

    private void cmdFixy(ClientPlayerEntity sender) {
        if (this.fixY == -1) {
            this.cmdFixy(sender, (int)Math.floor(sender.func_226278_cu_()));
        } else {
            this.fixY = -1;
            sender.func_146105_b((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"msg.gridheightfloat", (Object[])new Object[0])), false);
        }
    }

    private void cmdFixy(ClientPlayerEntity sender, int level) {
        this.fixY = level;
        sender.func_146105_b((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"msg.gridheightfixed", (Object[])new Object[]{this.fixY})), false);
    }

    private void cmdChunks(ClientPlayerEntity sender) {
        this.offsetZ = 0;
        this.offsetX = 0;
        this.gridZ = 16;
        this.gridX = 16;
        this.showGrid = true;
        sender.func_146105_b((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"msg.gridchunks", (Object[])new Object[0])), false);
    }

    private void cmdDistance(ClientPlayerEntity sender, int distance) {
        this.distance = distance;
        sender.func_146105_b((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"msg.griddistance", (Object[])new Object[]{distance})), false);
    }

    private void cmdX(ClientPlayerEntity sender, int coord) {
        this.cmdXZ(sender, coord, this.gridZ);
    }

    private void cmdZ(ClientPlayerEntity sender, int coord) {
        this.cmdXZ(sender, this.gridX, coord);
    }

    private void cmdXZ(ClientPlayerEntity sender, int newX, int newZ) {
        if (newX > 0 && newZ > 0) {
            this.gridX = newX;
            this.gridZ = newZ;
            this.showGrid = true;
            sender.func_146105_b((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"msg.gridpattern", (Object[])new Object[]{this.gridX, this.gridZ})), false);
        } else {
            sender.func_146105_b((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"msg.gridcoordspositive", (Object[])new Object[0])), false);
        }
    }

    private void cmdBiome(ClientPlayerEntity sender, String biome) {
        if (biome == null || biome.isEmpty()) {
            this.showBiomes = null;
        } else {
            try {
                this.showBiomes = Pattern.compile(biome, 2);
                sender.func_146105_b((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"msg.biomesearching", (Object[])new Object[]{biome})), false);
            }
            catch (PatternSyntaxException ex) {
                this.showBiomes = null;
                sender.func_146105_b((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"msg.biomepatternbad", (Object[])new Object[]{biome})), false);
            }
        }
    }

    private void cmdSettings() {
        this.runtimeSettings = new VolatileConfiguration();
        this.runtimeSettings.addItem(new ConfigurationItem("grid.settings.x", "", this.gridX, this.gridX, 0, 64, val -> {
            this.gridX = (Integer)val;
        }));
        this.runtimeSettings.addItem(new ConfigurationItem("grid.settings.z", "", this.gridZ, this.gridZ, 0, 64, val -> {
            this.gridZ = (Integer)val;
        }));
        this.runtimeSettings.addItem(new ConfigurationItem("grid.settings.y", "", this.fixY, this.fixY, -2, 255, val -> {
            this.fixY = (Integer)val;
        }));
        this.runtimeSettings.addItem(new ConfigurationItem("grid.settings.distance", "", this.distance, 30, 16, 255, val -> {
            this.distance = (Integer)val;
        }));
        this.runtimeSettings.addItem(new ConfigurationItem("grid.settings.lightlevel", "", this.lightLevel, 8, 1, 15, val -> {
            this.lightLevel = (Integer)val;
        }));
        this.runtimeSettings.addItem(new ConfigurationItem("grid.settings.showgrid", "", this.showGrid, false, null, null, val -> {
            this.showGrid = (Boolean)val;
        }));
        this.runtimeSettings.addItem(new ConfigurationItem("grid.settings.isblocks", "", this.isBlocks, true, null, null, val -> {
            this.isBlocks = (Boolean)val;
        }));
        this.runtimeSettings.addItem(new ConfigurationSelectList("grid.settings.displaymode", "", modes, (Object)(0 + (this.isCircles ? 1 : 0) + (this.isHexes ? 2 : 0)), (Object)0, val -> {
            this.isCircles = (Integer)val == 1;
            this.isHexes = (Integer)val == 2;
        }));
        this.runtimeSettings.addItem(new ConfigurationItem("grid.settings.showspawn", "", this.showSpawns, false, null, null, val -> {
            this.showSpawns = (Boolean)val;
        }));
        this.runtimeSettings.addItem(new ConfigurationItem("grid.settings.showbiomes", "", this.showBiomes != null ? this.showBiomes.pattern() : "", "", null, null, val -> instance.cmdBiome(Minecraft.func_71410_x().field_71439_g, (String)val)));
        GuiModOptions screen = new GuiModOptions(null, "Grid Settings", this){

            public void func_238651_a_(MatrixStack matrices, int vOffset) {
                if (this.field_230706_i_.field_71441_e == null) {
                    super.func_238651_a_(matrices, vOffset);
                }
            }
        };
        Minecraft.func_71410_x().func_147108_a((Screen)screen);
    }

    public void registerCommands(CommandDispatcher cd) {
        cd.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)MODID).then(LiteralArgumentBuilder.literal((String)"show").executes(c -> {
            instance.cmdShow(Minecraft.func_71410_x().field_71439_g);
            return 1;
        }))).then(LiteralArgumentBuilder.literal((String)"hide").executes(c -> {
            instance.cmdHide(Minecraft.func_71410_x().field_71439_g);
            return 1;
        }))).then(LiteralArgumentBuilder.literal((String)"lines").executes(c -> {
            instance.cmdLines(Minecraft.func_71410_x().field_71439_g);
            return 1;
        }))).then(LiteralArgumentBuilder.literal((String)"blocks").executes(c -> {
            instance.cmdBlocks(Minecraft.func_71410_x().field_71439_g);
            return 1;
        }))).then(LiteralArgumentBuilder.literal((String)"circles").executes(c -> {
            instance.cmdCircles(Minecraft.func_71410_x().field_71439_g);
            return 1;
        }))).then(LiteralArgumentBuilder.literal((String)"here").executes(c -> {
            instance.cmdHere(Minecraft.func_71410_x().field_71439_g);
            return 1;
        }))).then(LiteralArgumentBuilder.literal((String)"hex").executes(c -> {
            instance.cmdHex(Minecraft.func_71410_x().field_71439_g);
            return 1;
        }))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"fixy").then(RequiredArgumentBuilder.argument((String)"y", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            instance.cmdFixy(Minecraft.func_71410_x().field_71439_g, IntegerArgumentType.getInteger((CommandContext)c, (String)"y"));
            return 1;
        }))).executes(c -> {
            instance.cmdFixy(Minecraft.func_71410_x().field_71439_g);
            return 1;
        }))).then(LiteralArgumentBuilder.literal((String)"chunks").executes(c -> {
            instance.cmdChunks(Minecraft.func_71410_x().field_71439_g);
            return 1;
        }))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"spawns").then(RequiredArgumentBuilder.argument((String)"lightlevel", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            instance.cmdSpawns(Minecraft.func_71410_x().field_71439_g, "" + IntegerArgumentType.getInteger((CommandContext)c, (String)"lightlevel"));
            return 1;
        }))).executes(c -> {
            instance.cmdSpawns(Minecraft.func_71410_x().field_71439_g, null);
            return 1;
        }))).then(LiteralArgumentBuilder.literal((String)"distance").then(RequiredArgumentBuilder.argument((String)"distance", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            instance.cmdDistance(Minecraft.func_71410_x().field_71439_g, IntegerArgumentType.getInteger((CommandContext)c, (String)"distance"));
            return 1;
        })))).then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(RequiredArgumentBuilder.argument((String)"z", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            instance.cmdXZ(Minecraft.func_71410_x().field_71439_g, IntegerArgumentType.getInteger((CommandContext)c, (String)"x"), IntegerArgumentType.getInteger((CommandContext)c, (String)"z"));
            return 1;
        }))).executes(c -> {
            instance.cmdXZ(Minecraft.func_71410_x().field_71439_g, IntegerArgumentType.getInteger((CommandContext)c, (String)"x"), IntegerArgumentType.getInteger((CommandContext)c, (String)"x"));
            return 1;
        }))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"biome").then(RequiredArgumentBuilder.argument((String)"pattern", (ArgumentType)StringArgumentType.string()).executes(c -> {
            instance.cmdBiome(Minecraft.func_71410_x().field_71439_g, "" + StringArgumentType.getString((CommandContext)c, (String)"pattern"));
            return 1;
        }))).executes(c -> {
            instance.cmdBiome(Minecraft.func_71410_x().field_71439_g, null);
            return 1;
        }))).then(LiteralArgumentBuilder.literal((String)"settings").executes(c -> {
            Grid.instance.settingsRequested = true;
            return 1;
        }))).then(LiteralArgumentBuilder.literal((String)"config").executes(c -> {
            Grid.instance.configRequested = true;
            return 1;
        })));
    }

    @SubscribeEvent
    public void chatSent(ClientChatEvent e) {
        if (e.getOriginalMessage().startsWith("/grid")) {
            try {
                this.cd.execute(e.getOriginalMessage().substring(1), (Object)e);
            }
            catch (CommandSyntaxException ex) {
                Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new StringTextComponent(ex.getMessage()), false);
            }
            e.setCanceled(true);
        }
    }

    public void setKeyBindings() {
        String category = "key.categories.grid";
        this.showHide = new KeyBinding("key.showhide", 66, "key.categories.grid");
        ClientRegistry.registerKeyBinding((KeyBinding)this.showHide);
        this.gridHere = new KeyBinding("key.gridhere", 67, "key.categories.grid");
        ClientRegistry.registerKeyBinding((KeyBinding)this.gridHere);
        this.gridFixY = new KeyBinding("key.gridfixy", 89, "key.categories.grid");
        ClientRegistry.registerKeyBinding((KeyBinding)this.gridFixY);
        this.gridSpawns = new KeyBinding("key.gridspawns", 76, "key.categories.grid");
        ClientRegistry.registerKeyBinding((KeyBinding)this.gridSpawns);
        this.gridSettings = new KeyBinding("key.grid.settings", 71, "key.categories.grid");
        ClientRegistry.registerKeyBinding((KeyBinding)this.gridSettings);
    }

    @SubscribeEvent
    public void keyPressed(InputEvent.KeyInputEvent e) {
        this.processKeyBinds();
    }

    public void processKeyBinds() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (this.showHide.func_151468_f()) {
            boolean bl = this.showGrid = !this.showGrid;
        }
        if (this.gridFixY.func_151468_f()) {
            this.cmdFixy(player);
        }
        if (this.gridHere.func_151468_f()) {
            this.cmdHere(player);
        }
        if (this.gridSpawns.func_151468_f()) {
            this.cmdSpawns(player, null);
        }
        if (this.settingsRequested || this.gridSettings.func_151468_f()) {
            this.settingsRequested = false;
            this.cmdSettings();
        }
        if (this.configRequested) {
            this.configRequested = false;
            Minecraft.func_71410_x().func_147108_a((Screen)new GuiModOptions(null, MODNAME, Grid.instance.instConfHandler));
        }
    }

    @Override
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent occe) {
    }

    @Override
    public IConfiguration getIConfig() {
        return this.runtimeSettings;
    }

    @Override
    public Configuration getConfig() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        modes = new String[]{"grid.displaymode.rectangle", "grid.displaymode.circle", "grid.displaymode.hex"};
    }
}

