/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.lightoverlay.forge;

import java.util.Optional;
import me.shedaniel.clothconfig2.forge.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.forge.api.ConfigBuilder;
import me.shedaniel.clothconfig2.forge.api.ConfigCategory;
import me.shedaniel.clothconfig2.forge.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.forge.gui.entries.IntegerSliderEntry;
import me.shedaniel.lightoverlay.common.forge.LightOverlayCore;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;

public class LightOverlayCloth {
    public static void register() {
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (client, parent) -> {
            ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((ITextComponent)new TranslationTextComponent("key.lightoverlay.category"));
            ConfigEntryBuilder eb = builder.entryBuilder();
            ConfigCategory general = builder.getOrCreateCategory((ITextComponent)new TranslationTextComponent("config.lightoverlay.general"));
            general.addEntry((AbstractConfigListEntry)eb.startTextDescription(ITextComponent.func_244388_a((String)("\u00a77" + I18n.func_135052_a((String)"description.lightoverlay.caching", (Object[])new Object[0])))).build());
            general.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((ITextComponent)new TranslationTextComponent("config.lightoverlay.caching"), LightOverlayCore.caching).setDefaultValue(false).setSaveConsumer(bool -> {
                LightOverlayCore.caching = bool;
            }).build());
            general.addEntry((AbstractConfigListEntry)eb.startIntSlider((ITextComponent)new TranslationTextComponent("config.lightoverlay.reach"), LightOverlayCore.reach, 1, 64).setDefaultValue(12).setTextGetter(integer -> ITextComponent.func_244388_a((String)("Reach: " + integer + " Blocks"))).setSaveConsumer(integer -> {
                LightOverlayCore.reach = integer;
            }).build());
            IntegerSliderEntry crossLevel = eb.startIntSlider((ITextComponent)new TranslationTextComponent("config.lightoverlay.crossLevel"), LightOverlayCore.crossLevel, 0, 15).setDefaultValue(7).setTextGetter(integer -> ITextComponent.func_244388_a((String)("Cross Level: " + integer))).setSaveConsumer(integer -> {
                LightOverlayCore.crossLevel = integer;
            }).build();
            general.addEntry((AbstractConfigListEntry)crossLevel);
            general.addEntry((AbstractConfigListEntry)eb.startIntSlider((ITextComponent)new TranslationTextComponent("config.lightoverlay.secondaryLevel"), LightOverlayCore.secondaryLevel, -1, 15).setErrorSupplier(integer -> {
                if (integer >= 0 && integer >= crossLevel.getValue()) {
                    return Optional.of(ITextComponent.func_244388_a((String)"Secondary Level cannot be higher than Cross Level!"));
                }
                return Optional.empty();
            }).setDefaultValue(-1).setTextGetter(integer -> ITextComponent.func_244388_a((String)(integer < 0 ? "Off" : "Level: " + integer))).setSaveConsumer(integer -> {
                LightOverlayCore.secondaryLevel = integer;
            }).build());
            general.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((ITextComponent)new TranslationTextComponent("config.lightoverlay.showNumber"), LightOverlayCore.showNumber).setDefaultValue(false).setSaveConsumer(bool -> {
                LightOverlayCore.showNumber = bool;
            }).build());
            general.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((ITextComponent)new TranslationTextComponent("config.lightoverlay.smoothLines"), LightOverlayCore.smoothLines).setDefaultValue(true).setSaveConsumer(bool -> {
                LightOverlayCore.smoothLines = bool;
            }).build());
            general.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((ITextComponent)new TranslationTextComponent("config.lightoverlay.underwater"), LightOverlayCore.underwater).setDefaultValue(false).setSaveConsumer(bool -> {
                LightOverlayCore.underwater = bool;
            }).build());
            general.addEntry((AbstractConfigListEntry)eb.startIntSlider((ITextComponent)new TranslationTextComponent("config.lightoverlay.lineWidth"), MathHelper.func_76141_d((float)(LightOverlayCore.lineWidth * 100.0f)), 100, 700).setDefaultValue(100).setTextGetter(integer -> ITextComponent.func_244388_a((String)("Light Width: " + LightOverlayCore.FORMAT.format((double)integer.intValue() / 100.0)))).setSaveConsumer(integer -> {
                LightOverlayCore.lineWidth = (float)integer.intValue() / 100.0f;
            }).build());
            general.addEntry((AbstractConfigListEntry)eb.startColorField((ITextComponent)new TranslationTextComponent("config.lightoverlay.yellowColor"), LightOverlayCore.yellowColor).setDefaultValue(0xFFFF00).setSaveConsumer(color -> {
                LightOverlayCore.yellowColor = color;
            }).build());
            general.addEntry((AbstractConfigListEntry)eb.startColorField((ITextComponent)new TranslationTextComponent("config.lightoverlay.redColor"), LightOverlayCore.redColor).setDefaultValue(0xFF0000).setSaveConsumer(color -> {
                LightOverlayCore.redColor = color;
            }).build());
            general.addEntry((AbstractConfigListEntry)eb.startColorField((ITextComponent)new TranslationTextComponent("config.lightoverlay.secondaryColor"), LightOverlayCore.secondaryColor).setDefaultValue(255).setSaveConsumer(color -> {
                LightOverlayCore.secondaryColor = color;
            }).build());
            return builder.setSavingRunnable(() -> {
                try {
                    LightOverlayCore.saveConfig(LightOverlayCore.configFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                LightOverlayCore.loadConfig(LightOverlayCore.configFile);
            }).build();
        });
    }
}

