/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.lightoverlay.forge;

import java.nio.file.Path;
import me.shedaniel.lightoverlay.common.forge.AbstractPlatform;
import me.shedaniel.lightoverlay.common.forge.LightOverlayCore;
import me.shedaniel.lightoverlay.forge.FrustumHelper;
import me.shedaniel.lightoverlay.forge.LightOverlayCloth;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.network.play.server.SChunkDataPacket;
import net.minecraft.network.play.server.SMultiBlockChangePacket;
import net.minecraft.network.play.server.SUpdateLightPacket;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.loading.FMLPaths;

public class LightOverlayClient {
    private static Runnable debugRenderer = () -> {};

    public static void register() {
        LightOverlayCore.register(new AbstractPlatform(){

            @Override
            public Path getConfigDir() {
                return FMLPaths.CONFIGDIR.get();
            }

            @Override
            public void registerClientTick(Runnable runnable) {
                MinecraftForge.EVENT_BUS.addListener(event -> runnable.run());
            }

            @Override
            public void registerDebugRenderer(Runnable runnable) {
                debugRenderer = runnable;
            }

            @Override
            public KeyBinding registerKeyBinding(KeyBinding keyBinding) {
                ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
                return keyBinding;
            }

            @Override
            public boolean isFrustumVisible(ClippingHelper clippingHelper, double v, double v1, double v2, double v3, double v4, double v5) {
                return FrustumHelper.isVisible(clippingHelper, v, v1, v2, v3, v4, v5);
            }
        });
        try {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> LightOverlayCloth.register());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void renderWorldLast() {
        debugRenderer.run();
    }

    public static void processPacket(IPacket<?> packet) {
        if (packet instanceof SChangeBlockPacket) {
            LightOverlayCore.queueChunkAndNear(new ChunkPos(((SChangeBlockPacket)packet).func_179827_b()));
        } else if (packet instanceof SChunkDataPacket) {
            LightOverlayCore.queueChunkAndNear(new ChunkPos(((SChunkDataPacket)packet).func_149273_e(), ((SChunkDataPacket)packet).func_149271_f()));
        } else if (packet instanceof SMultiBlockChangePacket) {
            LightOverlayCore.queueChunkAndNear(new ChunkPos(((SMultiBlockChangePacket)packet).field_244305_a.func_177958_n(), ((SMultiBlockChangePacket)packet).field_244305_a.func_177952_p()));
        } else if (packet instanceof SUpdateLightPacket) {
            LightOverlayCore.queueChunkAndNear(new ChunkPos(((SUpdateLightPacket)packet).func_218716_b(), ((SUpdateLightPacket)packet).func_218714_c()));
        }
    }
}

