/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.lightoverlay.common.fabric;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import me.shedaniel.lightoverlay.common.fabric.AbstractPlatform;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_3528;
import net.minecraft.class_3532;
import net.minecraft.class_3562;
import net.minecraft.class_3675;
import net.minecraft.class_3726;
import net.minecraft.class_4184;
import net.minecraft.class_4493;
import net.minecraft.class_4590;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.lwjgl.opengl.GL11;

public class LightOverlayCore {
    public static final DecimalFormat FORMAT = new DecimalFormat("#.#");
    private static final String KEYBIND_CATEGORY = "key.lightoverlay.category";
    private static final class_2960 ENABLE_OVERLAY_KEYBIND = new class_2960("lightoverlay", "enable_overlay");
    public static int reach = 12;
    public static int crossLevel = 7;
    public static int secondaryLevel = -1;
    public static int lowerCrossLevel = -1;
    public static int higherCrossLevel = -1;
    public static boolean caching = false;
    public static boolean showNumber = false;
    public static boolean smoothLines = true;
    public static boolean underwater = false;
    public static float lineWidth = 1.0f;
    public static int yellowColor = 0xFFFF00;
    public static int redColor = 0xFF0000;
    public static int secondaryColor = 255;
    public static File configFile;
    private static class_304 enableOverlay;
    private static boolean enabled;
    private static final class_3528<class_1299<class_1297>> TESTING_ENTITY_TYPE;
    private static int threadNumber;
    public static class_4604 frustum;
    private static final ThreadPoolExecutor EXECUTOR;
    private static final List<class_1923> POS;
    private static final Map<class_1923, Long2ReferenceMap<Object>> CHUNK_MAP;
    private static final class_310 CLIENT;
    private static long ticks;

    public static void register(AbstractPlatform platform) {
        configFile = new File(platform.getConfigDir().toFile(), "lightoverlay.properties");
        LightOverlayCore.loadConfig(configFile);
        enableOverlay = platform.registerKeyBinding(LightOverlayCore.createKeyBinding(ENABLE_OVERLAY_KEYBIND, class_3675.class_307.field_1668, 296, KEYBIND_CATEGORY));
        platform.registerDebugRenderer(() -> {
            if (enabled) {
                class_746 playerEntity = LightOverlayCore.CLIENT.field_1724;
                int playerPosX = (int)playerEntity.method_23317() >> 4;
                int playerPosZ = (int)playerEntity.method_23321() >> 4;
                class_3726 collisionContext = class_3726.method_16195((class_1297)playerEntity);
                class_638 world = LightOverlayCore.CLIENT.field_1687;
                class_2338 playerPos = new class_2338(playerEntity.method_23317(), playerEntity.method_23318(), playerEntity.method_23321());
                class_4184 camera = LightOverlayCore.CLIENT.field_1773.method_19418();
                if (showNumber) {
                    RenderSystem.enableTexture();
                    RenderSystem.depthMask((boolean)true);
                    class_2338.class_2339 mutable = new class_2338.class_2339();
                    class_2338.class_2339 downMutable = new class_2338.class_2339();
                    for (Map.Entry<class_1923, Long2ReferenceMap<Object>> entry : CHUNK_MAP.entrySet()) {
                        if (caching && (class_3532.method_15382((int)(entry.getKey().field_9181 - playerPosX)) > LightOverlayCore.getChunkRange() || class_3532.method_15382((int)(entry.getKey().field_9180 - playerPosZ)) > LightOverlayCore.getChunkRange())) continue;
                        for (Long2ReferenceMap.Entry objectEntry : entry.getValue().long2ReferenceEntrySet()) {
                            if (!(objectEntry.getValue() instanceof Byte)) continue;
                            mutable.method_10103(class_2338.method_10061((long)objectEntry.getLongKey()), class_2338.method_10071((long)objectEntry.getLongKey()), class_2338.method_10083((long)objectEntry.getLongKey()));
                            if (!mutable.method_19771((class_2382)playerPos, (double)reach) || frustum != null && !platform.isFrustumVisible(frustum, mutable.method_10263(), mutable.method_10264(), mutable.method_10260(), mutable.method_10263() + 1, mutable.method_10263() + 1, mutable.method_10263() + 1)) continue;
                            downMutable.method_10103(mutable.method_10263(), mutable.method_10264() - 1, mutable.method_10260());
                            LightOverlayCore.renderLevel(CLIENT, camera, (class_1937)world, (class_2338)mutable, (class_2338)downMutable, ((Byte)objectEntry.getValue()).byteValue(), collisionContext);
                        }
                    }
                    RenderSystem.enableDepthTest();
                } else {
                    RenderSystem.enableDepthTest();
                    RenderSystem.disableTexture();
                    RenderSystem.enableBlend();
                    RenderSystem.blendFunc((class_4493.class_4535)class_4493.class_4535.field_22541, (class_4493.class_4534)class_4493.class_4534.field_22523);
                    if (smoothLines) {
                        GL11.glEnable((int)2848);
                    }
                    GL11.glLineWidth((float)lineWidth);
                    GL11.glBegin((int)1);
                    class_2338.class_2339 mutable = new class_2338.class_2339();
                    for (Map.Entry<class_1923, Long2ReferenceMap<Object>> entry : CHUNK_MAP.entrySet()) {
                        if (caching && (class_3532.method_15382((int)(entry.getKey().field_9181 - playerPosX)) > LightOverlayCore.getChunkRange() || class_3532.method_15382((int)(entry.getKey().field_9180 - playerPosZ)) > LightOverlayCore.getChunkRange())) continue;
                        for (Long2ReferenceMap.Entry objectEntry : entry.getValue().long2ReferenceEntrySet()) {
                            if (!(objectEntry.getValue() instanceof CrossType)) continue;
                            mutable.method_10103(class_2338.method_10061((long)objectEntry.getLongKey()), class_2338.method_10071((long)objectEntry.getLongKey()), class_2338.method_10083((long)objectEntry.getLongKey()));
                            if (!mutable.method_19771((class_2382)playerPos, (double)reach) || frustum != null && !platform.isFrustumVisible(frustum, mutable.method_10263(), mutable.method_10264(), mutable.method_10260(), mutable.method_10263() + 1, mutable.method_10263() + 1, mutable.method_10263() + 1)) continue;
                            int color = objectEntry.getValue() == CrossType.RED ? redColor : (objectEntry.getValue() == CrossType.YELLOW ? yellowColor : secondaryColor);
                            LightOverlayCore.renderCross(camera, (class_1937)world, (class_2338)mutable, color, collisionContext);
                        }
                    }
                    GL11.glEnd();
                    RenderSystem.disableBlend();
                    RenderSystem.enableTexture();
                    if (smoothLines) {
                        GL11.glDisable((int)2848);
                    }
                }
            }
        });
        platform.registerClientTick(() -> {
            while (enableOverlay.method_1436()) {
                enabled = !enabled;
            }
            try {
                ++ticks;
                if (LightOverlayCore.CLIENT.field_1724 == null || !enabled) {
                    POS.clear();
                    CHUNK_MAP.clear();
                } else {
                    class_746 player = LightOverlayCore.CLIENT.field_1724;
                    class_638 world = LightOverlayCore.CLIENT.field_1687;
                    class_3726 collisionContext = class_3726.method_16195((class_1297)player);
                    if (!caching) {
                        POS.clear();
                        CHUNK_MAP.clear();
                        class_2338 playerPos = player.method_24515();
                        class_3562 block = world.method_22336().method_15562(class_1944.field_9282);
                        class_3562 sky = showNumber ? null : world.method_22336().method_15562(class_1944.field_9284);
                        class_2338.class_2339 downPos = new class_2338.class_2339();
                        Iterable iterate = class_2338.method_10094((int)(playerPos.method_10263() - reach), (int)(playerPos.method_10264() - reach), (int)(playerPos.method_10260() - reach), (int)(playerPos.method_10263() + reach), (int)(playerPos.method_10264() + reach), (int)(playerPos.method_10260() + reach));
                        Long2ReferenceOpenHashMap map = new Long2ReferenceOpenHashMap();
                        CHUNK_MAP.put(new class_1923(0, 0), (Long2ReferenceMap<Object>)map);
                        for (class_2338 blockPos : iterate) {
                            downPos.method_10103(blockPos.method_10263(), blockPos.method_10264() - 1, blockPos.method_10260());
                            if (showNumber) {
                                int level = LightOverlayCore.getCrossLevel(blockPos, (class_2338)downPos, (class_1922)world, block, collisionContext);
                                if (level < 0) continue;
                                map.put(blockPos.method_10063(), (Object)((byte)level));
                                continue;
                            }
                            CrossType type = LightOverlayCore.getCrossType(blockPos, (class_2338)downPos, (class_1922)world, block, sky, collisionContext);
                            if (type == CrossType.NONE) continue;
                            map.put(blockPos.method_10063(), (Object)type);
                        }
                    } else {
                        int playerPosX = (int)player.method_23317() >> 4;
                        int playerPosZ = (int)player.method_23321() >> 4;
                        if (ticks % 20L == 0L) {
                            for (int chunkX = playerPosX - LightOverlayCore.getChunkRange(); chunkX <= playerPosX + LightOverlayCore.getChunkRange(); ++chunkX) {
                                for (int chunkZ = playerPosZ - LightOverlayCore.getChunkRange(); chunkZ <= playerPosZ + LightOverlayCore.getChunkRange(); ++chunkZ) {
                                    class_1923 chunkPos = new class_1923(chunkX, chunkZ);
                                    if (CHUNK_MAP.containsKey(chunkPos)) continue;
                                    LightOverlayCore.queueChunk(chunkPos);
                                }
                            }
                        }
                        POS.removeIf(pos -> class_3532.method_15382((int)(pos.field_9181 - playerPosX)) > LightOverlayCore.getChunkRange() || class_3532.method_15382((int)(pos.field_9180 - playerPosZ)) > LightOverlayCore.getChunkRange());
                        for (int k = 0; k < 2; ++k) {
                            if (POS.isEmpty()) continue;
                            class_1923 pos2 = POS.stream().min(Comparator.comparingDouble(value -> {
                                int i = Math.abs(value.field_9181 - playerPosX);
                                int j = Math.abs(value.field_9180 - playerPosZ);
                                return i * i + j * j;
                            })).get();
                            POS.remove(pos2);
                            EXECUTOR.submit(() -> {
                                try {
                                    LightOverlayCore.calculateChunk(world.method_2935().method_2857(pos.field_9181, pos.field_9180, class_2806.field_12803, false), (class_1937)world, pos2, collisionContext);
                                }
                                catch (Throwable throwable) {
                                    LogManager.getLogger().throwing(throwable);
                                }
                            });
                        }
                        if (ticks % 50L == 0L) {
                            CHUNK_MAP.entrySet().removeIf(pos -> class_3532.method_15382((int)(((class_1923)pos.getKey()).field_9181 - playerPosX)) > LightOverlayCore.getChunkRange() * 2 || class_3532.method_15382((int)(((class_1923)pos.getKey()).field_9180 - playerPosZ)) > LightOverlayCore.getChunkRange() * 2);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                LogManager.getLogger().throwing(throwable);
            }
        });
    }

    public static void queueChunkAndNear(class_1923 pos) {
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                LightOverlayCore.queueChunk(new class_1923(pos.field_9181 + xOffset, pos.field_9180 + zOffset));
            }
        }
    }

    public static void queueChunk(class_1923 pos) {
        if (caching && !POS.contains(pos)) {
            POS.add(0, pos);
        }
    }

    public static int getChunkRange() {
        return Math.max(class_3532.method_15386((float)((float)reach / 16.0f)), 1);
    }

    private static void calculateChunk(class_2818 chunk, class_1937 world, class_1923 chunkPos, class_3726 entityContext) {
        if (world != null && chunk != null) {
            Long2ReferenceOpenHashMap map = new Long2ReferenceOpenHashMap();
            class_3562 block = world.method_22336().method_15562(class_1944.field_9282);
            class_3562 sky = showNumber ? null : world.method_22336().method_15562(class_1944.field_9284);
            for (class_2338 pos : class_2338.method_10094((int)chunkPos.method_8326(), (int)0, (int)chunkPos.method_8328(), (int)chunkPos.method_8327(), (int)256, (int)chunkPos.method_8329())) {
                class_2338 down = pos.method_10074();
                if (showNumber) {
                    int level = LightOverlayCore.getCrossLevel(pos, down, (class_1922)chunk, block, entityContext);
                    if (level < 0) continue;
                    map.put(pos.method_10063(), (Object)((byte)level));
                    continue;
                }
                CrossType type = LightOverlayCore.getCrossType(pos, down, (class_1922)chunk, block, sky, entityContext);
                if (type == CrossType.NONE) continue;
                map.put(pos.method_10063(), (Object)type);
            }
            CHUNK_MAP.put(chunkPos, (Long2ReferenceMap<Object>)map);
        } else {
            CHUNK_MAP.remove(chunkPos);
        }
    }

    public static CrossType getCrossType(class_2338 pos, class_2338 down, class_1922 world, class_3562 block, class_3562 sky, class_3726 entityContext) {
        class_2680 blockBelowState = world.method_8320(down);
        class_2680 blockUpperState = world.method_8320(pos);
        class_265 upperCollisionShape = blockUpperState.method_26194(world, pos, entityContext);
        if (!underwater && !blockUpperState.method_26227().method_15769()) {
            return CrossType.NONE;
        }
        if (class_2248.method_9501((class_265)upperCollisionShape, (class_2350)class_2350.field_11036)) {
            return CrossType.NONE;
        }
        if (blockUpperState.method_26219()) {
            return CrossType.NONE;
        }
        if (upperCollisionShape.method_1105(class_2350.class_2351.field_11052) > 0.0) {
            return CrossType.NONE;
        }
        if (blockUpperState.method_26204().method_9525((class_3494)class_3481.field_15463)) {
            return CrossType.NONE;
        }
        if (!blockBelowState.method_26170(world, down, (class_1299)TESTING_ENTITY_TYPE.method_15332())) {
            return CrossType.NONE;
        }
        int blockLightLevel = block.method_15543(pos);
        int skyLightLevel = sky.method_15543(pos);
        if (blockLightLevel > higherCrossLevel) {
            return CrossType.NONE;
        }
        if (skyLightLevel > higherCrossLevel) {
            return CrossType.YELLOW;
        }
        return lowerCrossLevel >= 0 && blockLightLevel > lowerCrossLevel ? CrossType.SECONDARY : CrossType.RED;
    }

    public static int getCrossLevel(class_2338 pos, class_2338 down, class_1922 world, class_3562 view, class_3726 collisionContext) {
        class_2680 blockBelowState = world.method_8320(down);
        class_2680 blockUpperState = world.method_8320(pos);
        class_265 collisionShape = blockBelowState.method_26194(world, down, collisionContext);
        class_265 upperCollisionShape = blockUpperState.method_26194(world, pos, collisionContext);
        if (!underwater && !blockUpperState.method_26227().method_15769()) {
            return -1;
        }
        if (!blockBelowState.method_26227().method_15769()) {
            return -1;
        }
        if (blockBelowState.method_26215()) {
            return -1;
        }
        if (class_2248.method_9501((class_265)upperCollisionShape, (class_2350)class_2350.field_11033)) {
            return -1;
        }
        return view.method_15543(pos);
    }

    public static void renderCross(class_4184 camera, class_1937 world, class_2338 pos, int color, class_3726 collisionContext) {
        double d0 = camera.method_19326().field_1352;
        double d1 = camera.method_19326().field_1351 - 0.005;
        class_265 upperOutlineShape = world.method_8320(pos).method_26172((class_1922)world, pos, collisionContext);
        if (!upperOutlineShape.method_1110()) {
            d1 -= upperOutlineShape.method_1105(class_2350.class_2351.field_11052);
        }
        double d2 = camera.method_19326().field_1350;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        RenderSystem.color4f((float)((float)red / 255.0f), (float)((float)green / 255.0f), (float)((float)blue / 255.0f), (float)1.0f);
        GL11.glVertex3d((double)((double)x + 0.01 - d0), (double)((double)y - d1), (double)((double)z + 0.01 - d2));
        GL11.glVertex3d((double)((double)x - 0.01 + 1.0 - d0), (double)((double)y - d1), (double)((double)z - 0.01 + 1.0 - d2));
        GL11.glVertex3d((double)((double)x - 0.01 + 1.0 - d0), (double)((double)y - d1), (double)((double)z + 0.01 - d2));
        GL11.glVertex3d((double)((double)x + 0.01 - d0), (double)((double)y - d1), (double)((double)z - 0.01 + 1.0 - d2));
    }

    public static void renderLevel(class_310 client, class_4184 camera, class_1937 world, class_2338 pos, class_2338 down, int level, class_3726 collisionContext) {
        String text = String.valueOf(level);
        class_327 textRenderer_1 = client.field_1772;
        double double_4 = camera.method_19326().field_1352;
        double double_5 = camera.method_19326().field_1351;
        class_265 upperOutlineShape = world.method_8320(down).method_26172((class_1922)world, down, collisionContext);
        if (!upperOutlineShape.method_1110()) {
            double_5 += 1.0 - upperOutlineShape.method_1105(class_2350.class_2351.field_11052);
        }
        double double_6 = camera.method_19326().field_1350;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)((float)((double)((float)pos.method_10263() + 0.5f) - double_4)), (float)((float)((double)pos.method_10264() - double_5) + 0.005f), (float)((float)((double)((float)pos.method_10260() + 0.5f) - double_6)));
        RenderSystem.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
        float size = 0.07f;
        RenderSystem.scalef((float)(-size), (float)(-size), (float)size);
        float float_3 = (float)(-textRenderer_1.method_1727(text)) / 2.0f + 0.4f;
        RenderSystem.enableAlphaTest();
        class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        textRenderer_1.method_27521(text, float_3, -3.5f, level > higherCrossLevel ? -16505852 : (lowerCrossLevel >= 0 && level > lowerCrossLevel ? -16750849 : -9236207), false, class_4590.method_22931().method_22936(), (class_4597)immediate, false, 0, 0xF000F0);
        immediate.method_22993();
        RenderSystem.popMatrix();
    }

    public static void loadConfig(File file) {
        try {
            redColor = 0xFF0000;
            yellowColor = 0xFFFF00;
            secondaryColor = 255;
            if (!file.exists() || !file.canRead()) {
                LightOverlayCore.saveConfig(file);
            }
            FileInputStream fis = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fis);
            fis.close();
            reach = Integer.parseInt((String)properties.computeIfAbsent("reach", (Function<? super Object, ?>)((Function<Object, Object>)a -> "12")));
            crossLevel = Integer.parseInt((String)properties.computeIfAbsent("crossLevel", (Function<? super Object, ?>)((Function<Object, Object>)a -> "7")));
            secondaryLevel = Integer.parseInt((String)properties.computeIfAbsent("secondaryLevel", (Function<? super Object, ?>)((Function<Object, Object>)a -> "-1")));
            caching = ((String)properties.computeIfAbsent("caching", (Function<? super Object, ?>)((Function<Object, Object>)a -> "false"))).equalsIgnoreCase("true");
            showNumber = ((String)properties.computeIfAbsent("showNumber", (Function<? super Object, ?>)((Function<Object, Object>)a -> "false"))).equalsIgnoreCase("true");
            smoothLines = ((String)properties.computeIfAbsent("smoothLines", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true"))).equalsIgnoreCase("true");
            underwater = ((String)properties.computeIfAbsent("underwater", (Function<? super Object, ?>)((Function<Object, Object>)a -> "false"))).equalsIgnoreCase("true");
            lineWidth = Float.parseFloat((String)properties.computeIfAbsent("lineWidth", (Function<? super Object, ?>)((Function<Object, Object>)a -> "1")));
            int r = Integer.parseInt((String)properties.computeIfAbsent("yellowColorRed", (Function<? super Object, ?>)((Function<Object, Object>)a -> "255")));
            int g = Integer.parseInt((String)properties.computeIfAbsent("yellowColorGreen", (Function<? super Object, ?>)((Function<Object, Object>)a -> "255")));
            int b = Integer.parseInt((String)properties.computeIfAbsent("yellowColorBlue", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            yellowColor = (r << 16) + (g << 8) + b;
            r = Integer.parseInt((String)properties.computeIfAbsent("redColorRed", (Function<? super Object, ?>)((Function<Object, Object>)a -> "255")));
            g = Integer.parseInt((String)properties.computeIfAbsent("redColorGreen", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            b = Integer.parseInt((String)properties.computeIfAbsent("redColorBlue", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            redColor = (r << 16) + (g << 8) + b;
            r = Integer.parseInt((String)properties.computeIfAbsent("secondaryColorRed", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            g = Integer.parseInt((String)properties.computeIfAbsent("secondaryColorGreen", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            b = Integer.parseInt((String)properties.computeIfAbsent("secondaryColorBlue", (Function<? super Object, ?>)((Function<Object, Object>)a -> "255")));
            secondaryColor = (r << 16) + (g << 8) + b;
            LightOverlayCore.saveConfig(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            reach = 12;
            crossLevel = 7;
            secondaryLevel = -1;
            lineWidth = 1.0f;
            redColor = 0xFF0000;
            yellowColor = 0xFFFF00;
            secondaryColor = 255;
            caching = false;
            showNumber = false;
            smoothLines = true;
            underwater = false;
            try {
                LightOverlayCore.saveConfig(file);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (secondaryLevel >= crossLevel) {
            System.err.println("[Light Overlay] Secondary Level is higher than Cross Level");
        }
        lowerCrossLevel = Math.min(crossLevel, secondaryLevel);
        higherCrossLevel = Math.max(crossLevel, secondaryLevel);
        CHUNK_MAP.clear();
        POS.clear();
    }

    public static void saveConfig(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file, false);
        fos.write("# Light Overlay Config".getBytes());
        fos.write("\n".getBytes());
        fos.write(("reach=" + reach).getBytes());
        fos.write("\n".getBytes());
        fos.write(("crossLevel=" + crossLevel).getBytes());
        fos.write("\n".getBytes());
        fos.write(("secondaryLevel=" + secondaryLevel).getBytes());
        fos.write("\n".getBytes());
        fos.write(("caching=" + caching).getBytes());
        fos.write("\n".getBytes());
        fos.write(("showNumber=" + showNumber).getBytes());
        fos.write("\n".getBytes());
        fos.write(("smoothLines=" + smoothLines).getBytes());
        fos.write("\n".getBytes());
        fos.write(("underwater=" + underwater).getBytes());
        fos.write("\n".getBytes());
        fos.write(("lineWidth=" + FORMAT.format(lineWidth)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("yellowColorRed=" + (yellowColor >> 16 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("yellowColorGreen=" + (yellowColor >> 8 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("yellowColorBlue=" + (yellowColor & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("redColorRed=" + (redColor >> 16 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("redColorGreen=" + (redColor >> 8 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("redColorBlue=" + (redColor & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("secondaryColorRed=" + (secondaryColor >> 16 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("secondaryColorGreen=" + (secondaryColor >> 8 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("secondaryColorBlue=" + (secondaryColor & 0xFF)).getBytes());
        fos.close();
    }

    private static class_304 createKeyBinding(class_2960 id, class_3675.class_307 type, int code, String category) {
        return new class_304("key." + id.method_12836() + "." + id.method_12832(), type, code, category);
    }

    static {
        enabled = false;
        TESTING_ENTITY_TYPE = new class_3528(() -> class_1299.class_1300.method_5902((class_1311)class_1311.field_6302).method_17687(0.0f, 0.0f).method_5904().method_5905(null));
        threadNumber = 0;
        EXECUTOR = (ThreadPoolExecutor)Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), r -> {
            Thread thread = new Thread(r, "light-overlay-" + threadNumber++);
            thread.setDaemon(true);
            return thread;
        });
        POS = Lists.newCopyOnWriteArrayList();
        CHUNK_MAP = Maps.newConcurrentMap();
        CLIENT = class_310.method_1551();
        ticks = 0L;
    }

    private static enum CrossType {
        YELLOW,
        RED,
        SECONDARY,
        NONE;

    }
}

