/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.fabricmc.installer.repackage.com.google.gson.JsonArray;
import net.fabricmc.installer.repackage.com.google.gson.JsonElement;
import net.fabricmc.installer.repackage.com.google.gson.JsonObject;
import net.fabricmc.installer.util.Utils;

public class MinecraftLaunchJson {
    public String id;
    public String inheritsFrom;
    public String releaseTime;
    public String time;
    public String type;
    public String mainClass;
    public transient String mainClassServer;
    public Arguments arguments;
    public List<Library> libraries;

    public MinecraftLaunchJson(JsonObject jsonObject) {
        this.time = this.releaseTime = Utils.ISO_8601.format(new Date());
        this.type = "release";
        this.arguments = new Arguments();
        this.libraries = new ArrayList<Library>();
        if (!jsonObject.get("mainClass").isJsonObject()) {
            this.mainClass = jsonObject.get("mainClass").getAsString();
        } else {
            this.mainClass = jsonObject.get("mainClass").getAsJsonObject().get("client").getAsString();
            this.mainClassServer = jsonObject.get("mainClass").getAsJsonObject().get("server").getAsString();
        }
        if (jsonObject.has("launchwrapper")) {
            String clientTweaker = jsonObject.get("launchwrapper").getAsJsonObject().get("tweakers").getAsJsonObject().get("client").getAsJsonArray().get(0).getAsString();
            this.arguments.game.add("--tweakClass");
            this.arguments.game.add(clientTweaker);
        }
        String[] validSides = new String[]{"common", "server"};
        JsonObject librariesObject = jsonObject.getAsJsonObject("libraries");
        for (String side : validSides) {
            JsonArray librariesArray = librariesObject.getAsJsonArray(side);
            librariesArray.forEach(jsonElement -> this.libraries.add(new Library((JsonElement)jsonElement)));
        }
    }

    public static class Arguments {
        public List<String> game = new ArrayList<String>();
    }

    public static class Library {
        public String name;
        public String url;

        public Library(String name, String url) {
            this.name = name;
            this.url = url;
        }

        private Library(JsonElement jsonElement) {
            JsonObject jsonObject = (JsonObject)jsonElement;
            this.name = jsonObject.get("name").getAsString();
            if (jsonObject.has("url")) {
                this.url = jsonObject.get("url").getAsString();
            }
        }

        public String getURL() {
            String[] parts = this.name.split(":", 3);
            String path = parts[0].replace(".", "/") + "/" + parts[1] + "/" + parts[2] + "/" + parts[1] + "-" + parts[2] + ".jar";
            return this.url + path;
        }

        public String getPath() {
            String[] parts = this.name.split(":", 3);
            String path = parts[0].replace(".", File.separator) + File.separator + parts[1] + File.separator + parts[2] + File.separator + parts[1] + "-" + parts[2] + ".jar";
            return path.replaceAll(" ", "_");
        }

        public File getFile(File baseDir) {
            return new File(baseDir, this.getPath());
        }

        public String getFileName() {
            String path = this.getPath();
            return path.substring(path.lastIndexOf("\\") + 1);
        }
    }
}

