/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.installer.repackage.com.google.gson.reflect.TypeToken;
import net.fabricmc.installer.util.CompletableHandler;
import net.fabricmc.installer.util.Utils;

public class MetaHandler
extends CompletableHandler<List<GameVersion>> {
    private final String metaUrl;
    private List<GameVersion> versions;

    public MetaHandler(String url) {
        this.metaUrl = url;
    }

    public void load() throws IOException {
        URL url = new URL(this.metaUrl);
        URLConnection conn = url.openConnection();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
            String json = reader.lines().collect(Collectors.joining("\n"));
            Type type = new TypeToken<ArrayList<GameVersion>>(){}.getType();
            this.versions = (List)Utils.GSON.fromJson(json, type);
            this.complete(this.versions);
        }
    }

    public List<GameVersion> getVersions() {
        return Collections.unmodifiableList(this.versions);
    }

    public GameVersion getLatestVersion(boolean snapshot) {
        if (snapshot) {
            return this.versions.get(0);
        }
        return this.versions.stream().filter(GameVersion::isStable).findFirst().orElse(null);
    }

    public static class GameVersion {
        String version;
        boolean stable;

        public String getVersion() {
            return this.version;
        }

        public boolean isStable() {
            return this.stable;
        }
    }
}

