/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.swing.JPanel;
import net.fabricmc.installer.Handler;
import net.fabricmc.installer.InstallerGui;
import net.fabricmc.installer.server.ServerInstaller;
import net.fabricmc.installer.server.ServerPostInstallDialog;
import net.fabricmc.installer.util.ArgumentParser;
import net.fabricmc.installer.util.InstallerProgress;
import net.fabricmc.installer.util.LauncherMeta;
import net.fabricmc.installer.util.Utils;

public class ServerHandler
extends Handler {
    @Override
    public String name() {
        return "Server";
    }

    @Override
    public void install() {
        String gameVersion = (String)this.gameVersionComboBox.getSelectedItem();
        String loaderVersion = (String)this.loaderVersionComboBox.getSelectedItem();
        new Thread(() -> {
            try {
                ServerInstaller.install(new File(this.installLocation.getText()), loaderVersion, gameVersion, this);
                ServerPostInstallDialog.show(this);
            }
            catch (Exception e) {
                this.error(e);
            }
            this.buttonInstall.setEnabled(true);
        }).start();
    }

    @Override
    public void installCli(ArgumentParser args) throws Exception {
        File file = new File(args.getOrDefault("dir", () -> "."));
        if (!file.exists()) {
            throw new FileNotFoundException("Server directory not found at " + file.getAbsolutePath());
        }
        String loaderVersion = this.getLoaderVersion(args);
        String gameVersion = this.getGameVersion(args);
        ServerInstaller.install(file.getAbsoluteFile(), loaderVersion, gameVersion, InstallerProgress.CONSOLE);
        if (args.has("downloadMinecraft")) {
            File serverJar = new File(file, "server.jar");
            File serverJarTmp = new File(file, "server.jar.tmp");
            Files.deleteIfExists(serverJar.toPath());
            InstallerProgress.CONSOLE.updateProgress(Utils.BUNDLE.getString("progress.download.minecraft"));
            Utils.downloadFile(new URL(LauncherMeta.getLauncherMeta().getVersion((String)gameVersion).getVersionMeta().downloads.get((Object)"server").url), serverJarTmp);
            Files.move(serverJarTmp.toPath(), serverJar.toPath(), StandardCopyOption.REPLACE_EXISTING);
            InstallerProgress.CONSOLE.updateProgress(Utils.BUNDLE.getString("progress.done"));
        }
    }

    @Override
    public String cliHelp() {
        return "-dir <install dir, default current dir> -mcversion <minecraft version, default latest> -loader <loader version, default latest> -downloadMinecraft";
    }

    @Override
    public void setupPane1(JPanel pane, InstallerGui installerGui) {
    }

    @Override
    public void setupPane2(JPanel pane, InstallerGui installerGui) {
        this.installLocation.setText(new File("").getAbsolutePath());
    }
}

