/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer.client;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import net.fabricmc.installer.repackage.com.google.gson.JsonObject;
import net.fabricmc.installer.util.Utils;

public class ProfileInstaller {
    public static void setupProfile(File path, String name, String gameVersion) throws IOException {
        File launcherProfiles = new File(path, "launcher_profiles.json");
        if (!launcherProfiles.exists()) {
            System.out.println("Could not find launcher_profiles");
            return;
        }
        System.out.println("Creating profile");
        String json = Utils.readFile(launcherProfiles);
        JsonObject jsonObject = Utils.GSON.fromJson(json, JsonObject.class);
        JsonObject profiles = jsonObject.getAsJsonObject("profiles");
        String profileName = "fabric-loader-" + gameVersion;
        JsonObject profile = profiles.has(profileName) ? profiles.get(profileName).getAsJsonObject() : ProfileInstaller.createProfile(profileName);
        profile.addProperty("lastVersionId", name);
        profiles.add(profileName, profile);
        Utils.writeToFile(launcherProfiles, Utils.GSON.toJson(jsonObject));
    }

    private static JsonObject createProfile(String name) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", name);
        jsonObject.addProperty("type", "custom");
        jsonObject.addProperty("created", Utils.ISO_8601.format(new Date()));
        jsonObject.addProperty("lastUsed", Utils.ISO_8601.format(new Date()));
        jsonObject.addProperty("icon", Utils.getProfileIcon());
        return jsonObject;
    }
}

