/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer.client;

import java.io.File;
import java.io.IOException;
import net.fabricmc.installer.util.InstallerProgress;
import net.fabricmc.installer.util.MinecraftLaunchJson;
import net.fabricmc.installer.util.Reference;
import net.fabricmc.installer.util.Utils;

public class ClientInstaller {
    public static String install(File mcDir, String gameVersion, String loaderVersion, InstallerProgress progress) throws IOException {
        System.out.println("Installing " + gameVersion + " with fabric " + loaderVersion);
        String profileName = String.format("%s-%s-%s", "fabric-loader", loaderVersion, gameVersion);
        MinecraftLaunchJson launchJson = Utils.getLaunchMeta(loaderVersion);
        launchJson.id = profileName;
        launchJson.inheritsFrom = gameVersion;
        launchJson.libraries.add(new MinecraftLaunchJson.Library("net/fabricmc".replaceAll("/", ".") + ":" + "intermediary" + ":" + gameVersion, Reference.mavenServerUrl));
        launchJson.libraries.add(new MinecraftLaunchJson.Library("net/fabricmc".replaceAll("/", ".") + ":" + "fabric-loader" + ":" + loaderVersion, Reference.mavenServerUrl));
        File versionsDir = new File(mcDir, "versions");
        File profileDir = new File(versionsDir, profileName);
        File profileJson = new File(profileDir, profileName + ".json");
        if (!profileDir.exists()) {
            profileDir.mkdirs();
        }
        File dummyJar = new File(profileDir, profileName + ".jar");
        dummyJar.createNewFile();
        Utils.writeToFile(profileJson, Utils.GSON.toJson(launchJson));
        progress.updateProgress(Utils.BUNDLE.getString("progress.done"));
        return profileName;
    }
}

