/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer;

import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import net.fabricmc.installer.Handler;
import net.fabricmc.installer.InstallerGui;
import net.fabricmc.installer.client.ClientHandler;
import net.fabricmc.installer.server.ServerHandler;
import net.fabricmc.installer.util.ArgumentParser;
import net.fabricmc.installer.util.CrashDialog;
import net.fabricmc.installer.util.MetaHandler;
import net.fabricmc.installer.util.Reference;

public class Main {
    public static MetaHandler GAME_VERSION_META;
    public static MetaHandler LOADER_META;
    public static final List<Handler> HANDLERS;

    public static void main(String[] args) throws IOException {
        String[] versionSplit = System.getProperty("java.version").split("\\.");
        if (versionSplit.length == 2) {
            int javaVersionMajor = Integer.parseInt(versionSplit[0]);
            int javaVersionMinor = Integer.parseInt(versionSplit[1]);
            if (javaVersionMinor < 8 && javaVersionMajor <= 1) {
                System.out.println("You are using an outdated version of Java, Fabric will not work! Please update to Java 8 or newer to use Fabric.");
                if (args.length == 0 || !args[0].equals("nogui")) {
                    JOptionPane.showMessageDialog(null, "You are using an outdated version of Java, Fabric will not work! Please update to Java 8 or newer to use Fabric.", "Java Version Warning", 0);
                }
                return;
            }
        }
        System.out.println("Loading Fabric Installer: " + Main.class.getPackage().getImplementationVersion());
        HANDLERS.add(new ClientHandler());
        HANDLERS.add(new ServerHandler());
        ArgumentParser argumentParser = ArgumentParser.create(args);
        String command = argumentParser.getCommand().orElse(null);
        Main.setDebugLevel(Level.SEVERE);
        argumentParser.ifPresent("mavenurl", s -> {
            Reference.mavenServerUrl = s;
        });
        String metaUrl = argumentParser.getOrDefault("metaurl", () -> "https://meta.fabricmc.net/");
        GAME_VERSION_META = new MetaHandler(metaUrl + "v2/versions/game");
        LOADER_META = new MetaHandler(metaUrl + "v2/versions/loader");
        if (GraphicsEnvironment.isHeadless() && command == null) {
            command = "help";
        }
        if (command == null) {
            try {
                InstallerGui.start();
            }
            catch (Exception e) {
                e.printStackTrace();
                new CrashDialog(e);
            }
        } else if (command.equals("help")) {
            System.out.println("help - Opens this menu");
            HANDLERS.forEach(handler -> System.out.printf("%s %s\n", handler.name().toLowerCase(), handler.cliHelp()));
            LOADER_META.load();
            GAME_VERSION_META.load();
            System.out.printf("\nLatest Version: %s\nLatest Loader: %s\n", GAME_VERSION_META.getLatestVersion(argumentParser.has("snapshot")).getVersion(), LOADER_META.getLatestVersion(false).getVersion());
        } else {
            for (Handler handler2 : HANDLERS) {
                if (!command.equalsIgnoreCase(handler2.name())) continue;
                try {
                    handler2.installCli(argumentParser);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to install " + handler2.name(), e);
                }
                return;
            }
            System.out.println("No handler found for " + args[0] + " see help");
        }
    }

    public static void setDebugLevel(Level newLvl) {
        Logger rootLogger = LogManager.getLogManager().getLogger("");
        java.util.logging.Handler[] handlers = rootLogger.getHandlers();
        rootLogger.setLevel(newLvl);
        for (java.util.logging.Handler h : handlers) {
            if (!(h instanceof FileHandler)) continue;
            h.setLevel(newLvl);
        }
    }

    static {
        HANDLERS = new ArrayList<Handler>();
    }
}

