/*
 * Decompiled with CFR 0.152.
 */
package troy.autofish.scheduler;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import troy.autofish.ForgeModAutofish;
import troy.autofish.scheduler.Action;
import troy.autofish.scheduler.ActionType;

public class AutofishScheduler {
    private ForgeModAutofish modAutofish;
    private List<Action> queuedActions = new ArrayList<Action>();
    private List<Action> repeatingActions = new ArrayList<Action>();
    private boolean doesWorldExist;

    public AutofishScheduler(ForgeModAutofish modAutofish) {
        this.modAutofish = modAutofish;
    }

    public void tick(Minecraft client) {
        if (client.field_71441_e == null == this.doesWorldExist) {
            this.doesWorldExist = client.field_71441_e != null;
            this.repeatingActions.forEach(Action::resetTimer);
        }
        if (!this.modAutofish.getConfig().isAutofishEnabled()) {
            this.queuedActions.clear();
        }
        if (client.field_71441_e == null || client.field_71439_g == null) {
            this.queuedActions.clear();
            return;
        }
        this.queuedActions.removeIf(Action::tick);
        this.repeatingActions.forEach(Action::tick);
    }

    public void scheduleAction(ActionType actionType, long delay, Runnable runnable) {
        this.queuedActions.add(new Action(actionType, delay, runnable));
    }

    public void scheduleAction(Action action) {
        this.queuedActions.add(action);
    }

    public void scheduleRepeatingAction(long interval, Runnable runnable) {
        this.repeatingActions.add(new Action(ActionType.REPEATING_ACTION, interval, runnable));
    }

    public boolean isRecastQueued() {
        return this.queuedActions.stream().anyMatch(action -> action.getActionType() == ActionType.RECAST);
    }
}

