/*
 * Decompiled with CFR 0.152.
 */
package troy.autofish;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChatPacket;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Util;
import net.minecraft.world.World;
import troy.autofish.ForgeModAutofish;
import troy.autofish.monitor.FishMonitorMP;
import troy.autofish.monitor.FishMonitorMPMotion;
import troy.autofish.monitor.FishMonitorMPSound;
import troy.autofish.scheduler.ActionType;

public class Autofish {
    private Minecraft client;
    private ForgeModAutofish modAutofish;
    private FishMonitorMP fishMonitorMP;
    private boolean hookExists = false;
    private long hookRemovedAt = 0L;
    public long timeMillis = 0L;

    public Autofish(ForgeModAutofish modAutofish) {
        this.modAutofish = modAutofish;
        this.client = Minecraft.func_71410_x();
        this.setDetection();
        modAutofish.getScheduler().scheduleRepeatingAction(10000L, () -> {
            if (!modAutofish.getConfig().isPersistentMode()) {
                return;
            }
            if (!this.isHoldingFishingRod()) {
                return;
            }
            if (this.hookExists) {
                return;
            }
            if (modAutofish.getScheduler().isRecastQueued()) {
                return;
            }
            this.useRod();
        });
    }

    public void tick(Minecraft client) {
        if (client.field_71441_e != null && client.field_71439_g != null && this.modAutofish.getConfig().isAutofishEnabled()) {
            this.timeMillis = Util.func_211177_b();
            if (this.isHoldingFishingRod()) {
                if (client.field_71439_g.field_71104_cf != null) {
                    this.hookExists = true;
                    if (!client.func_71356_B()) {
                        this.fishMonitorMP.hookTick(this, client, client.field_71439_g.field_71104_cf);
                    }
                } else {
                    this.removeHook();
                }
            } else {
                this.removeHook();
            }
        }
    }

    public void handlePacket(IPacket<?> packet) {
        if (this.modAutofish.getConfig().isAutofishEnabled() && !this.client.func_71356_B()) {
            this.fishMonitorMP.handlePacket(this, packet, this.client);
        }
    }

    public void handleChat(SChatPacket packet) {
        if (this.modAutofish.getConfig().isAutofishEnabled() && !this.client.func_71356_B() && this.isHoldingFishingRod() && (this.hookExists || this.timeMillis - this.hookRemovedAt < 2000L)) {
            if (org.apache.commons.lang3.StringUtils.deleteWhitespace((String)this.modAutofish.getConfig().getClearLagRegex()).isEmpty()) {
                return;
            }
            Matcher matcher = Pattern.compile(this.modAutofish.getConfig().getClearLagRegex(), 2).matcher(StringUtils.func_76338_a((String)packet.func_148915_c().getString()));
            if (matcher.find()) {
                this.queueRecast();
            }
        }
    }

    public void tickFishingLogic(Entity owner, int ticksCatchable) {
        if (this.modAutofish.getConfig().isAutofishEnabled() && this.client.func_71356_B() && this.client.field_71439_g != null && this.client.field_71439_g.field_71104_cf != null && ticksCatchable > 0 && owner.func_110124_au().compareTo(this.client.field_71439_g.func_110124_au()) == 0) {
            this.catchFish();
        }
    }

    public void catchFish() {
        if (!this.modAutofish.getScheduler().isRecastQueued()) {
            this.queueRodSwitch();
            this.queueRecast();
            this.useRod();
        }
    }

    public void queueRecast() {
        this.modAutofish.getScheduler().scheduleAction(ActionType.RECAST, this.modAutofish.getConfig().getRecastDelay(), () -> {
            if (this.hookExists) {
                return;
            }
            if (!this.isHoldingFishingRod()) {
                return;
            }
            if (this.modAutofish.getConfig().isNoBreak() && this.getHeldItem().func_77952_i() >= 63) {
                return;
            }
            this.useRod();
        });
    }

    private void queueRodSwitch() {
        this.modAutofish.getScheduler().scheduleAction(ActionType.ROD_SWITCH, this.modAutofish.getConfig().getRecastDelay() - 500L, () -> {
            if (!this.modAutofish.getConfig().isMultiRod()) {
                return;
            }
            if (!this.isHoldingFishingRod()) {
                return;
            }
            this.switchToFirstRod(this.client.field_71439_g);
        });
    }

    private void removeHook() {
        if (this.hookExists) {
            this.hookExists = false;
            this.hookRemovedAt = this.timeMillis;
            this.fishMonitorMP.handleHookRemoved();
        }
    }

    public void switchToFirstRod(ClientPlayerEntity player) {
        if (player != null) {
            PlayerInventory inventory = player.field_71071_by;
            for (int i = 0; i < inventory.field_70462_a.size(); ++i) {
                ItemStack slot = (ItemStack)inventory.field_70462_a.get(i);
                if (slot.func_77973_b() != Items.field_151112_aM || i >= 9) continue;
                if (this.modAutofish.getConfig().isNoBreak()) {
                    if (slot.func_77952_i() >= 63) continue;
                    inventory.field_70461_c = i;
                    return;
                }
                inventory.field_70461_c = i;
                return;
            }
        }
    }

    public void useRod() {
        Hand hand;
        ActionResultType actionResult;
        if (this.client.field_71439_g != null && this.client.field_71441_e != null && (actionResult = this.client.field_71442_b.func_187101_a((PlayerEntity)this.client.field_71439_g, (World)this.client.field_71441_e, hand = this.getCorrectHand())).func_226246_a_()) {
            if (actionResult.func_226247_b_()) {
                this.client.field_71439_g.func_184609_a(hand);
            }
            this.client.field_71460_t.field_78516_c.func_187460_a(hand);
        }
    }

    public boolean isHoldingFishingRod() {
        return this.isItemFishingRod(this.getHeldItem().func_77973_b());
    }

    private Hand getCorrectHand() {
        if (!this.modAutofish.getConfig().isMultiRod() && this.isItemFishingRod(this.client.field_71439_g.func_184592_cb().func_77973_b())) {
            return Hand.OFF_HAND;
        }
        return Hand.MAIN_HAND;
    }

    private ItemStack getHeldItem() {
        if (!this.modAutofish.getConfig().isMultiRod() && this.isItemFishingRod(this.client.field_71439_g.func_184592_cb().func_77973_b())) {
            return this.client.field_71439_g.func_184592_cb();
        }
        return this.client.field_71439_g.func_184614_ca();
    }

    private boolean isItemFishingRod(Item item) {
        return item == Items.field_151112_aM || item instanceof FishingRodItem;
    }

    public void setDetection() {
        this.fishMonitorMP = this.modAutofish.getConfig().isUseSoundDetection() ? new FishMonitorMPSound() : new FishMonitorMPMotion();
    }
}

