/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.grid;

import de.guntram.mcmod.GBForgetools.ConfigChangedEvent;
import de.guntram.mcmod.GBForgetools.Configuration;
import de.guntram.mcmod.GBForgetools.ModConfigurationHandler;
import java.io.File;

public class ConfigurationHandler
implements ModConfigurationHandler {
    private static ConfigurationHandler instance;
    private Configuration config;
    private String configFileName;
    int blockColor;
    int lineColor;
    int circleColor;
    int spawnNightColor;
    int spawnDayColor;
    int biomeColor;
    boolean useCache;

    public static ConfigurationHandler getInstance() {
        if (instance == null) {
            instance = new ConfigurationHandler();
        }
        return instance;
    }

    public void load(File configFile) {
        if (this.config == null) {
            this.config = new Configuration(configFile);
            this.configFileName = configFile.getPath();
            this.loadConfig();
        }
    }

    @Override
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("grid")) {
            this.loadConfig();
        }
    }

    @Override
    public void onConfigChanging(ConfigChangedEvent.OnConfigChangingEvent event) {
        switch (event.getItem()) {
            case "grid.config.colorblock": {
                this.blockColor = (Integer)event.getNewValue();
                break;
            }
            case "grid.config.colorline": {
                this.lineColor = (Integer)event.getNewValue();
                break;
            }
            case "grid.config.colorcircle": {
                this.circleColor = (Integer)event.getNewValue();
                break;
            }
            case "grid.config.colorspawnnight": {
                this.spawnNightColor = (Integer)event.getNewValue();
                break;
            }
            case "grid.config.colorspawnday": {
                this.spawnDayColor = (Integer)event.getNewValue();
                break;
            }
            case "grid.config.colorbiome": {
                this.biomeColor = (Integer)event.getNewValue();
            }
        }
    }

    private void loadConfig() {
        this.config.forget("grid.config.blockcolor");
        this.config.forget("grid.config.linecolor");
        this.config.forget("grid.config.circlecolor");
        this.config.forget("grid.config.spawnNightcolor");
        this.config.forget("grid.config.spawnDaycolor");
        this.config.forget("grid.config.biomecolor");
        this.config.forget("grid.config.cacheupdateseconds");
        this.blockColor = this.config.getInt("grid.config.colorblock", 0, 0x8080FF, 0, 0xFFFFFF, "grid.config.tt.colorblock");
        this.lineColor = this.config.getInt("grid.config.colorline", 0, 0xFF8000, 0, 0xFFFFFF, "grid.config.tt.colorline");
        this.circleColor = this.config.getInt("grid.config.colorcircle", 0, 58496, 0, 0xFFFFFF, "grid.config.tt.colorcircle");
        this.spawnNightColor = this.config.getInt("grid.config.colorspawnnight", 0, 0xFFFF00, 0, 0xFFFFFF, "grid.config.tt.colorspawnnight");
        this.spawnDayColor = this.config.getInt("grid.config.colorspawnday", 0, 0xFF0000, 0, 0xFFFFFF, "grid.config.tt.colorspawnday");
        this.biomeColor = this.config.getInt("grid.config.colorbiome", 0, 0xFF00FF, 0, 0xFFFFFF, "grid.config.tt.colorbiome");
        this.useCache = this.config.getBoolean("grid.config.usecache", 0, true, "grid.config.tt.usecache");
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    @Override
    public Configuration getConfig() {
        return this.config;
    }

    public static String getConfigFileName() {
        return ConfigurationHandler.getInstance().configFileName;
    }

    public static boolean getUseCache() {
        return ConfigurationHandler.getInstance().useCache;
    }
}

