/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.RadarSettingsManager;
import com.mamiyaotaru.voxelmap.interfaces.IRadar;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.Contact;
import com.mamiyaotaru.voxelmap.util.EnumMobs;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.ImageUtils;
import com.mamiyaotaru.voxelmap.util.LayoutVariables;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1456;
import net.minecraft.class_1463;
import net.minecraft.class_1493;
import net.minecraft.class_1569;
import net.minecraft.class_1590;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4466;
import net.minecraft.class_745;

public class RadarSimple
implements IRadar {
    private class_310 game;
    private LayoutVariables layoutVariables = null;
    public MapSettingsManager minimapOptions = null;
    public RadarSettingsManager options = null;
    private TextureAtlas textureAtlas;
    private boolean enabled = true;
    private boolean completedLoading = false;
    private int timer = 500;
    private float direction = 0.0f;
    private ArrayList<Contact> contacts = new ArrayList(40);
    UUID devUUID = UUID.fromString("9b37abb9-2487-4712-bb96-21a1e0b2023c");

    public RadarSimple(IVoxelMap master) {
        this.minimapOptions = master.getMapOptions();
        this.options = master.getRadarOptions();
        this.game = class_310.method_1551();
        this.textureAtlas = new TextureAtlas("pings");
        this.textureAtlas.method_4527(false, false);
    }

    @Override
    public void onResourceManagerReload(class_3300 resourceManager) {
        this.loadTexturePackIcons();
    }

    private void loadTexturePackIcons() {
        this.completedLoading = false;
        try {
            this.textureAtlas.reset();
            BufferedImage contact = ImageUtils.loadImage(new class_2960("voxelmap", "images/radar/contact.png"), 0, 0, 32, 32, 32, 32);
            contact = ImageUtils.fillOutline(contact, false, true, 32.0f, 32.0f, 0);
            this.textureAtlas.registerIconForBufferedImage("contact", contact);
            BufferedImage facing = ImageUtils.loadImage(new class_2960("voxelmap", "images/radar/contact_facing.png"), 0, 0, 32, 32, 32, 32);
            facing = ImageUtils.fillOutline(facing, false, true, 32.0f, 32.0f, 0);
            this.textureAtlas.registerIconForBufferedImage("facing", facing);
            BufferedImage glow = ImageUtils.loadImage(new class_2960("voxelmap", "images/radar/glow.png"), 0, 0, 16, 16, 16, 16);
            glow = ImageUtils.fillOutline(glow, false, true, 16.0f, 16.0f, 0);
            this.textureAtlas.registerIconForBufferedImage("glow", glow);
            this.textureAtlas.stitch();
            this.completedLoading = true;
        }
        catch (Exception e) {
            System.err.println("Failed getting mobs " + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void OnTickInGame(class_310 mc, LayoutVariables layoutVariables) {
        if (!(this.options.radarAllowed.booleanValue() || this.options.radarMobsAllowed.booleanValue() || this.options.radarPlayersAllowed.booleanValue())) {
            return;
        }
        if (this.game == null) {
            this.game = mc;
        }
        this.layoutVariables = layoutVariables;
        if (this.options.isChanged()) {
            this.timer = 500;
        }
        this.direction = GameVariableAccessShim.rotationYaw() + 180.0f;
        while (this.direction >= 360.0f) {
            this.direction -= 360.0f;
        }
        while (this.direction < 0.0f) {
            this.direction += 360.0f;
        }
        if (this.enabled) {
            if (this.completedLoading && this.timer > 95) {
                this.calculateMobs();
                this.timer = 0;
            }
            ++this.timer;
            if (this.completedLoading) {
                this.renderMapMobs(this.layoutVariables.mapX, this.layoutVariables.mapY);
            }
            GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void calculateMobs() {
        this.contacts.clear();
        Iterable entities = this.game.field_1687.method_18112();
        for (class_1297 entity : entities) {
            try {
                if (entity == null || entity.method_5756((class_1657)this.game.field_1724) || (!this.options.showHostiles || !this.options.radarAllowed.booleanValue() && !this.options.radarMobsAllowed.booleanValue() || !this.isHostile(entity)) && (!this.options.showPlayers || !this.options.radarAllowed.booleanValue() && !this.options.radarPlayersAllowed.booleanValue() || !this.isPlayer(entity)) && (!this.options.showNeutrals || !this.options.radarMobsAllowed.booleanValue() || !this.isNeutral(entity))) continue;
                int wayX = GameVariableAccessShim.xCoord() - (int)entity.method_19538().method_10216();
                int wayZ = GameVariableAccessShim.zCoord() - (int)entity.method_19538().method_10215();
                int wayY = GameVariableAccessShim.yCoord() - (int)entity.method_19538().method_10214();
                double hypot = wayX * wayX + wayZ * wayZ + wayY * wayY;
                if (!((hypot /= this.layoutVariables.zoomScaleAdjusted * this.layoutVariables.zoomScaleAdjusted) < 961.0)) continue;
                Contact contact = new Contact(entity, this.getUnknownMobNeutrality(entity));
                String unscrubbedName = contact.entity.method_5476().getString();
                contact.setName(unscrubbedName);
                contact.updateLocation();
                this.contacts.add(contact);
            }
            catch (Exception e) {
                System.err.println(e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
        Collections.sort(this.contacts, new Comparator<Contact>(){

            @Override
            public int compare(Contact contact1, Contact contact2) {
                return contact1.y - contact2.y;
            }
        });
    }

    private EnumMobs getUnknownMobNeutrality(class_1297 entity) {
        if (this.isHostile(entity)) {
            return EnumMobs.GENERICHOSTILE;
        }
        if (entity instanceof class_1321 && ((class_1321)entity).method_6181() && (this.game.method_1496() || ((class_1321)entity).method_6177().equals((Object)this.game.field_1724))) {
            return EnumMobs.GENERICTAME;
        }
        return EnumMobs.GENERICNEUTRAL;
    }

    private boolean isHostile(class_1297 entity) {
        if (entity instanceof class_1590) {
            return ((class_1590)entity).method_7076((class_1657)this.game.field_1724);
        }
        if (entity instanceof class_1569) {
            return true;
        }
        if (entity instanceof class_4466) {
            return ((class_4466)entity).method_29511();
        }
        if (entity instanceof class_1456) {
            for (class_1456 polarBear : ((class_1456)entity).field_6002.method_18467(class_1456.class, ((class_1456)entity).method_5829().method_1009(8.0, 4.0, 8.0))) {
                if (!polarBear.method_6109()) continue;
                return true;
            }
        }
        if (entity instanceof class_1463) {
            return ((class_1463)entity).method_6610() == 99;
        }
        if (entity instanceof class_1493) {
            return ((class_1493)entity).method_29511();
        }
        return false;
    }

    private boolean isPlayer(class_1297 entity) {
        return entity instanceof class_745;
    }

    private boolean isNeutral(class_1297 entity) {
        if (entity instanceof class_1309) {
            return !(entity instanceof class_1657) && !this.isHostile(entity);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderMapMobs(int x, int y) {
        double max = this.layoutVariables.zoomScaleAdjusted * 32.0;
        GLUtils.disp(this.textureAtlas.method_4624());
        for (Contact contact : this.contacts) {
            contact.updateLocation();
            double contactX = contact.x;
            double contactZ = contact.z;
            int contactY = contact.y;
            double wayX = GameVariableAccessShim.xCoordDouble() - contactX;
            double wayZ = GameVariableAccessShim.zCoordDouble() - contactZ;
            int wayY = GameVariableAccessShim.yCoord() - contactY;
            double adjustedDiff = max - (double)Math.max(Math.abs(wayY) - 0, 0);
            contact.brightness = (float)Math.max(adjustedDiff / max, 0.0);
            contact.brightness *= contact.brightness;
            contact.angle = (float)Math.toDegrees(Math.atan2(wayX, wayZ));
            contact.distance = Math.sqrt(wayX * wayX + wayZ * wayZ) / this.layoutVariables.zoomScaleAdjusted;
            GLShim.glBlendFunc(770, 771);
            if (wayY < 0) {
                GLShim.glColor4f(1.0f, 1.0f, 1.0f, contact.brightness);
            } else {
                GLShim.glColor3f(1.0f * contact.brightness, 1.0f * contact.brightness, 1.0f * contact.brightness);
            }
            if (this.minimapOptions.rotates) {
                contact.angle += this.direction;
            } else if (this.minimapOptions.oldNorth) {
                contact.angle -= 90.0f;
            }
            boolean inRange = false;
            if (this.minimapOptions.squareMap) {
                double radLocate = Math.toRadians(contact.angle);
                double dispX = contact.distance * Math.cos(radLocate);
                double dispY = contact.distance * Math.sin(radLocate);
                inRange = Math.abs(dispX) <= 28.5 && Math.abs(dispY) <= 28.5;
            } else {
                boolean bl = inRange = contact.distance < 31.0;
            }
            if (!inRange) continue;
            try {
                GLShim.glPushMatrix();
                float contactFacing = contact.entity.method_5791();
                if (this.minimapOptions.rotates) {
                    contactFacing -= this.direction;
                } else if (this.minimapOptions.oldNorth) {
                    contactFacing += 90.0f;
                }
                GLShim.glTranslatef(x, y, 0.0f);
                GLShim.glRotatef(-contact.angle, 0.0f, 0.0f, 1.0f);
                GLShim.glTranslated(0.0, -contact.distance, 0.0);
                GLShim.glRotatef(contact.angle + contactFacing, 0.0f, 0.0f, 1.0f);
                GLShim.glTranslatef(-x, -y, 0.0f);
                if (contact.uuid != null && contact.uuid.equals(this.devUUID)) {
                    Sprite icon = this.textureAtlas.getAtlasSprite("glow");
                    this.applyFilteringParameters();
                    GLUtils.drawPre();
                    GLUtils.setMap(icon, x, y, (int)((float)icon.getIconWidth() / 2.0f));
                    GLUtils.drawPost();
                }
                this.applyFilteringParameters();
                GLUtils.drawPre();
                GLUtils.setMap(this.textureAtlas.getAtlasSprite("contact"), x, y, 16.0f);
                GLUtils.drawPost();
                if (!this.options.showFacing) continue;
                this.applyFilteringParameters();
                GLUtils.drawPre();
                GLUtils.setMap(this.textureAtlas.getAtlasSprite("facing"), x, y, 16.0f);
                GLUtils.drawPost();
            }
            catch (Exception localException) {
                System.err.println("Error rendering mob icon! " + localException.getLocalizedMessage() + " contact type " + (Object)((Object)contact.type));
            }
            finally {
                GLShim.glPopMatrix();
            }
        }
    }

    private void applyFilteringParameters() {
        if (this.options.filtering) {
            GLShim.glTexParameteri(3553, 10241, 9729);
            GLShim.glTexParameteri(3553, 10240, 9729);
            GLShim.glTexParameteri(3553, 10242, 10496);
            GLShim.glTexParameteri(3553, 10243, 10496);
        } else {
            GLShim.glTexParameteri(3553, 10241, 9728);
            GLShim.glTexParameteri(3553, 10240, 9728);
        }
    }
}

