/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import net.fabricmc.installer.repackage.com.google.gson.Gson;
import net.fabricmc.installer.repackage.com.google.gson.GsonBuilder;
import net.fabricmc.installer.repackage.com.google.gson.JsonObject;
import net.fabricmc.installer.util.MinecraftLaunchJson;
import net.fabricmc.installer.util.Reference;

public class Utils {
    public static final DateFormat ISO_8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final ResourceBundle BUNDLE = ResourceBundle.getBundle("lang/installer", Locale.getDefault(), new ResourceBundle.Control(){

        /*
         * Loose catch block
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            block28: {
                String bundleName = this.toBundleName(baseName, locale);
                String resourceName = this.toResourceName(bundleName, "properties");
                Throwable throwable = null;
                try (InputStream stream = loader.getResourceAsStream(resourceName);){
                    if (stream != null) {
                        try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                            PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(reader);
                            return propertyResourceBundle;
                        }
                    }
                    break block28;
                    {
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throw throwable3;
                        }
                    }
                }
            }
            return super.newBundle(baseName, locale, format, loader, reload);
        }
    });

    public static File findDefaultUserDir() {
        String home = System.getProperty("user.home", ".");
        String os = System.getProperty("os.name").toLowerCase();
        File homeDir = new File(home);
        File dir = os.contains("win") && System.getenv("APPDATA") != null ? new File(System.getenv("APPDATA")) : (os.contains("mac") ? new File(homeDir, "Library" + File.separator + "Application Support") : homeDir);
        return dir;
    }

    public static File findDefaultInstallDir() {
        String home = System.getProperty("user.home", ".");
        String os = System.getProperty("os.name").toLowerCase();
        File homeDir = new File(home);
        File dir = os.contains("win") && System.getenv("APPDATA") != null ? new File(System.getenv("APPDATA"), ".minecraft") : (os.contains("mac") ? new File(homeDir, "Library" + File.separator + "Application Support" + File.separator + "minecraft") : new File(homeDir, ".minecraft"));
        return dir;
    }

    public static String readTextFile(URL url) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }

    public static void writeToFile(File file, String string) throws FileNotFoundException {
        try (PrintStream printStream = new PrintStream(new FileOutputStream(file));){
            printStream.print(string);
        }
    }

    public static String readFile(File file) throws IOException {
        return new String(Files.readAllBytes(file.toPath()));
    }

    public static void downloadFile(URL url, File file) throws IOException {
        if (!file.getParentFile().isDirectory() && !file.mkdirs()) {
            throw new IOException("Could not create directory for " + file.getAbsolutePath() + "!");
        }
        try (InputStream in = url.openStream();){
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static MinecraftLaunchJson getLaunchMeta(String loaderVersion) throws IOException {
        String url = String.format("%s/%s/%s/%s/%3$s-%4$s.json", Reference.mavenServerUrl, "net/fabricmc", "fabric-loader", loaderVersion);
        String fabricInstallMeta = Utils.readTextFile(new URL(url));
        JsonObject installMeta = GSON.fromJson(fabricInstallMeta, JsonObject.class);
        return new MinecraftLaunchJson(installMeta);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getProfileIcon() {
        try (InputStream is = Utils.class.getClassLoader().getResourceAsStream("profile_icon.png");){
            int len;
            byte[] ret = new byte[4096];
            int offset = 0;
            while ((len = is.read(ret, offset, ret.length - offset)) != -1) {
                if ((offset += len) != ret.length) continue;
                ret = Arrays.copyOf(ret, ret.length * 2);
            }
            String string = "data:image/png;base64," + Base64.getEncoder().encodeToString(Arrays.copyOf(ret, offset));
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "TNT";
        }
    }
}

