/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.fabricmc.installer.util.Utils;
import net.fabricmc.installer.util.VersionMeta;

public class LauncherMeta {
    private static LauncherMeta launcherMeta = null;
    public List<Version> versions;

    public static LauncherMeta getLauncherMeta() throws IOException {
        if (launcherMeta == null) {
            launcherMeta = LauncherMeta.load();
        }
        return launcherMeta;
    }

    private static LauncherMeta load() throws IOException {
        URL url = new URL("https://launchermeta.mojang.com/mc/game/version_manifest.json");
        URLConnection conn = url.openConnection();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
            LauncherMeta launcherMeta = Utils.GSON.fromJson((Reader)reader, LauncherMeta.class);
            return launcherMeta;
        }
    }

    public Version getVersion(String version) {
        return this.versions.stream().filter(v -> v.id.equals(version)).findFirst().orElse(null);
    }

    public static class Version {
        public String id;
        public String type;
        public String url;
        public String time;
        public String releaseTime;
        private transient VersionMeta versionMeta = null;

        public VersionMeta getVersionMeta() throws IOException {
            if (this.versionMeta == null) {
                URL url = new URL(this.url);
                URLConnection conn = url.openConnection();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                    this.versionMeta = Utils.GSON.fromJson((Reader)reader, VersionMeta.class);
                }
            }
            return this.versionMeta;
        }
    }
}

