/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer.server;

import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import net.fabricmc.installer.InstallerGui;
import net.fabricmc.installer.repackage.com.google.gson.JsonObject;
import net.fabricmc.installer.server.ServerHandler;
import net.fabricmc.installer.util.LauncherMeta;
import net.fabricmc.installer.util.Utils;

public class ServerPostInstallDialog
extends JDialog {
    private static final int MB = 1000000;
    private JPanel panel = new JPanel();
    private ServerHandler serverHandler;
    private String minecraftVersion;
    private File installDir;
    private File minecraftJar;
    private File minecraftJarTmp;
    private JLabel serverJarLabel;
    private JButton downloadButton;
    private JButton generateButton;

    private ServerPostInstallDialog(ServerHandler handler) throws HeadlessException {
        super((Frame)InstallerGui.instance, true);
        this.serverHandler = handler;
        this.minecraftVersion = (String)handler.gameVersionComboBox.getSelectedItem();
        this.installDir = new File(handler.installLocation.getText());
        this.minecraftJar = new File(this.installDir, "server.jar");
        this.minecraftJarTmp = new File(this.installDir, "server.jar.tmp");
        this.panel.setLayout(new BoxLayout(this.panel, 3));
        this.initComponents();
        this.setContentPane(this.panel);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemClassLoader().getResource("icon.png")));
    }

    private void initComponents() {
        this.addRow(this.panel, panel -> panel.add(this.fontSize(new JLabel(Utils.BUNDLE.getString("progress.done.server")), 20)));
        this.addRow(this.panel, panel -> panel.add(this.fontSize(new JLabel(Utils.BUNDLE.getString("prompt.server.info.jar")), 15)));
        this.addRow(this.panel, panel -> {
            this.updateServerJarLabel();
            panel.add(this.serverJarLabel);
            this.downloadButton = new JButton(Utils.BUNDLE.getString("prompt.server.jar"));
            this.downloadButton.addActionListener(e -> this.doServerJarDownload());
            panel.add(this.downloadButton);
        });
        this.addRow(this.panel, panel -> panel.add(this.fontSize(new JLabel(Utils.BUNDLE.getString("prompt.server.info.command")), 15)));
        this.addRow(this.panel, panel -> {
            JTextField textField = new JTextField("java -jar fabric-server-launch.jar");
            textField.setHorizontalAlignment(0);
            panel.add(textField);
        });
        this.addRow(this.panel, panel -> {
            panel.add(new JLabel(Utils.BUNDLE.getString("prompt.server.info.scipt")));
            this.generateButton = new JButton(Utils.BUNDLE.getString("prompt.server.generate"));
            this.generateButton.addActionListener(e -> this.generateLaunchScripts());
            panel.add(this.generateButton);
        });
        this.addRow(this.panel, panel -> {
            JButton closeButton = new JButton(Utils.BUNDLE.getString("progress.done"));
            closeButton.addActionListener(e -> {
                this.setVisible(false);
                this.dispose();
            });
            panel.add(closeButton);
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isValidJarPresent() {
        if (!this.minecraftJar.exists()) {
            return false;
        }
        try (JarFile jarFile = new JarFile(this.minecraftJar);){
            JarEntry versionEntry = jarFile.getJarEntry("version.json");
            if (versionEntry == null) {
                boolean bl2 = false;
                return bl2;
            }
            InputStream inputStream = jarFile.getInputStream(versionEntry);
            JsonObject jsonObject = Utils.GSON.fromJson((Reader)new InputStreamReader(inputStream), JsonObject.class);
            boolean bl = jsonObject.get("id").getAsString().equals(this.minecraftVersion) || jsonObject.get("name").getAsString().equals(this.minecraftVersion);
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void updateServerJarLabel() {
        if (this.serverJarLabel == null) {
            this.serverJarLabel = new JLabel();
        }
        if (this.isValidJarPresent()) {
            this.serverJarLabel.setText(new MessageFormat(Utils.BUNDLE.getString("prompt.server.jar.valid")).format(new Object[]{this.minecraftVersion}));
            this.color(this.serverJarLabel, Color.GREEN.darker());
        } else {
            this.serverJarLabel.setText(new MessageFormat(Utils.BUNDLE.getString("prompt.server.jar.invalid")).format(new Object[]{this.minecraftVersion}));
            this.color(this.serverJarLabel, Color.RED);
        }
    }

    private void doServerJarDownload() {
        this.downloadButton.setEnabled(false);
        try {
            Files.deleteIfExists(this.minecraftJar.toPath());
            Files.deleteIfExists(this.minecraftJarTmp.toPath());
        }
        catch (IOException e) {
            this.color(this.serverJarLabel, Color.RED).setText(e.getMessage());
            this.serverHandler.error(e);
            return;
        }
        new Thread(() -> {
            try {
                int len;
                URL url = new URL(LauncherMeta.getLauncherMeta().getVersion((String)this.minecraftVersion).getVersionMeta().downloads.get((Object)"server").url);
                HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
                int finalSize = httpConnection.getContentLength();
                BufferedInputStream inputStream = new BufferedInputStream(httpConnection.getInputStream());
                FileOutputStream outputStream = new FileOutputStream(this.minecraftJarTmp);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, 1024);
                byte[] buffer = new byte[1024];
                long downloaded = 0L;
                while ((len = inputStream.read(buffer, 0, 1024)) >= 0) {
                    String labelText = String.format("Downloading %d/%d MB", (downloaded += (long)len) / 1000000L, finalSize / 1000000);
                    SwingUtilities.invokeLater(() -> this.color(this.serverJarLabel, Color.BLUE).setText(labelText));
                    bufferedOutputStream.write(buffer, 0, len);
                }
                bufferedOutputStream.close();
                inputStream.close();
                Files.move(this.minecraftJarTmp.toPath(), this.minecraftJar.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.updateServerJarLabel();
                this.downloadButton.setEnabled(true);
            }
            catch (IOException e) {
                this.color(this.serverJarLabel, Color.RED).setText(e.getMessage());
                this.serverHandler.error(e);
            }
        }).start();
    }

    private void generateLaunchScripts() {
        String launchCommand = "java -jar fabric-server-launch.jar";
        HashMap<File, String> launchScripts = new HashMap<File, String>();
        launchScripts.put(new File(this.installDir, "start.bat"), launchCommand + "\npause");
        launchScripts.put(new File(this.installDir, "start.sh"), "#!/usr/bin/env bash\n" + launchCommand);
        boolean exists = launchScripts.entrySet().stream().anyMatch(entry -> ((File)entry.getKey()).exists());
        if (exists && JOptionPane.showConfirmDialog(this, Utils.BUNDLE.getString("prompt.server.overwrite"), "Warning", 0) == 1) {
            return;
        }
        launchScripts.forEach((file, s) -> {
            try {
                Utils.writeToFile(file, s);
                file.setExecutable(true, false);
            }
            catch (FileNotFoundException e) {
                this.serverHandler.error(e);
            }
        });
    }

    private JLabel fontSize(JLabel label, int size) {
        label.setFont(new Font(label.getFont().getName(), 0, size));
        return label;
    }

    private JLabel color(JLabel label, Color color) {
        label.setForeground(color);
        return label;
    }

    private void addRow(Container parent, Consumer<JPanel> consumer) {
        JPanel panel = new JPanel(new FlowLayout());
        consumer.accept(panel);
        parent.add(panel);
    }

    public static void show(ServerHandler serverHandler) throws ClassNotFoundException, UnsupportedLookAndFeelException, InstantiationException, IllegalAccessException {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        ServerPostInstallDialog dialog = new ServerPostInstallDialog(serverHandler);
        dialog.pack();
        dialog.setTitle(Utils.BUNDLE.getString("installer.title"));
        dialog.setLocationRelativeTo(InstallerGui.instance);
        dialog.setVisible(true);
    }
}

