/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer.client;

import java.awt.Desktop;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.MessageFormat;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import net.fabricmc.installer.Handler;
import net.fabricmc.installer.InstallerGui;
import net.fabricmc.installer.client.ClientInstaller;
import net.fabricmc.installer.client.ProfileInstaller;
import net.fabricmc.installer.util.ArgumentParser;
import net.fabricmc.installer.util.InstallerProgress;
import net.fabricmc.installer.util.Reference;
import net.fabricmc.installer.util.Utils;

public class ClientHandler
extends Handler {
    private JCheckBox createProfile;

    @Override
    public String name() {
        return "Client";
    }

    @Override
    public void install() {
        String gameVersion = (String)this.gameVersionComboBox.getSelectedItem();
        String loaderVersion = (String)this.loaderVersionComboBox.getSelectedItem();
        System.out.println("Installing");
        new Thread(() -> {
            try {
                this.updateProgress(new MessageFormat(Utils.BUNDLE.getString("progress.installing")).format(new Object[]{loaderVersion}));
                File mcPath = new File(this.installLocation.getText());
                if (!mcPath.exists()) {
                    throw new RuntimeException(Utils.BUNDLE.getString("progress.exception.no.launcher.directory"));
                }
                String profileName = ClientInstaller.install(mcPath, gameVersion, loaderVersion, this);
                if (this.createProfile.isSelected()) {
                    ProfileInstaller.setupProfile(mcPath, profileName, gameVersion);
                }
                SwingUtilities.invokeLater(() -> this.showInstalledMessage(loaderVersion, gameVersion));
            }
            catch (Exception e) {
                this.error(e);
            }
            this.buttonInstall.setEnabled(true);
        }).start();
    }

    private void showInstalledMessage(String loaderVersion, String gameVersion) {
        JEditorPane pane = new JEditorPane("text/html", "<html><body style=\"" + this.buildEditorPaneStyle() + "\">" + new MessageFormat(Utils.BUNDLE.getString("prompt.install.successful")).format(new Object[]{loaderVersion, gameVersion, Reference.fabricApiUrl}) + "</body></html>");
        pane.setEditable(false);
        pane.addHyperlinkListener(e -> {
            block3: {
                try {
                    if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) break block3;
                    if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                        break block3;
                    }
                    throw new UnsupportedOperationException("Failed to open " + e.getURL().toString());
                }
                catch (Throwable throwable) {
                    this.error(throwable);
                }
            }
        });
        JOptionPane.showMessageDialog(null, pane, Utils.BUNDLE.getString("prompt.install.successful.title"), 1);
    }

    @Override
    public void installCli(ArgumentParser args) throws Exception {
        File file = new File(args.get("dir"));
        if (!file.exists()) {
            throw new FileNotFoundException("Launcher directory not found at " + file.getAbsolutePath());
        }
        String gameVersion = this.getGameVersion(args);
        String loaderVersion = this.getLoaderVersion(args);
        String profileName = ClientInstaller.install(file, gameVersion, loaderVersion, InstallerProgress.CONSOLE);
        if (args.has("noprofile")) {
            return;
        }
        ProfileInstaller.setupProfile(file, profileName, gameVersion);
    }

    @Override
    public String cliHelp() {
        return "-dir <install dir, required> -mcversion <minecraft version, default latest> -loader <loader version, default latest>";
    }

    @Override
    public void setupPane1(JPanel pane, InstallerGui installerGui) {
    }

    @Override
    public void setupPane2(JPanel pane, InstallerGui installerGui) {
        this.addRow(pane, jPanel -> {
            this.createProfile = new JCheckBox(Utils.BUNDLE.getString("option.create.profile"), true);
            jPanel.add(this.createProfile);
        });
        this.installLocation.setText(Utils.findDefaultInstallDir().getAbsolutePath());
    }
}

